/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.util.Hashtable;
import ubc.cs.JLog.Foundation.jDebugProver;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jProver;
import ubc.cs.JLog.Foundation.jRetryQueryThread;
import ubc.cs.JLog.Foundation.jUserQueryEvent;
import ubc.cs.JLog.Foundation.jVariableVector;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.jPredicateTerms;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class jAPIQueryThread
extends jRetryQueryThread {
    protected String qinput;
    protected jPrologServiceBroadcaster beginq = null;
    protected jPrologServiceBroadcaster retryq = null;
    protected jPrologServiceBroadcaster endq = null;
    protected jPrologServiceBroadcaster debugm = null;
    protected jProver prover = null;
    protected jPredicateTerms query = null;
    protected boolean result = false;
    protected int retry = 0;
    protected jVariableVector var_vector = null;
    protected Hashtable var_prebindings;
    protected RuntimeException result_exception = null;

    public jAPIQueryThread(jPrologServices jPrologServices2, String string) {
        super(jPrologServices2);
        this.var_prebindings = null;
        this.qinput = string;
    }

    public jAPIQueryThread(jPrologServices jPrologServices2, Hashtable hashtable, String string) {
        super(jPrologServices2);
        this.setName("APIQueryThread");
        this.var_prebindings = hashtable;
        this.qinput = string;
    }

    public void setListeners(jPrologServiceBroadcaster jPrologServiceBroadcaster2, jPrologServiceBroadcaster jPrologServiceBroadcaster3, jPrologServiceBroadcaster jPrologServiceBroadcaster4, jPrologServiceBroadcaster jPrologServiceBroadcaster5, jPrologServiceBroadcaster jPrologServiceBroadcaster6) {
        this.setStoppedListeners(jPrologServiceBroadcaster5);
        this.beginq = jPrologServiceBroadcaster2;
        this.retryq = jPrologServiceBroadcaster3;
        this.endq = jPrologServiceBroadcaster4;
        this.debugm = jPrologServiceBroadcaster6;
    }

    public synchronized void retry() {
        ++this.retry;
        this.notify();
    }

    protected synchronized boolean waitForRetry() {
        while (this.retry <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        --this.retry;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.result_exception = null;
        if (this.beginq != null) {
            this.beginq.broadcastEvent(new jPrologServiceEvent());
        }
        try {
            this.query();
            if (this.retryq != null) {
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
            while (this.result) {
                if (!this.waitForRetry()) continue;
                this.internal_retry();
                if (this.retryq == null) continue;
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
        }
        catch (RuntimeException runtimeException) {
            this.result_exception = runtimeException;
        }
        finally {
            if (this.allow_release) {
                this.prolog.release();
            }
            this.var_vector = null;
            if (this.endq != null) {
                this.endq.broadcastEvent(new jPrologServiceEvent());
            }
        }
    }

    protected void query() {
        pParseStream pParseStream2 = new pParseStream(this.qinput, this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        this.result = false;
        this.query = pParseStream2.parseQuery(this.var_prebindings);
        if (this.query != null) {
            this.var_vector = new jVariableVector();
            this.query.registerVariables(this.var_vector);
            this.internal_prove();
        }
    }

    protected void internal_prove() {
        this.prover = this.prolog.getDebugging() ? new jDebugProver(this.prolog.getKnowledgeBase(), this.debugm) : new jProver(this.prolog.getKnowledgeBase());
        this.result = this.prover.prove(this.query);
    }

    protected void internal_retry() {
        if (this.result) {
            this.result = this.prover.retry();
        }
    }

    public Hashtable getResultHashtable() {
        if (this.query == null) {
            return null;
        }
        if (this.result) {
            Hashtable<String, jTerm> hashtable = new Hashtable<String, jTerm>();
            jVariable[] jVariableArray = this.var_vector.getVariables();
            int n = jVariableArray.length;
            for (int i = 0; i < n; ++i) {
                if (!jVariableArray[i].isNamedForDisplay()) continue;
                hashtable.put(jVariableArray[i].getName(), jVariableArray[i].getTerm());
            }
            return hashtable;
        }
        return null;
    }

    public RuntimeException getResultException() {
        return this.result_exception;
    }
}

