/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.PrintWriter;
import ubc.cs.JLog.Foundation.iPrologServiceText;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pParseStream;

public class jConsultSourceThread
extends jPrologServiceThread {
    protected iPrologServiceText source;
    protected PrintWriter errors;
    protected jPrologServiceBroadcaster begin = null;
    protected jPrologServiceBroadcaster end = null;

    public jConsultSourceThread(jPrologServices jPrologServices2, iPrologServiceText iPrologServiceText2, PrintWriter printWriter) {
        super(jPrologServices2);
        this.setName("ConsultSourceThread");
        this.source = iPrologServiceText2;
        this.errors = printWriter;
    }

    public void setListeners(jPrologServiceBroadcaster jPrologServiceBroadcaster2, jPrologServiceBroadcaster jPrologServiceBroadcaster3, jPrologServiceBroadcaster jPrologServiceBroadcaster4) {
        this.setStoppedListeners(jPrologServiceBroadcaster4);
        this.begin = jPrologServiceBroadcaster2;
        this.end = jPrologServiceBroadcaster3;
    }

    public void run() {
        if (this.begin != null) {
            this.begin.broadcastEvent(new jPrologServiceEvent());
        }
        this.errors.println("consulting.");
        this.errors.flush();
        try {
            pParseStream pParseStream2 = new pParseStream(this.source.getText(), this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
            try {
                pParseStream2.parseSource();
                this.prolog.getKnowledgeBase().consult();
                this.errors.print("completed.");
                this.errors.flush();
            }
            catch (SyntaxErrorException syntaxErrorException) {
                this.errors.println("SYNTAX ERROR:");
                this.errors.println(syntaxErrorException.toString() + "\n");
                this.source.setCaretPosition(syntaxErrorException.getPosition());
                this.source.select(syntaxErrorException.getPosition(), syntaxErrorException.getPosition() + 1);
                this.errors.print("terminated.");
                this.errors.flush();
                this.source.requestFocus();
            }
            catch (TokenizeStreamException tokenizeStreamException) {
                this.errors.println("INTERNAL ERROR:");
                this.errors.println(tokenizeStreamException.toString() + "\n");
                this.source.setCaretPosition(tokenizeStreamException.getPosition());
                this.source.select(tokenizeStreamException.getPosition(), tokenizeStreamException.getPosition() + 1);
                this.errors.print("terminated.");
                this.errors.flush();
                this.source.requestFocus();
            }
            catch (RuntimeException runtimeException) {
                this.errors.println("ERROR:");
                this.errors.println(runtimeException.toString() + "\n");
                this.errors.print("terminated.");
                this.errors.flush();
                this.source.requestFocus();
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Error error) {
            this.errors.println("JAVA ERROR:");
            this.errors.println(error.toString() + "\n");
            this.errors.print("terminated.");
            this.errors.flush();
            this.source.requestFocus();
            throw error;
        }
        finally {
            if (this.allow_release) {
                this.prolog.release();
            }
            if (this.end != null) {
                this.end.broadcastEvent(new jPrologServiceEvent());
            }
        }
    }

    public boolean isCurrentlyConsulting() {
        return true;
    }

    public void printOutput(String string) {
        this.errors.print(string);
        this.errors.flush();
    }
}

