/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import ubc.cs.JLog.Animation.aAnimationEnvironment;
import ubc.cs.JLog.Foundation.NoThreadAvailableException;
import ubc.cs.JLog.Foundation.iPrologFileServices;
import ubc.cs.JLog.Foundation.jAPIConsultThread;
import ubc.cs.JLog.Foundation.jAPIQueryThread;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jPrologFileServices;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jUserQueryEvent;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jTermTranslation;

public class jPrologAPI {
    protected static final int QUERY_STATE_WAITING = 0;
    protected static final int QUERY_STATE_SUCCEEDED = 1;
    protected static final int QUERY_STATE_FINISHED = 2;
    protected jPrologServices prolog = new jPrologServices(new jKnowledgeBase(), new pPredicateRegistry(), new pOperatorRegistry());
    protected jAPIQueryThread thread = null;
    protected Hashtable var_translation_keys = null;
    protected jTermTranslation translations = null;
    protected int query_state = 0;

    public jPrologAPI(String string) {
        this.prolog.setFileServices(new jPrologFileServices());
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(string);
    }

    public jPrologAPI(InputStream inputStream) throws IOException {
        this.prolog.setFileServices(new jPrologFileServices());
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(this.prolog.getFileServices().getTextFromInputStream(inputStream));
    }

    public jPrologAPI(String string, iPrologFileServices iPrologFileServices2, PrintWriter printWriter, BufferedReader bufferedReader, aAnimationEnvironment aAnimationEnvironment2) {
        if (iPrologFileServices2 != null) {
            this.prolog.setFileServices(iPrologFileServices2);
        } else {
            this.prolog.setFileServices(new jPrologFileServices());
        }
        this.prolog.setDefaultOutput(printWriter);
        this.prolog.setDefaultInput(bufferedReader);
        this.prolog.setAnimationEnvironment(aAnimationEnvironment2);
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(string);
    }

    public jPrologAPI(InputStream inputStream, iPrologFileServices iPrologFileServices2, PrintWriter printWriter, BufferedReader bufferedReader, aAnimationEnvironment aAnimationEnvironment2) throws IOException {
        if (iPrologFileServices2 != null) {
            this.prolog.setFileServices(iPrologFileServices2);
        } else {
            this.prolog.setFileServices(new jPrologFileServices());
        }
        this.prolog.setDefaultOutput(printWriter);
        this.prolog.setDefaultInput(bufferedReader);
        this.prolog.setAnimationEnvironment(aAnimationEnvironment2);
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(this.prolog.getFileServices().getTextFromInputStream(inputStream));
    }

    protected void initTranslation() {
        this.var_translation_keys = new Hashtable();
        this.translations = new jTermTranslation(this.prolog);
        this.translations.setDefaults();
    }

    protected void initPrologListeners() {
        this.prolog.addRetryQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                jUserQueryEvent jUserQueryEvent2;
                if (jPrologServiceEvent2 instanceof jUserQueryEvent && (jUserQueryEvent2 = (jUserQueryEvent)jPrologServiceEvent2).getResult()) {
                    jPrologAPI.this.setQueryResultState(true);
                }
            }
        });
        this.prolog.addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                if (jPrologAPI.this.query_state == 0) {
                    jPrologAPI.this.setQueryResultState(false);
                }
            }
        });
    }

    protected void initConsultSource(String string) {
        pParseStream pParseStream2 = new pParseStream(string, this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        this.prolog.start();
        this.consultSource(string);
    }

    public String getRequiredCreditInfo() {
        return jPrologServices.getRequiredCreditInfo();
    }

    public void setFailUnknownPredicate(boolean bl) {
        this.prolog.setFailUnknownPredicate(bl);
    }

    public boolean getFailUnknownPredicate() {
        return this.prolog.getFailUnknownPredicate();
    }

    public void setVariableTranslationKeys(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            this.var_translation_keys.remove(string);
        } else {
            this.var_translation_keys.put(string, new KeyPairs(object, object2));
        }
    }

    public jTermTranslation getTranslation() {
        return this.translations;
    }

    public void setTranslation(jTermTranslation jTermTranslation2) {
        this.translations = jTermTranslation2;
    }

    public synchronized void consultSource(String string) {
        jAPIConsultThread jAPIConsultThread2;
        pParseStream pParseStream2 = new pParseStream(string, this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        this.joinForcedQueryCompletion();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.prolog.start(jAPIConsultThread2 = new jAPIConsultThread(this.prolog, string))) {
            throw new NoThreadAvailableException("consult failed, other events pending.");
        }
        try {
            jAPIConsultThread2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RuntimeException runtimeException = jAPIConsultThread2.getResultException();
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public Hashtable query(String string) {
        return this.query(string, null);
    }

    public synchronized Hashtable queryOnce(String string) {
        Hashtable hashtable = this.query(string, null);
        this.stop();
        return hashtable;
    }

    public synchronized Hashtable query(String string, Hashtable hashtable) {
        Hashtable<String, jTerm> hashtable2 = null;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            hashtable2 = new Hashtable<String, jTerm>();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object v = hashtable.get(string2);
                KeyPairs keyPairs = (KeyPairs)this.var_translation_keys.get(string2);
                jTerm jTerm2 = keyPairs != null && keyPairs.termkey != null ? this.translations.createTermFromObject(v, keyPairs.termkey) : this.translations.createTermFromObject(v);
                hashtable2.put(string2, jTerm2);
            }
        }
        this.joinForcedQueryCompletion();
        this.thread = new jAPIQueryThread(this.prolog, hashtable2, string);
        if (!this.prolog.start(this.thread)) {
            throw new NoThreadAvailableException("query failed, other events pending.");
        }
        return this.waitForCompletion();
    }

    public synchronized Hashtable queryOnce(String string, Hashtable hashtable) {
        Hashtable hashtable2 = this.query(string, hashtable);
        this.stop();
        return hashtable2;
    }

    public synchronized Hashtable retry() {
        this.query_state = 0;
        if (this.thread == null || !this.thread.isAlive()) {
            return null;
        }
        this.thread.retry();
        return this.waitForCompletion();
    }

    public synchronized void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
        }
        this.query_state = 2;
    }

    protected synchronized Hashtable waitForCompletion() {
        while (this.query_state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        Serializable serializable = this.thread.getResultException();
        if (serializable != null) {
            throw serializable;
        }
        serializable = null;
        if (this.query_state == 1) {
            serializable = this.thread.getResultHashtable();
        }
        this.query_state = 0;
        if (serializable != null) {
            Enumeration enumeration = ((Hashtable)serializable).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                jTerm jTerm2 = (jTerm)((Hashtable)serializable).get(string);
                KeyPairs keyPairs = (KeyPairs)this.var_translation_keys.get(string);
                Object object = keyPairs != null && keyPairs.objkey != null ? this.translations.createObjectFromTerm(jTerm2, keyPairs.objkey) : this.translations.createObjectFromTerm(jTerm2);
                ((Hashtable)serializable).put(string, object);
            }
        }
        return serializable;
    }

    protected synchronized void setQueryResultState(boolean bl) {
        if (this.query_state == 0) {
            this.query_state = bl ? 1 : 2;
            this.notify();
        }
    }

    protected synchronized void joinForcedQueryCompletion() {
        if (this.thread != null && this.thread.isAlive()) {
            this.query_state = 2;
            this.thread.broadcasted_stop();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.query_state = 0;
    }

    protected class KeyPairs {
        public Object termkey;
        public Object objkey;

        public KeyPairs(Object object, Object object2) {
            this.termkey = object;
            this.objkey = object2;
        }
    }
}

