/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ubc.cs.JLog.Animation.aAnimationEnvironment;
import ubc.cs.JLog.Foundation.LoadLibraryException;
import ubc.cs.JLog.Foundation.iPrologFileServices;
import ubc.cs.JLog.Foundation.jAPIConsultThread;
import ubc.cs.JLog.Foundation.jAPIQueryThread;
import ubc.cs.JLog.Foundation.jConsultAndQueryThread;
import ubc.cs.JLog.Foundation.jConsultSourceThread;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jResetDatabaseThread;
import ubc.cs.JLog.Foundation.jUserQueryThread;
import ubc.cs.JLog.Parser.pGenericOperatorEntry;
import ubc.cs.JLog.Parser.pGenericPredicateEntry;
import ubc.cs.JLog.Parser.pOperatorEntry;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPredicateEntry;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Terms.jPredefined;
import ubc.cs.JLog.Terms.jPredefinedTerms;

public class jPrologServices {
    static final String LIB_INIT_TOC_PREFIX = "INIT_";
    static final String LIB_INIT_TOC_POSTFIX = "LIB.TOC";
    static final String LIB_POSTFIX_STR = "Lib.jar";
    static final String BUILTINS_LIB = "builtins";
    protected jPrologServiceThread thread = null;
    protected jKnowledgeBase database;
    protected pPredicateRegistry predicates;
    protected pOperatorRegistry operators;
    protected Random rand;
    protected jPrologServiceBroadcaster beginQuery;
    protected jPrologServiceBroadcaster retryQuery;
    protected jPrologServiceBroadcaster endQuery;
    protected jPrologServiceBroadcaster beginConsult;
    protected jPrologServiceBroadcaster endConsult;
    protected jPrologServiceBroadcaster threadStopped;
    protected jPrologServiceBroadcaster debugMessages;
    protected jPrologServiceBroadcaster stateChanged;
    protected PrintWriter default_output = null;
    protected PrintWriter current_output = null;
    protected BufferedReader default_input = null;
    protected BufferedReader current_input = null;
    protected iPrologFileServices fileservices = null;
    protected aAnimationEnvironment animation = null;
    protected boolean debugging = false;
    protected boolean fail_unknown_predicate = false;

    public static String getRequiredCreditInfo() {
        return "JLog v1.3.5  Prolog in Java.\n\nCreated by Glendon Holst\n for Alan Mackworth and \"Computational Intelligence: A Logical Approach\" text.\n\nCopyright 1998, 2000, 2002, 2004, 2005 by University of British Columbia\n\nReleased under the GNU GPL (General Public License):\n JLog is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;\n without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n See the GNU General Public License for more details: <http://www.fsf.org> or <http://www.gnu.org>.\n\n Source code available from: <http://jlogic.sourceforge.net/> or <http://sourceforge.net/projects/jlogic>\n\nThis information string must remain, in its entirety, in all distributions of this work (derivative or otherwise).\n Authors of derivative works may note their involvement by appending their information below:\n\n---------------------------------------------\n\n";
    }

    public jPrologServices(jKnowledgeBase jKnowledgeBase2, pPredicateRegistry pPredicateRegistry2, pOperatorRegistry pOperatorRegistry2) {
        this.database = jKnowledgeBase2;
        this.predicates = pPredicateRegistry2;
        this.operators = pOperatorRegistry2;
        this.beginQuery = new jPrologServiceBroadcaster();
        this.retryQuery = new jPrologServiceBroadcaster();
        this.endQuery = new jPrologServiceBroadcaster();
        this.beginConsult = new jPrologServiceBroadcaster();
        this.endConsult = new jPrologServiceBroadcaster();
        this.threadStopped = new jPrologServiceBroadcaster();
        this.debugMessages = new jPrologServiceBroadcaster();
        this.stateChanged = new jPrologServiceBroadcaster();
        this.rand = new Random();
        jPredefinedTerms jPredefinedTerms2 = new jPredefinedTerms(this);
        ((jPredefined)jPredefinedTerms2).register();
    }

    public synchronized void addBeginQueryListener(jPrologServiceListener jPrologServiceListener2) {
        this.beginQuery.addListener(jPrologServiceListener2);
    }

    public synchronized void addRetryQueryListener(jPrologServiceListener jPrologServiceListener2) {
        this.retryQuery.addListener(jPrologServiceListener2);
    }

    public synchronized void addEndQueryListener(jPrologServiceListener jPrologServiceListener2) {
        this.endQuery.addListener(jPrologServiceListener2);
    }

    public synchronized void addBeginConsultListener(jPrologServiceListener jPrologServiceListener2) {
        this.beginConsult.addListener(jPrologServiceListener2);
    }

    public synchronized void addEndConsultListener(jPrologServiceListener jPrologServiceListener2) {
        this.endConsult.addListener(jPrologServiceListener2);
    }

    public synchronized void removeBeginQueryListener(jPrologServiceListener jPrologServiceListener2) {
        this.beginQuery.removeListener(jPrologServiceListener2);
    }

    public synchronized void removeRetryQueryListener(jPrologServiceListener jPrologServiceListener2) {
        this.retryQuery.removeListener(jPrologServiceListener2);
    }

    public synchronized void removeEndQueryListener(jPrologServiceListener jPrologServiceListener2) {
        this.endQuery.removeListener(jPrologServiceListener2);
    }

    public synchronized void removeBeginConsultListener(jPrologServiceListener jPrologServiceListener2) {
        this.beginConsult.removeListener(jPrologServiceListener2);
    }

    public synchronized void removeEndConsultListener(jPrologServiceListener jPrologServiceListener2) {
        this.endConsult.removeListener(jPrologServiceListener2);
    }

    public synchronized void addThreadStoppedListener(jPrologServiceListener jPrologServiceListener2) {
        this.threadStopped.addListener(jPrologServiceListener2);
    }

    public synchronized void removeThreadStoppedListener(jPrologServiceListener jPrologServiceListener2) {
        this.threadStopped.removeListener(jPrologServiceListener2);
    }

    public synchronized void addDebugMessagesListener(jPrologServiceListener jPrologServiceListener2) {
        this.debugMessages.addListener(jPrologServiceListener2);
    }

    public synchronized void removeDebugMessagesListener(jPrologServiceListener jPrologServiceListener2) {
        this.debugMessages.removeListener(jPrologServiceListener2);
    }

    public synchronized void addStateChangedListener(jPrologServiceListener jPrologServiceListener2) {
        this.stateChanged.addListener(jPrologServiceListener2);
    }

    public synchronized void removeStateChangedListener(jPrologServiceListener jPrologServiceListener2) {
        this.stateChanged.removeListener(jPrologServiceListener2);
    }

    public synchronized boolean isAvailable() {
        return this.thread == null || !this.thread.isAlive();
    }

    public synchronized boolean start(jPrologServiceThread jPrologServiceThread2) {
        if (this.isAvailable()) {
            this.resetOutput();
            this.resetInput();
            this.thread = jPrologServiceThread2;
            if (this.thread instanceof jUserQueryThread) {
                ((jUserQueryThread)this.thread).setListeners(this.beginQuery, this.retryQuery, this.endQuery, this.threadStopped, this.debugMessages);
            } else if (this.thread instanceof jAPIQueryThread) {
                ((jAPIQueryThread)this.thread).setListeners(this.beginQuery, this.retryQuery, this.endQuery, this.threadStopped, this.debugMessages);
            } else if (this.thread instanceof jAPIConsultThread) {
                ((jAPIConsultThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.threadStopped);
            } else if (this.thread instanceof jConsultSourceThread) {
                ((jConsultSourceThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.threadStopped);
            } else if (this.thread instanceof jResetDatabaseThread) {
                ((jResetDatabaseThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.threadStopped);
            } else if (this.thread instanceof jConsultAndQueryThread) {
                ((jConsultAndQueryThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.beginQuery, this.retryQuery, this.endQuery, this.debugMessages, this.threadStopped);
            }
            this.thread.start();
            return true;
        }
        return false;
    }

    public synchronized void start() {
        this.resetKnowledgeBase();
        this.resetOutput();
        this.resetInput();
    }

    public synchronized void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
        } else {
            this.thread = null;
        }
    }

    public synchronized void release() {
        this.thread = null;
    }

    public synchronized void suspend() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.suspend();
        } else {
            this.thread = null;
        }
    }

    public synchronized void resume() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.resume();
        } else {
            this.thread = null;
        }
    }

    public void resetKnowledgeBase() {
        this.database.clearRules();
        this.predicates.clearPredicates();
        this.operators.clearOperators();
        jPredefinedTerms jPredefinedTerms2 = new jPredefinedTerms(this);
        ((jPredefined)jPredefinedTerms2).register();
        try {
            this.loadLibrary(BUILTINS_LIB);
        }
        catch (IOException iOException) {
            throw new LoadLibraryException("IO Error loading builtins library");
        }
    }

    public jKnowledgeBase getKnowledgeBase() {
        return this.database;
    }

    public pPredicateRegistry getPredicateRegistry() {
        return this.predicates;
    }

    public pOperatorRegistry getOperatorRegistry() {
        return this.operators;
    }

    public void setAnimationEnvironment(aAnimationEnvironment aAnimationEnvironment2) {
        this.animation = aAnimationEnvironment2;
    }

    public aAnimationEnvironment getAnimationEnvironment() {
        return this.animation;
    }

    public void loadLibrary(String string) throws IOException {
        iPrologFileServices iPrologFileServices2 = this.getFileServices();
        if (iPrologFileServices2 == null) {
            throw new LoadLibraryException("Missing FileServices");
        }
        String string2 = LIB_INIT_TOC_PREFIX + string.toUpperCase() + LIB_INIT_TOC_POSTFIX;
        try {
            InputStream inputStream = iPrologFileServices2.getResourceInputStreamFromFilename(string2);
            this.loadLibraryFromTOC(string, inputStream);
            return;
        }
        catch (IOException iOException) {
            ZipEntry zipEntry;
            String string3 = string + LIB_POSTFIX_STR;
            ZipInputStream zipInputStream = new ZipInputStream(iPrologFileServices2.getInputStreamFromFilename(string3));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(string2)) continue;
                this.loadLibraryFromTOC(string, zipInputStream);
                break;
            }
            return;
        }
    }

    protected void loadLibraryFromTOC(String string, InputStream inputStream) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.commentChar(35);
        streamTokenizer.quoteChar(34);
        streamTokenizer.ordinaryChar(58);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.lowerCaseMode(false);
        streamTokenizer.eolIsSignificant(true);
        while ((n = streamTokenizer.nextToken()) != -1) {
            if (n == -3 && streamTokenizer.sval.equalsIgnoreCase("LoadClass")) {
                this.loadLibraryTOCParseLoadClass(string, streamTokenizer);
            } else if (n == -3 && streamTokenizer.sval.equalsIgnoreCase("RegisterGenericPredicateEntry")) {
                this.loadLibraryTOCParseGenericPredicate(string, streamTokenizer);
            } else if (n == -3 && streamTokenizer.sval.equalsIgnoreCase("RegisterGenericOperatorEntry")) {
                this.loadLibraryTOCParseGenericOperator(string, streamTokenizer);
            } else if (n == 10) {
                streamTokenizer.pushBack();
            }
            do {
                if ((n = streamTokenizer.nextToken()) != -1) continue;
                streamTokenizer.pushBack();
            } while (n != -1 && n != 10);
        }
    }

    protected void loadLibraryTOCParseLoadClass(String string, StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        if (n != 58) {
            throw new LoadLibraryException("Expected ':' separator in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        n = streamTokenizer.nextToken();
        if (n != -3) {
            throw new LoadLibraryException("Expected Class Name in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        this.loadClass(string, streamTokenizer.sval);
    }

    protected void loadLibraryTOCParseGenericPredicate(String string, StreamTokenizer streamTokenizer) throws IOException {
        String string2;
        int n = streamTokenizer.nextToken();
        if (n != 58) {
            throw new LoadLibraryException("Expected ':' separator in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        n = streamTokenizer.nextToken();
        if (n == 34) {
            string2 = streamTokenizer.sval;
        } else if (n == -3) {
            string2 = streamTokenizer.sval;
        } else {
            throw new LoadLibraryException("Expected Name string in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        n = streamTokenizer.nextToken();
        if (n != -2) {
            throw new LoadLibraryException("Expected Arity integer in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        int n2 = (int)Math.round(streamTokenizer.nval);
        n = streamTokenizer.nextToken();
        if (n != -3) {
            throw new LoadLibraryException("Expected Class name in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        String string3 = streamTokenizer.sval;
        pGenericPredicateEntry pGenericPredicateEntry2 = new pGenericPredicateEntry(string2, n2, this.loadClass(string, string3));
        this.registerPredicateOperatorEntryInstance(string, pGenericPredicateEntry2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadLibraryTOCParseGenericOperator(String string, StreamTokenizer streamTokenizer) throws IOException {
        boolean bl;
        int n;
        String string2;
        int n2 = streamTokenizer.nextToken();
        if (n2 != 58) {
            throw new LoadLibraryException("Expected ':' separator in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        n2 = streamTokenizer.nextToken();
        if (n2 == 34) {
            string2 = streamTokenizer.sval;
        } else {
            if (n2 != -3) throw new LoadLibraryException("Expected Name string in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
            string2 = streamTokenizer.sval;
        }
        n2 = streamTokenizer.nextToken();
        if (n2 != -3) throw new LoadLibraryException("Expected Type (FX,FY,XFX,XFY,YFX,XF,YF) in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        if (streamTokenizer.sval.equalsIgnoreCase("FX")) {
            n = 1;
        } else if (streamTokenizer.sval.equalsIgnoreCase("FY")) {
            n = 2;
        } else if (streamTokenizer.sval.equalsIgnoreCase("XFX")) {
            n = 17;
        } else if (streamTokenizer.sval.equalsIgnoreCase("XFY")) {
            n = 18;
        } else if (streamTokenizer.sval.equalsIgnoreCase("YFX")) {
            n = 33;
        } else if (streamTokenizer.sval.equalsIgnoreCase("XF")) {
            n = 16;
        } else {
            if (!streamTokenizer.sval.equalsIgnoreCase("YF")) throw new LoadLibraryException("Expected Type (FX,FY,XFX,XFY,YFX,XF,YF) in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
            n = 32;
        }
        n2 = streamTokenizer.nextToken();
        if (n2 != -2) {
            throw new LoadLibraryException("Expected Priority integer in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        int n3 = (int)Math.round(streamTokenizer.nval);
        n2 = streamTokenizer.nextToken();
        if (n2 != -3) throw new LoadLibraryException("Expected Allow Atoms boolean (TRUE,FALSE) in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        if (streamTokenizer.sval.equalsIgnoreCase("TRUE")) {
            bl = true;
        } else {
            if (!streamTokenizer.sval.equalsIgnoreCase("FALSE")) throw new LoadLibraryException("Expected Allow Atoms boolean (TRUE,FALSE) in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
            bl = false;
        }
        n2 = streamTokenizer.nextToken();
        if (n2 != -3) {
            throw new LoadLibraryException("Expected Class name in TOC at line: " + Integer.toString(streamTokenizer.lineno()));
        }
        String string3 = streamTokenizer.sval;
        pGenericOperatorEntry pGenericOperatorEntry2 = new pGenericOperatorEntry(string2, n, n3, bl, this.loadClass(string, string3));
        this.registerPredicateOperatorEntryInstance(string, pGenericOperatorEntry2);
    }

    public Class loadClass(String string, String string2) {
        Object object;
        iPrologFileServices iPrologFileServices2 = this.getFileServices();
        Class<?> clazz = null;
        Object var5_5 = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                object = iPrologFileServices2.getURLFromFilename(string + LIB_POSTFIX_STR);
                Class<?> clazz2 = Class.forName("java.net.URLClassLoader");
                Constructor<?> constructor = null;
                ClassLoader classLoader = null;
                constructor = clazz2.getConstructor(URL[].class);
                classLoader = (ClassLoader)constructor.newInstance(new Object[]{new URL[]{object}});
                clazz = classLoader.loadClass(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new LoadLibraryException("Failed to load class: " + string2);
        }
        try {
            if (pPredicateEntry.class.isAssignableFrom(clazz) || pOperatorEntry.class.isAssignableFrom(clazz)) {
                var5_5 = clazz.newInstance();
                this.registerPredicateOperatorEntryInstance(string, var5_5);
            } else if (jPredefined.class.isAssignableFrom(clazz)) {
                object = clazz.getConstructor(jPrologServices.class, String.class);
                var5_5 = ((Constructor)object).newInstance(this, string);
                this.registerPredefinedInstance(string, var5_5);
            }
        }
        catch (Exception exception) {
            throw new LoadLibraryException("Failed to instantiate or register class instance");
        }
        return clazz;
    }

    protected void registerPredicateOperatorEntryInstance(String string, Object object) {
        if (object instanceof pPredicateEntry) {
            pPredicateEntry pPredicateEntry2 = (pPredicateEntry)object;
            pPredicateRegistry pPredicateRegistry2 = this.getPredicateRegistry();
            pPredicateEntry pPredicateEntry3 = pPredicateRegistry2.getPredicate(pPredicateEntry2.getName(), pPredicateEntry2.getArity());
            if (pPredicateEntry3 == null) {
                pPredicateEntry2.setLibrary(string);
                pPredicateRegistry2.addPredicate(pPredicateEntry2);
            } else if (pPredicateEntry3.getLibrary() != null && !pPredicateEntry3.getLibrary().equals(string)) {
                String string2 = "Predicate " + pPredicateEntry3.getName() + "/" + pPredicateEntry3.getArity() + " already exists in library " + pPredicateEntry3.getLibrary();
                throw new LoadLibraryException(string2);
            }
        } else if (object instanceof pOperatorEntry) {
            pOperatorEntry pOperatorEntry2 = (pOperatorEntry)object;
            pOperatorRegistry pOperatorRegistry2 = this.getOperatorRegistry();
            pOperatorEntry pOperatorEntry3 = pOperatorRegistry2.getOperator(pOperatorEntry2.getName(), pOperatorEntry2.hasLHS());
            if (pOperatorEntry3 == null) {
                pOperatorEntry2.setLibrary(string);
                pOperatorRegistry2.addOperator(pOperatorEntry2);
            } else if (pOperatorEntry3.getLibrary() != null && !pOperatorEntry3.getLibrary().equals(string)) {
                String string3 = "Operator " + pOperatorEntry3.getName() + " already exists in library " + pOperatorEntry3.getLibrary();
                throw new LoadLibraryException(string3);
            }
        }
    }

    protected void registerPredefinedInstance(String string, Object object) {
        if (object instanceof jPredefined) {
            jPredefined jPredefined2 = (jPredefined)object;
            jPredefined2.register();
        }
    }

    public void setDebugging(boolean bl) {
        boolean bl2 = this.debugging;
        this.debugging = bl;
        if (this.stateChanged != null && bl2 != this.debugging) {
            this.stateChanged.broadcastEvent(new jPrologServiceEvent());
        }
    }

    public boolean getDebugging() {
        return this.debugging;
    }

    public void setFailUnknownPredicate(boolean bl) {
        boolean bl2 = this.fail_unknown_predicate;
        this.fail_unknown_predicate = bl;
        if (this.stateChanged != null && bl2 != this.fail_unknown_predicate) {
            this.stateChanged.broadcastEvent(new jPrologServiceEvent());
        }
    }

    public boolean getFailUnknownPredicate() {
        return this.fail_unknown_predicate;
    }

    public Random getRandomGenerator() {
        return this.rand;
    }

    public void setDefaultOutput(PrintWriter printWriter) {
        this.default_output = printWriter;
        this.current_output = printWriter;
    }

    public void setOutput(PrintWriter printWriter) {
        this.current_output = printWriter;
    }

    public PrintWriter getOutput() {
        return this.current_output;
    }

    public void resetOutput() {
        this.current_output = this.default_output;
    }

    public void printOutput(String string) {
        if (this.current_output != null) {
            this.current_output.print(string);
            this.current_output.flush();
        }
    }

    public void setDefaultInput(BufferedReader bufferedReader) {
        this.default_input = bufferedReader;
        this.current_input = bufferedReader;
    }

    public void setInput(BufferedReader bufferedReader) {
        this.current_input = bufferedReader;
    }

    public BufferedReader getInput() {
        return this.current_input;
    }

    public void resetInput() {
        this.current_input = this.default_input;
    }

    public void setFileServices(iPrologFileServices iPrologFileServices2) {
        this.fileservices = iPrologFileServices2;
    }

    public iPrologFileServices getFileServices() {
        return this.fileservices;
    }
}

