/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.util.Enumeration;
import java.util.Vector;
import ubc.cs.JLog.Foundation.InvalidLibraryEntryException;
import ubc.cs.JLog.Foundation.UnmatchedRuleException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jRule;
import ubc.cs.JLog.Terms.Goals.jPredicateGoal;
import ubc.cs.JLog.Terms.iNameArity;
import ubc.cs.JLog.Terms.jBuiltinRule;
import ubc.cs.JLog.Terms.jCompoundTerm;

public class jRuleDefinitions
implements iNameArity {
    protected Vector rules = null;
    protected String rule_name = null;
    protected int rule_arity = -1;
    protected String library = null;
    protected boolean builtin = false;

    protected jRuleDefinitions() {
    }

    public jRuleDefinitions(String string, int n) {
        this.rules = new Vector();
        this.rule_name = string;
        this.rule_arity = n;
    }

    public String getName() {
        return this.rule_name;
    }

    public int getArity() {
        return this.rule_arity;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setLibrary(String string) {
        if (this.library != null) {
            throw new InvalidLibraryEntryException();
        }
        this.library = string;
    }

    public String getLibrary() {
        return this.library;
    }

    public boolean sameLibrary(String string) {
        if (this.library == null && string == null) {
            return true;
        }
        if (this.library == null || string == null) {
            return false;
        }
        return this.library.equals(string);
    }

    public int size() {
        return this.rules.size();
    }

    public jRule getRuleAt(int n) {
        return (jRule)this.rules.elementAt(n);
    }

    public final boolean match(iNameArity iNameArity2) {
        return iNameArity2.getName().equals(this.rule_name) && iNameArity2.getArity() == this.rule_arity;
    }

    public void addRule(jRule jRule2) {
        if (!this.match(jRule2)) {
            throw new UnmatchedRuleException();
        }
        this.rules.addElement(jRule2);
    }

    public void addRuleFirst(jRule jRule2) {
        if (!this.match(jRule2)) {
            throw new UnmatchedRuleException();
        }
        this.rules.insertElementAt(jRule2, 0);
    }

    public void addRuleLast(jRule jRule2) {
        if (!this.match(jRule2)) {
            throw new UnmatchedRuleException();
        }
        this.rules.insertElementAt(jRule2, this.rules.size());
    }

    public void removeRule(jRule jRule2) {
        this.rules.removeElement(jRule2);
    }

    public void clearRules() {
        this.rules = new Vector();
    }

    public Enumeration enumRules() {
        return this.rules.elements();
    }

    public jPredicateGoal createGoal(jCompoundTerm jCompoundTerm2) {
        return new jPredicateGoal(this, jCompoundTerm2);
    }

    public void consult(jKnowledgeBase jKnowledgeBase2) {
        Enumeration enumeration = this.enumRules();
        while (enumeration.hasMoreElements()) {
            jRule jRule2 = (jRule)enumeration.nextElement();
            if (jRule2 instanceof jBuiltinRule) {
                this.builtin = true;
            }
            jRule2.consult(jKnowledgeBase2);
        }
    }

    public final boolean prove(jPredicateGoal jPredicateGoal2, iGoalStack iGoalStack2) {
        int n;
        while ((n = jPredicateGoal2.getNextRuleNumber()) < this.rules.size()) {
            if (!((jRule)this.rules.elementAt(n)).unify(jPredicateGoal2, iGoalStack2)) continue;
            return true;
        }
        return false;
    }

    public boolean retry(jPredicateGoal jPredicateGoal2) {
        return jPredicateGoal2.getRuleNumber() < this.rules.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() + "/" + Integer.toString(this.getArity()));
        String string = this.getLibrary();
        if (string != null) {
            stringBuffer.append(" library:" + string);
        }
        return stringBuffer.toString();
    }
}

