/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.PrintWriter;
import ubc.cs.JLog.Foundation.InvalidInputException;
import ubc.cs.JLog.Foundation.iPrologServiceText;
import ubc.cs.JLog.Foundation.jDebugProver;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jProver;
import ubc.cs.JLog.Foundation.jRetryQueryThread;
import ubc.cs.JLog.Foundation.jUserQueryEvent;
import ubc.cs.JLog.Foundation.jVariableVector;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.jPredicateTerms;
import ubc.cs.JLog.Terms.jVariable;

public class jUserQueryThread
extends jRetryQueryThread {
    protected iPrologServiceText qinput;
    protected PrintWriter output;
    protected jPrologServiceBroadcaster beginq = null;
    protected jPrologServiceBroadcaster retryq = null;
    protected jPrologServiceBroadcaster endq = null;
    protected jPrologServiceBroadcaster debugm = null;
    protected jProver prover = null;
    protected jPredicateTerms query = null;
    protected boolean result = false;
    protected int retry = 0;
    protected jVariableVector var_vector = null;

    public jUserQueryThread(jPrologServices jPrologServices2, iPrologServiceText iPrologServiceText2, PrintWriter printWriter) {
        super(jPrologServices2);
        this.setName("UserQueryThread");
        this.qinput = iPrologServiceText2;
        this.output = printWriter;
    }

    public void setListeners(jPrologServiceBroadcaster jPrologServiceBroadcaster2, jPrologServiceBroadcaster jPrologServiceBroadcaster3, jPrologServiceBroadcaster jPrologServiceBroadcaster4, jPrologServiceBroadcaster jPrologServiceBroadcaster5, jPrologServiceBroadcaster jPrologServiceBroadcaster6) {
        this.setStoppedListeners(jPrologServiceBroadcaster5);
        this.beginq = jPrologServiceBroadcaster2;
        this.retryq = jPrologServiceBroadcaster3;
        this.endq = jPrologServiceBroadcaster4;
        this.debugm = jPrologServiceBroadcaster6;
    }

    public synchronized void retry() {
        ++this.retry;
        this.notify();
    }

    protected synchronized boolean waitForRetry() {
        while (this.retry <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        --this.retry;
        return true;
    }

    public void run() {
        if (this.beginq != null) {
            this.beginq.broadcastEvent(new jPrologServiceEvent());
        }
        try {
            this.query();
            if (this.retryq != null) {
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
            while (this.result) {
                if (!this.waitForRetry()) continue;
                this.internal_retry();
                this.internal_display();
                if (this.retryq == null) continue;
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Error error) {
            this.output.println("JAVA ERROR:");
            this.output.println(error.toString() + "\n");
            this.output.flush();
            this.qinput.requestFocus();
            throw error;
        }
        finally {
            if (this.allow_release) {
                this.prolog.release();
            }
            this.var_vector = null;
            if (this.endq != null) {
                this.endq.broadcastEvent(new jPrologServiceEvent());
            }
        }
    }

    protected void query() {
        pParseStream pParseStream2 = new pParseStream(this.qinput.getText(), this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        try {
            this.result = false;
            this.query = pParseStream2.parseQuery();
            if (this.query != null) {
                this.var_vector = new jVariableVector();
                this.query.registerVariables(this.var_vector);
                this.output.println(this.query.toString(true));
                this.output.flush();
                this.internal_prove();
                this.internal_display();
            } else {
                this.output.println("empty query.");
                this.output.flush();
            }
        }
        catch (SyntaxErrorException syntaxErrorException) {
            this.output.println("SYNTAX ERROR:");
            this.output.println(syntaxErrorException.toString() + "\n");
            this.output.flush();
            this.qinput.setCaretPosition(syntaxErrorException.getPosition());
            this.qinput.select(syntaxErrorException.getPosition(), syntaxErrorException.getPosition() + 1);
            this.qinput.requestFocus();
        }
        catch (TokenizeStreamException tokenizeStreamException) {
            this.output.println("INTERNAL ERROR:");
            this.output.println(tokenizeStreamException.toString() + "\n");
            this.output.flush();
            this.qinput.setCaretPosition(tokenizeStreamException.getPosition());
            this.qinput.select(tokenizeStreamException.getPosition(), tokenizeStreamException.getPosition() + 1);
            this.qinput.requestFocus();
        }
        catch (RuntimeException runtimeException) {
            this.output.println("ERROR:");
            this.output.println(runtimeException.toString() + "\n");
            this.output.flush();
            this.qinput.requestFocus();
        }
    }

    protected void internal_prove() {
        this.prover = this.prolog.getDebugging() ? new jDebugProver(this.prolog.getKnowledgeBase(), this.debugm) : new jProver(this.prolog.getKnowledgeBase());
        this.result = this.prover.prove(this.query);
    }

    protected void internal_retry() {
        if (this.result) {
            try {
                this.result = this.prover.retry();
            }
            catch (InvalidInputException invalidInputException) {
                if (!invalidInputException.isHandled()) {
                    this.output.println("ERROR:");
                    this.output.println(invalidInputException.toString() + "\n");
                    this.output.flush();
                    this.qinput.requestFocus();
                }
                this.result = false;
            }
            catch (RuntimeException runtimeException) {
                this.output.println("ERROR:");
                this.output.println(runtimeException.toString() + "\n");
                this.output.flush();
                this.qinput.requestFocus();
                this.result = false;
            }
        }
    }

    protected void internal_display() {
        if (this.query == null) {
            return;
        }
        if (this.result) {
            jVariable[] jVariableArray = this.var_vector.getVariables();
            int n = jVariableArray.length;
            for (int i = 0; i < n; ++i) {
                if (!jVariableArray[i].isNamedForDisplay()) continue;
                this.output.println(jVariableArray[i].getName() + " = " + jVariableArray[i].toString(false));
            }
            this.output.println("yes");
        } else {
            this.output.println("no");
        }
        this.output.flush();
    }
}

