/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import ubc.cs.JLog.Foundation.InvalidLibraryEntryException;
import ubc.cs.JLog.Parser.InvalidOperatorEntryException;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pPacket;
import ubc.cs.JLog.Parser.pTermToPacketHashtable;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pVariableRegistry;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jTerm;

public abstract class pOperatorEntry {
    public static final int FX = 1;
    public static final int FY = 2;
    public static final int XFX = 17;
    public static final int XFY = 18;
    public static final int YFX = 33;
    public static final int XF = 16;
    public static final int YF = 32;
    public static final int NON_ASSOCIATIVE = 0;
    public static final int LEFT_ASSOCIATIVE = 1;
    public static final int RIGHT_ASSOCIATIVE = 2;
    protected String name;
    protected int type;
    protected int priority;
    protected String library = null;

    public pOperatorEntry(String string, int n, int n2) {
        this.name = string;
        this.type = n;
        this.priority = n2;
        if (string == null || string.length() <= 0 || !this.isValidType() || n2 < 0 || n2 > 1200) {
            throw new InvalidOperatorEntryException();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLHS() {
        return (this.type & 0xF0) != 0;
    }

    public boolean hasRHS() {
        return (this.type & 0xF) != 0;
    }

    public boolean isAtomPermitted() {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getAssociativity() {
        if ((this.type & 0x20) == 32) {
            return 1;
        }
        if ((this.type & 2) == 2) {
            return 2;
        }
        return 0;
    }

    public boolean isNonAssociativeLeft() {
        return (this.type & 0x20) != 32;
    }

    public boolean isNonAssociativeRight() {
        return (this.type & 2) != 2;
    }

    public boolean isValidType() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    public void setLibrary(String string) {
        if (this.library != null) {
            throw new InvalidLibraryEntryException();
        }
        this.library = string;
    }

    public String getLibrary() {
        return this.library;
    }

    public boolean sameLibrary(String string) {
        if (this.library == null && string == null) {
            return true;
        }
        if (this.library == null || string == null) {
            return false;
        }
        return this.library.equals(string);
    }

    public jTerm createOperator(pToken pToken2, pPacket pPacket2, pPacket pPacket3, pVariableRegistry pVariableRegistry2, pTermToPacketHashtable pTermToPacketHashtable2) {
        jTerm jTerm2 = null;
        jTerm jTerm3 = null;
        if (this.isAtomPermitted() && pPacket2 == null && pPacket3 == null) {
            return new jAtom(this.name);
        }
        if (this.hasLHS() && (pPacket2 == null || (jTerm2 = pPacket2.getTerm(pVariableRegistry2, pTermToPacketHashtable2)) == null)) {
            throw new SyntaxErrorException("LHS term required before operator '" + this.getName() + "' at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
        }
        if (this.hasRHS() && (pPacket3 == null || (jTerm3 = pPacket3.getTerm(pVariableRegistry2, pTermToPacketHashtable2)) == null)) {
            throw new SyntaxErrorException("RHS term required after operator '" + this.getName() + "' at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
        }
        return this.createOperator(jTerm2, jTerm3);
    }

    public abstract jTerm createOperator(jTerm var1, jTerm var2);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append("(");
        switch (this.getType()) {
            case 1: {
                stringBuffer.append("FX");
                break;
            }
            case 2: {
                stringBuffer.append("FY");
                break;
            }
            case 17: {
                stringBuffer.append("XFX");
                break;
            }
            case 18: {
                stringBuffer.append("XFY");
                break;
            }
            case 33: {
                stringBuffer.append("YFX");
                break;
            }
            case 16: {
                stringBuffer.append("XF");
                break;
            }
            case 32: {
                stringBuffer.append("YF");
                break;
            }
            default: {
                stringBuffer.append("???");
            }
        }
        stringBuffer.append(",");
        stringBuffer.append(Integer.toString(this.getPriority()));
        stringBuffer.append(",");
        stringBuffer.append(this.isAtomPermitted() ? "atom allowed" : "atom *not* allowed");
        stringBuffer.append(")");
        String string = this.getLibrary();
        if (string != null) {
            stringBuffer.append(" library:" + string);
        }
        return stringBuffer.toString();
    }
}

