/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.io.Reader;
import java.util.Stack;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pArray;
import ubc.cs.JLog.Parser.pArrayList;
import ubc.cs.JLog.Parser.pComma;
import ubc.cs.JLog.Parser.pCommand;
import ubc.cs.JLog.Parser.pCons;
import ubc.cs.JLog.Parser.pDCG;
import ubc.cs.JLog.Parser.pEOF;
import ubc.cs.JLog.Parser.pEndBrace;
import ubc.cs.JLog.Parser.pEndBracket;
import ubc.cs.JLog.Parser.pEndParen;
import ubc.cs.JLog.Parser.pIf;
import ubc.cs.JLog.Parser.pInteger;
import ubc.cs.JLog.Parser.pList;
import ubc.cs.JLog.Parser.pListCons;
import ubc.cs.JLog.Parser.pName;
import ubc.cs.JLog.Parser.pNumber;
import ubc.cs.JLog.Parser.pOperator;
import ubc.cs.JLog.Parser.pOperatorEntry;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPacket;
import ubc.cs.JLog.Parser.pParens;
import ubc.cs.JLog.Parser.pPredicate;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Parser.pReal;
import ubc.cs.JLog.Parser.pStartBrace;
import ubc.cs.JLog.Parser.pStartBracket;
import ubc.cs.JLog.Parser.pStartParen;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pTokenizeStream;
import ubc.cs.JLog.Parser.pUnaryNumber;
import ubc.cs.JLog.Parser.pVar;
import ubc.cs.JLog.Parser.pVariable;
import ubc.cs.JLog.Terms.Entries.pCommandOperatorEntry;
import ubc.cs.JLog.Terms.Entries.pConsOperatorEntry;
import ubc.cs.JLog.Terms.Entries.pDCGOperatorEntry;
import ubc.cs.JLog.Terms.Entries.pIfOperatorEntry;

class pPreParseStream {
    protected pTokenizeStream tokenizer;
    protected pPredicateRegistry predicates;
    protected pOperatorRegistry operators;

    public pPreParseStream(String string, pPredicateRegistry pPredicateRegistry2, pOperatorRegistry pOperatorRegistry2) {
        this.tokenizer = new pTokenizeStream(string);
        this.predicates = pPredicateRegistry2;
        this.operators = pOperatorRegistry2;
    }

    public pPreParseStream(Reader reader, pPredicateRegistry pPredicateRegistry2, pOperatorRegistry pOperatorRegistry2) {
        this.tokenizer = new pTokenizeStream(reader);
        this.predicates = pPredicateRegistry2;
        this.operators = pOperatorRegistry2;
    }

    public pPacket parse() {
        pPacket pPacket2 = this.parseTerm(false);
        pToken pToken2 = this.tokenizer.getNextToken();
        if (pToken2 instanceof pEOF && pPacket2 == null || pToken2 instanceof pName && ((pName)pToken2).getToken().equals(".")) {
            return pPacket2;
        }
        throw new SyntaxErrorException("Expected '.' at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
    }

    protected pParens parseParens() {
        pToken pToken2 = this.tokenizer.getNextToken();
        if (!(pToken2 instanceof pStartParen)) {
            throw new SyntaxErrorException("Expected '(' at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
        }
        pPacket pPacket2 = this.parseTerm(false);
        pToken pToken3 = this.tokenizer.getNextToken();
        if (pToken3 instanceof pEndParen) {
            return new pParens((pStartParen)pToken2, pPacket2);
        }
        throw new SyntaxErrorException("Expected ')' at ", pToken3.getPosition(), pToken3.getLine(), pToken3.getCharPos());
    }

    protected pPredicate parseBrace() {
        pToken pToken2 = this.tokenizer.getNextToken();
        if (!(pToken2 instanceof pStartBrace)) {
            throw new SyntaxErrorException("Expected '{' at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
        }
        pPacket pPacket2 = this.parseTerm(false);
        pToken pToken3 = this.tokenizer.getNextToken();
        if (pToken3 instanceof pEndBrace) {
            return new pPredicate(this.predicates, "{}", pToken2, new pParens((pStartBrace)pToken2, pPacket2));
        }
        throw new SyntaxErrorException("Expected '}' at ", pToken3.getPosition(), pToken3.getLine(), pToken3.getCharPos());
    }

    protected pList parseList() {
        pPacket pPacket2 = null;
        pToken pToken2 = this.tokenizer.getNextToken();
        if (!(pToken2 instanceof pStartBracket)) {
            throw new SyntaxErrorException("Expected '[' at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
        }
        pPacket pPacket3 = this.parseTerm(false);
        pToken pToken3 = this.tokenizer.getNextToken();
        if (pToken3 instanceof pListCons) {
            if (pPacket3 == null) {
                throw new SyntaxErrorException("Expected term after '[' at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
            }
            pPacket2 = this.parseTerm(true);
            if (pPacket2 == null) {
                throw new SyntaxErrorException("Expected term after '|' at ", pToken3.getPosition(), pToken3.getLine(), pToken3.getCharPos());
            }
            pToken3 = this.tokenizer.getNextToken();
        }
        if (pToken3 instanceof pEndBracket) {
            return new pList(pToken2, pPacket3, pPacket2);
        }
        throw new SyntaxErrorException("Expected ']' at ", pToken3.getPosition(), pToken3.getLine(), pToken3.getCharPos());
    }

    protected pPacket parseTerm(boolean bl) {
        Stack stack = new Stack();
        boolean bl2 = false;
        while (true) {
            pPacket pPacket2;
            pToken pToken2;
            if ((pToken2 = this.tokenizer.getNextToken()) instanceof pComma && bl) {
                this.tokenizer.pushBackToken(pToken2);
                return this.finalizePacketStack(stack);
            }
            if (pToken2 instanceof pName && !bl2 && ((pName)pToken2).isPotentialPredicate()) {
                pPacket2 = new pPredicate(this.predicates, pToken2, this.parseParens());
            } else if (pToken2 instanceof pStartBrace && !bl2) {
                this.tokenizer.pushBackToken(pToken2);
                pPacket2 = this.parseBrace();
            } else if (pToken2 instanceof pStartBracket && !bl2) {
                this.tokenizer.pushBackToken(pToken2);
                pPacket2 = this.parseList();
            } else if (pToken2 instanceof pStartParen && !bl2) {
                this.tokenizer.pushBackToken(pToken2);
                pPacket2 = this.parseParens();
            } else if (pToken2 instanceof pArray && !bl2) {
                pPacket2 = new pArrayList((pArray)pToken2);
            } else if (pToken2 instanceof pVariable && !bl2) {
                pPacket2 = new pVar((pVariable)pToken2);
            } else if ((pToken2 instanceof pReal || pToken2 instanceof pInteger || pToken2 instanceof pUnaryNumber) && !bl2) {
                pPacket2 = new pNumber(pToken2);
            } else {
                if (pToken2 instanceof pUnaryNumber) {
                    this.tokenizer.pushBackToken(((pUnaryNumber)pToken2).getValue());
                    this.tokenizer.pushBackToken(((pUnaryNumber)pToken2).getSign());
                    continue;
                }
                pPacket2 = this.packetizeToken(pToken2, bl2);
                if (pPacket2 == null || bl2 && !(pPacket2 instanceof pOperator)) {
                    this.tokenizer.pushBackToken(pToken2);
                    return this.finalizePacketStack(stack);
                }
            }
            bl2 = !(pPacket2 instanceof pOperator) || !((pOperator)pPacket2).hasRHS();
            this.updatePacketStack(stack, pPacket2);
        }
    }

    protected void updatePacketStack(Stack stack, pPacket pPacket2) {
        block11: {
            if (stack.empty()) {
                stack.push(pPacket2);
            } else if (pPacket2 instanceof pOperator && ((pOperator)pPacket2).hasLHS()) {
                pOperator pOperator2 = (pOperator)pPacket2;
                pPacket pPacket3 = (pPacket)stack.pop();
                if (pPacket3 instanceof pOperator) {
                    pOperator pOperator3 = (pOperator)pPacket3;
                    while (true) {
                        if (pOperator2.getPriority() < pOperator3.getPriority() || pOperator2.getPriority() == pOperator3.getPriority() && !pOperator3.isNonAssociativeRight()) {
                            pOperator2.setLHS(pOperator3.getRHS());
                            pOperator3.setRHS(pOperator2);
                            stack.push(pOperator3);
                            stack.push(pOperator2);
                            break block11;
                        }
                        if (pOperator2.getPriority() > pOperator3.getPriority() && stack.empty() || pOperator2.getPriority() == pOperator3.getPriority() && !pOperator2.isNonAssociativeLeft()) {
                            pOperator2.setLHS(pOperator3);
                            if (!stack.empty()) {
                                ((pOperator)stack.peek()).setRHS(pOperator2);
                            }
                            stack.push(pOperator2);
                            break block11;
                        }
                        if (stack.empty()) break;
                        pOperator3 = (pOperator)stack.pop();
                    }
                    pToken pToken2 = pPacket2.getToken();
                    throw new SyntaxErrorException("Parentheses required. Associativity rules do not permit use of operator at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
                }
                pOperator2.setLHS(pPacket3);
                stack.push(pOperator2);
            } else {
                pOperator pOperator4 = (pOperator)stack.peek();
                if (pPacket2 instanceof pOperator) {
                    pOperator pOperator5 = (pOperator)pPacket2;
                    pToken pToken3 = pPacket2.getToken();
                    if (pOperator5.getPriority() > pOperator4.getPriority() || pOperator5.getPriority() == pOperator4.getPriority() && pOperator4.isNonAssociativeRight()) {
                        throw new SyntaxErrorException("Operator with lower priority number or parenthesis expected for operator at ", pToken3.getPosition(), pToken3.getLine(), pToken3.getCharPos());
                    }
                    stack.push(pOperator5);
                }
                pOperator4.setRHS(pPacket2);
            }
        }
    }

    protected pPacket finalizePacketStack(Stack stack) {
        if (stack.empty()) {
            return null;
        }
        pPacket pPacket2 = (pPacket)stack.peek();
        if (pPacket2 instanceof pOperator) {
            ((pOperator)pPacket2).verifyCompletion();
        }
        return (pPacket)stack.firstElement();
    }

    protected pPacket packetizeToken(pToken pToken2, boolean bl) {
        if (!(pToken2 instanceof pName) && !(pToken2 instanceof pComma)) {
            return null;
        }
        pOperatorEntry pOperatorEntry2 = this.operators.getOperator(pToken2.getToken(), bl);
        if (pOperatorEntry2 != null) {
            if (pToken2 instanceof pComma && pOperatorEntry2 instanceof pConsOperatorEntry) {
                return new pCons((pConsOperatorEntry)pOperatorEntry2, pToken2);
            }
            if (pOperatorEntry2 instanceof pIfOperatorEntry) {
                return new pIf((pIfOperatorEntry)pOperatorEntry2, pToken2);
            }
            if (pOperatorEntry2 instanceof pCommandOperatorEntry) {
                return new pCommand((pCommandOperatorEntry)pOperatorEntry2, pToken2);
            }
            if (pOperatorEntry2 instanceof pDCGOperatorEntry) {
                return new pDCG((pDCGOperatorEntry)pOperatorEntry2, pToken2);
            }
            return new pOperator(pOperatorEntry2, pToken2);
        }
        if (bl) {
            return null;
        }
        return new pPredicate(this.predicates, pToken2);
    }
}

