/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import ubc.cs.JLog.Foundation.InvalidLibraryEntryException;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Terms.InvalidPredicateNameException;
import ubc.cs.JLog.Terms.iNameArity;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jCompoundTerm;
import ubc.cs.JLog.Terms.jVariable;

public abstract class pPredicateEntry
implements iNameArity {
    public static final int NARY_ARITY = -1;
    protected String name;
    protected int arity;
    protected String library = null;

    public pPredicateEntry(String string, int n) {
        this.name = string;
        this.arity = n;
        if (string == null || string.length() <= 0) {
            throw new InvalidPredicateNameException();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isArity(int n) {
        return this.arity == n;
    }

    public void setLibrary(String string) {
        if (this.library != null) {
            throw new InvalidLibraryEntryException();
        }
        this.library = string;
    }

    public String getLibrary() {
        return this.library;
    }

    public boolean sameLibrary(String string) {
        if (this.library == null && string == null) {
            return true;
        }
        if (this.library == null || string == null) {
            return false;
        }
        return this.library.equals(string);
    }

    public iPredicate createPredicate(pToken pToken2, jCompoundTerm jCompoundTerm2) {
        if (!this.isArity(jCompoundTerm2.size())) {
            throw new SyntaxErrorException("Term with arity " + String.valueOf(this.arity) + " expected for predicate at ", pToken2.getPosition(), pToken2.getLine(), pToken2.getCharPos());
        }
        return this.createPredicate(jCompoundTerm2);
    }

    public iPredicate createPredicate() {
        jCompoundTerm jCompoundTerm2 = new jCompoundTerm();
        for (int i = 0; i < this.arity; ++i) {
            jCompoundTerm2.addTerm(new jVariable("_"));
        }
        return this.createPredicate(jCompoundTerm2);
    }

    public abstract iPredicate createPredicate(jCompoundTerm var1);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() + "/" + Integer.toString(this.getArity()));
        String string = this.getLibrary();
        if (string != null) {
            stringBuffer.append(" library:" + string);
        }
        return stringBuffer.toString();
    }
}

