/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pArray;
import ubc.cs.JLog.Parser.pComma;
import ubc.cs.JLog.Parser.pEOF;
import ubc.cs.JLog.Parser.pEndBrace;
import ubc.cs.JLog.Parser.pEndBracket;
import ubc.cs.JLog.Parser.pEndParen;
import ubc.cs.JLog.Parser.pInteger;
import ubc.cs.JLog.Parser.pListCons;
import ubc.cs.JLog.Parser.pName;
import ubc.cs.JLog.Parser.pPreToken;
import ubc.cs.JLog.Parser.pPreTokenizeStream;
import ubc.cs.JLog.Parser.pReal;
import ubc.cs.JLog.Parser.pStartBrace;
import ubc.cs.JLog.Parser.pStartBracket;
import ubc.cs.JLog.Parser.pStartParen;
import ubc.cs.JLog.Parser.pTSPreToken;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pTokenizerTable;
import ubc.cs.JLog.Parser.pUnaryNumber;
import ubc.cs.JLog.Parser.pVariable;

class pTokenizeStream {
    protected pPreTokenizeStream tokenizer;
    protected pTokenizerTable table;
    protected pTokenizerTable string_table;
    protected pTokenizerTable linecomment_table;
    protected pTokenizerTable comment_table;
    protected pTokenizerTable array_table;
    protected pTokenizerTable singles_table;
    protected pTokenizerTable basenumber_table;
    protected Stack pushback;
    protected int currentLine;
    protected int currentChar;
    protected static final int TOKEN_SINGLEQUOTE = 65281;
    protected static final int TOKEN_QUOTE = 65282;
    protected static final int TOKEN_STARTPAREN = 65283;
    protected static final int TOKEN_ENDPAREN = 65284;
    protected static final int TOKEN_STARTBRACE = 65285;
    protected static final int TOKEN_ENDBRACE = 65286;
    protected static final int TOKEN_STARTBRACKET = 65287;
    protected static final int TOKEN_ENDBRACKET = 65288;
    protected static final int TOKEN_COMMA = 65289;
    protected static final int TOKEN_PERIOD = 65290;
    protected static final int TOKEN_SEMICOLON = 65291;
    protected static final int TOKEN_LINECOMMENT = 65292;
    protected static final int TOKEN_CUT = 65293;
    protected static final int TOKEN_LISTCONS = 65294;
    protected static final int TOKEN_FORWARDSLASH = 65295;
    protected static final int TOKEN_STAR = 65296;
    protected static final int TOKEN_WHITESPACE = 2;
    protected static final int TOKEN_WORDS = 3;
    protected static final int TOKEN_SECONDARYWORDS = 4;
    protected static final int TOKEN_NUMBERS = 5;

    public pTokenizeStream(String string) {
        this.tokenizer = new pPreTokenizeStream(new StringReader(string));
        this.initTokenizer();
    }

    public pTokenizeStream(Reader reader) {
        this.tokenizer = new pPreTokenizeStream(reader);
        this.initTokenizer();
    }

    protected void initTokenizer() {
        this.pushback = new Stack();
        this.table = new pTokenizerTable();
        this.string_table = new pTokenizerTable();
        this.array_table = new pTokenizerTable();
        this.linecomment_table = new pTokenizerTable();
        this.comment_table = new pTokenizerTable();
        this.singles_table = new pTokenizerTable();
        this.basenumber_table = new pTokenizerTable();
        this.currentLine = 0;
        this.currentChar = 0;
        this.initTable();
        this.initStringTable();
        this.initArrayTable();
        this.initLineCommentTable();
        this.initCommentTable();
        this.initSinglesTable();
        this.initBaseNumberTable();
        this.tokenizer.useTokenizerTable(this.table);
    }

    protected void initTable() {
        this.table.setTokenType(37, 65292);
        this.table.setTokenType(65, 90, 3);
        this.table.setTokenType(97, 122, 3);
        this.table.setTokenType(95, 3);
        this.table.setTokenType(48, 57, 5);
        this.table.setTokenType(34, 65282);
        this.table.setTokenType(39, 65281);
        this.table.setTokenType(0, 32, 2);
        this.table.setTokenType(10, 1);
        this.table.setTokenType(13, 1);
        this.table.setTokenType(40, 65283);
        this.table.setTokenType(41, 65284);
        this.table.setTokenType(123, 65285);
        this.table.setTokenType(125, 65286);
        this.table.setTokenType(91, 65287);
        this.table.setTokenType(93, 65288);
        this.table.setTokenType(124, 65294);
        this.table.setTokenType(44, 65289);
        this.table.setTokenType(46, 65290);
        this.table.setTokenType(59, 65291);
        this.table.setTokenType(33, 65293);
        this.table.setTokenType(47, 65295);
        this.table.setTokenType(42, 65296);
        this.table.setTokenType(58, 4);
        this.table.setTokenType(45, 4);
        this.table.setTokenType(43, 4);
        this.table.setTokenType(61, 4);
        this.table.setTokenType(60, 4);
        this.table.setTokenType(62, 4);
        this.table.setTokenType(92, 4);
        this.table.setTokenType(126, 4);
        this.table.setTokenType(96, 4);
        this.table.setTokenType(35, 4);
        this.table.setTokenType(38, 4);
        this.table.setTokenType(63, 4);
        this.table.setTokenType(36, 4);
        this.table.setTokenType(64, 4);
        this.table.setTokenType(94, 4);
    }

    protected void initSinglesTable() {
        this.singles_table.setTokenType(0, 31, 2);
        this.singles_table.setTokenType(32, 255, 65280);
        this.singles_table.setTokenType(10, 1);
        this.singles_table.setTokenType(13, 1);
    }

    protected void initBaseNumberTable() {
        this.basenumber_table.setTokenType(0, 31, 2);
        this.basenumber_table.setTokenType(48, 57, 3);
        this.basenumber_table.setTokenType(65, 90, 3);
        this.basenumber_table.setTokenType(97, 122, 3);
        this.basenumber_table.setTokenType(10, 1);
        this.basenumber_table.setTokenType(13, 1);
    }

    protected void initStringTable() {
        this.string_table.setTokenType(0, 31, 2);
        this.string_table.setTokenType(32, 255, 3);
        this.string_table.setTokenType(10, 1);
        this.string_table.setTokenType(13, 1);
        this.string_table.setTokenType(39, 65281);
    }

    protected void initArrayTable() {
        this.array_table.setTokenType(0, 31, 2);
        this.array_table.setTokenType(32, 255, 3);
        this.array_table.setTokenType(10, 1);
        this.array_table.setTokenType(13, 1);
        this.array_table.setTokenType(34, 65282);
    }

    protected void initLineCommentTable() {
        this.linecomment_table.setTokenType(0, 255, 3);
        this.linecomment_table.setTokenType(10, 1);
        this.linecomment_table.setTokenType(13, 1);
    }

    protected void initCommentTable() {
        this.comment_table.setTokenType(0, 255, 3);
        this.comment_table.setTokenType(10, 1);
        this.comment_table.setTokenType(13, 1);
        this.comment_table.setTokenType(47, 65295);
        this.comment_table.setTokenType(42, 65296);
    }

    public void pushBackToken(pToken pToken2) {
        this.pushback.push(pToken2);
    }

    public pToken getNextToken() {
        while (this.pushback.empty()) {
            pTSPreToken pTSPreToken2 = this.read();
            switch (pTSPreToken2.getType()) {
                case -1: {
                    return new pEOF(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 3: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseWords();
                }
                case 4: 
                case 65296: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseSecondaryWords();
                }
                case 65282: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseArray();
                }
                case 65281: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseString();
                }
                case 5: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseNumbers();
                }
                case 65283: {
                    return new pStartParen(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65284: {
                    return new pEndParen(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65285: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseBrace();
                }
                case 65286: {
                    return new pEndBrace(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65287: {
                    return new pStartBracket(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65288: {
                    return new pEndBracket(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65294: {
                    return new pListCons(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65289: {
                    return new pComma(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65290: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parsePeriod();
                }
                case 65291: {
                    pTSPreToken pTSPreToken3 = this.read();
                    boolean bl = pTSPreToken3.getType() == 65283;
                    this.tokenizer.pushBackToken(pTSPreToken3);
                    return new pName(";", bl, pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65293: {
                    pTSPreToken pTSPreToken4 = this.read();
                    boolean bl = pTSPreToken4.getType() == 65283;
                    this.tokenizer.pushBackToken(pTSPreToken4);
                    return new pName("!", bl, pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                }
                case 65292: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseLineComment();
                }
                case 65295: {
                    this.tokenizer.pushBackToken(pTSPreToken2);
                    return this.parseForwardSlash();
                }
            }
        }
        return (pToken)this.pushback.pop();
    }

    protected pToken parseBrace() {
        pTSPreToken pTSPreToken2 = this.read();
        if (pTSPreToken2.getType() != 65285) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        pTSPreToken pTSPreToken3 = this.read();
        if (pTSPreToken3.getType() == 65286) {
            pTSPreToken pTSPreToken4 = this.read();
            boolean bl = pTSPreToken4.getType() == 65283;
            this.tokenizer.pushBackToken(pTSPreToken4);
            return new pName("{}", bl, pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        this.tokenizer.pushBackToken(pTSPreToken3);
        return new pStartBrace(pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
    }

    protected pToken parsePeriod() {
        pTSPreToken pTSPreToken2 = this.read();
        if (pTSPreToken2.getType() != 65290) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        pTSPreToken pTSPreToken3 = this.read();
        if (pTSPreToken3.getType() == 5) {
            this.tokenizer.pushBackToken(pTSPreToken3);
            this.tokenizer.pushBackToken(pTSPreToken2);
            return this.parseNumbers();
        }
        if (pTSPreToken3.getType() == 65290 || pTSPreToken3.getType() == 4) {
            this.tokenizer.pushBackToken(pTSPreToken3);
            this.tokenizer.pushBackToken(pTSPreToken2);
            return this.parseSecondaryWords();
        }
        boolean bl = pTSPreToken3.getType() == 65283;
        this.tokenizer.pushBackToken(pTSPreToken3);
        return new pName(".", bl, pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
    }

    protected pToken parseLineComment() {
        pTSPreToken pTSPreToken2;
        pTSPreToken pTSPreToken3 = this.read();
        if (pTSPreToken3.getType() != 65292) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.linecomment_table);
        while ((pTSPreToken2 = this.read()).getType() == 3) {
        }
        this.tokenizer.pushBackToken(pTSPreToken2);
        this.tokenizer.popTokenizerTable();
        return this.getNextToken();
    }

    protected pToken parseComment() {
        pTSPreToken pTSPreToken2 = this.read();
        pTSPreToken pTSPreToken3 = this.read();
        if (pTSPreToken2.getType() != 65295 || pTSPreToken3.getType() != 65296) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.comment_table);
        boolean bl = false;
        boolean bl2 = false;
        do {
            bl = (pTSPreToken3 = this.read()).getType() == 65295 && bl2;
            boolean bl3 = bl2 = pTSPreToken3.getType() == 65296;
        } while (pTSPreToken3.getType() != -1 && !bl);
        if (pTSPreToken3.getType() == -1) {
            throw new SyntaxErrorException("Premature end of file.  Comment without end at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        this.tokenizer.popTokenizerTable();
        return this.getNextToken();
    }

    protected pToken parseString() {
        pTSPreToken pTSPreToken2;
        pTSPreToken pTSPreToken3 = this.read();
        if (pTSPreToken3.getType() != 65281) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.string_table);
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((pTSPreToken2 = this.read()).getType() != 3) continue;
            stringBuffer.append(pTSPreToken2.getToken());
        } while (pTSPreToken2.getType() == 3 || pTSPreToken2.getType() == 2);
        if (pTSPreToken2.getType() == 1) {
            throw new SyntaxErrorException("Premature end of line.  String without end at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        if (pTSPreToken2.getType() == -1) {
            throw new SyntaxErrorException("Premature end of file.  String without end at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        this.tokenizer.popTokenizerTable();
        pTSPreToken pTSPreToken4 = this.read();
        boolean bl = pTSPreToken4.getType() == 65283;
        this.tokenizer.pushBackToken(pTSPreToken4);
        return new pName(stringBuffer.toString(), bl, pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
    }

    protected pToken parseArray() {
        pTSPreToken pTSPreToken2;
        pTSPreToken pTSPreToken3 = this.read();
        if (pTSPreToken3.getType() != 65282) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.array_table);
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((pTSPreToken2 = this.read()).getType() != 3) continue;
            stringBuffer.append(pTSPreToken2.getToken());
        } while (pTSPreToken2.getType() == 3 || pTSPreToken2.getType() == 2);
        if (pTSPreToken2.getType() == 1) {
            throw new SyntaxErrorException("Premature end of line.  Character array without end at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        if (pTSPreToken2.getType() == -1) {
            throw new SyntaxErrorException("Premature end of file.  Character array without end at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        this.tokenizer.popTokenizerTable();
        return new pArray(stringBuffer.toString(), pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
    }

    protected pToken parseWords() {
        pTSPreToken pTSPreToken2;
        pTSPreToken pTSPreToken3 = this.read();
        if (pTSPreToken3.getType() != 3) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pTSPreToken3.getToken());
        do {
            if ((pTSPreToken2 = this.read()).getType() != 3 && pTSPreToken2.getType() != 5) continue;
            stringBuffer.append(pTSPreToken2.getToken());
        } while (pTSPreToken2.getType() == 3 || pTSPreToken2.getType() == 5);
        boolean bl = pTSPreToken2.getType() == 65283;
        this.tokenizer.pushBackToken(pTSPreToken2);
        if (stringBuffer.charAt(0) >= 'A' && stringBuffer.charAt(0) <= 'Z' || stringBuffer.charAt(0) == '_') {
            return new pVariable(stringBuffer.toString(), pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        return new pName(stringBuffer.toString(), bl, pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
    }

    protected pToken parseSecondaryWords() {
        boolean bl;
        pTSPreToken pTSPreToken2;
        pTSPreToken pTSPreToken3 = this.read();
        int n = pTSPreToken3.getType();
        if (n != 4 && n != 65290 && n != 65295 && n != 65296) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pTSPreToken3.getToken());
        if (pTSPreToken3.getToken().equals("-") || pTSPreToken3.getToken().equals("+")) {
            pTSPreToken2 = this.read();
            n = pTSPreToken2.getType();
            this.tokenizer.pushBackToken(pTSPreToken2);
            if (n == 5) {
                pName pName2 = new pName(stringBuffer.toString(), false, pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
                pToken pToken2 = this.parseNumbers();
                return new pUnaryNumber(pName2, pToken2);
            }
        }
        do {
            bl = false;
            pTSPreToken2 = this.read();
            n = pTSPreToken2.getType();
            if (n != 4 && n != 65290 && n != 65295 && n != 65296) continue;
            stringBuffer.append(pTSPreToken2.getToken());
            bl = true;
        } while (bl);
        boolean bl2 = pTSPreToken2.getType() == 65283;
        this.tokenizer.pushBackToken(pTSPreToken2);
        return new pName(stringBuffer.toString(), bl2, pTSPreToken3.getPosition(), pTSPreToken3.getLine(), pTSPreToken3.getCharPos());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected pToken parseNumbers() {
        pTSPreToken pTSPreToken2 = this.read();
        if (pTSPreToken2.getType() != 5 && pTSPreToken2.getType() != 65290) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pTSPreToken2.getToken());
        if (pTSPreToken2.getType() == 65290) {
            pTSPreToken pTSPreToken3 = this.read();
            if (pTSPreToken3.getType() != 5) {
                throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
            }
            stringBuffer.append(pTSPreToken3.getToken());
            pTSPreToken pTSPreToken4 = this.read();
            if (pTSPreToken4.getType() == 3 && pTSPreToken4.getToken().equalsIgnoreCase("e")) {
                pTSPreToken pTSPreToken5 = this.read();
                if (pTSPreToken5.getType() == 4 && (pTSPreToken5.getToken().equals("-") || pTSPreToken5.getToken().equals("+"))) {
                    pTSPreToken pTSPreToken6 = this.read();
                    if (pTSPreToken6.getType() != 5) {
                        throw new SyntaxErrorException("Expected number after sign at ", pTSPreToken5.getPosition(), pTSPreToken5.getLine(), pTSPreToken5.getCharPos());
                    }
                    stringBuffer.append(pTSPreToken4.getToken());
                    stringBuffer.append(pTSPreToken5.getToken());
                    stringBuffer.append(pTSPreToken6.getToken());
                    return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                } else {
                    if (pTSPreToken5.getType() != 5) throw new SyntaxErrorException("Expected '+','-', or number after 'e' at ", pTSPreToken4.getPosition(), pTSPreToken4.getLine(), pTSPreToken4.getCharPos());
                    stringBuffer.append(pTSPreToken4.getToken());
                    stringBuffer.append(pTSPreToken5.getToken());
                }
                return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
            } else {
                this.tokenizer.pushBackToken(pTSPreToken4);
            }
            return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        pTSPreToken pTSPreToken7 = this.read();
        if (pTSPreToken7.getType() == 65290) {
            pTSPreToken pTSPreToken8 = this.read();
            if (pTSPreToken8.getType() == 5) {
                stringBuffer.append(pTSPreToken7.getToken());
                stringBuffer.append(pTSPreToken8.getToken());
                pTSPreToken pTSPreToken9 = this.read();
                if (pTSPreToken9.getType() == 3 && pTSPreToken9.getToken().equalsIgnoreCase("e")) {
                    pTSPreToken pTSPreToken10 = this.read();
                    if (pTSPreToken10.getType() == 4 && (pTSPreToken10.getToken().equals("-") || pTSPreToken10.getToken().equals("+"))) {
                        pTSPreToken pTSPreToken11 = this.read();
                        if (pTSPreToken11.getType() != 5) {
                            throw new SyntaxErrorException("Expected number after sign at ", pTSPreToken10.getPosition(), pTSPreToken10.getLine(), pTSPreToken10.getCharPos());
                        }
                        stringBuffer.append(pTSPreToken9.getToken());
                        stringBuffer.append(pTSPreToken10.getToken());
                        stringBuffer.append(pTSPreToken11.getToken());
                        return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                    } else {
                        if (pTSPreToken10.getType() != 5) throw new SyntaxErrorException("Expected '+', '-', or number after 'e' at ", pTSPreToken9.getPosition(), pTSPreToken9.getLine(), pTSPreToken9.getCharPos());
                        stringBuffer.append(pTSPreToken9.getToken());
                        stringBuffer.append(pTSPreToken10.getToken());
                    }
                    return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
                } else {
                    this.tokenizer.pushBackToken(pTSPreToken9);
                }
                return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
            }
            this.tokenizer.pushBackToken(pTSPreToken8);
            this.tokenizer.pushBackToken(pTSPreToken7);
            return new pInteger(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        if (pTSPreToken7.getType() == 65281) {
            int n;
            String string = stringBuffer.toString();
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TokenizeStreamException("Error in tokenizer.  Expected integer at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
            }
            if (n == 0) {
                this.tokenizer.useTokenizerTable(this.singles_table);
                pTSPreToken7 = this.read();
                this.tokenizer.popTokenizerTable();
                return new pInteger(string, pTSPreToken7.getToken(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
            }
            if (n < 2 || n > 36) throw new SyntaxErrorException("Number base must be 0 or 2..36 at", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
            this.tokenizer.useTokenizerTable(this.basenumber_table);
            pTSPreToken7 = this.read();
            this.tokenizer.popTokenizerTable();
            return new pInteger(string, pTSPreToken7.getToken(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        if (pTSPreToken7.getType() == 3 && pTSPreToken7.getToken().equalsIgnoreCase("e")) {
            pTSPreToken pTSPreToken12 = this.read();
            if (pTSPreToken12.getType() == 4 && (pTSPreToken12.getToken().equals("-") || pTSPreToken12.getToken().equals("+"))) {
                pTSPreToken pTSPreToken13 = this.read();
                if (pTSPreToken13.getType() != 5) {
                    throw new SyntaxErrorException("Expected number after sign at ", pTSPreToken13.getPosition(), pTSPreToken13.getLine(), pTSPreToken13.getCharPos());
                }
                stringBuffer.append(pTSPreToken7.getToken());
                stringBuffer.append(pTSPreToken12.getToken());
                stringBuffer.append(pTSPreToken13.getToken());
                return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
            } else {
                if (pTSPreToken12.getType() != 5) throw new SyntaxErrorException("Expected '+', '-', or number after 'e' at ", pTSPreToken7.getPosition(), pTSPreToken7.getLine(), pTSPreToken7.getCharPos());
                stringBuffer.append(pTSPreToken7.getToken());
                stringBuffer.append(pTSPreToken12.getToken());
            }
            return new pReal(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        this.tokenizer.pushBackToken(pTSPreToken7);
        return new pInteger(stringBuffer.toString(), pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
    }

    protected pToken parseForwardSlash() {
        pTSPreToken pTSPreToken2 = this.read();
        if (pTSPreToken2.getType() != 65295) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pTSPreToken2.getPosition(), pTSPreToken2.getLine(), pTSPreToken2.getCharPos());
        }
        pTSPreToken pTSPreToken3 = this.read();
        this.tokenizer.pushBackToken(pTSPreToken3);
        this.tokenizer.pushBackToken(pTSPreToken2);
        if (pTSPreToken3.getType() == 65296) {
            return this.parseComment();
        }
        return this.parseSecondaryWords();
    }

    protected pTSPreToken peekNextToken() {
        pTSPreToken pTSPreToken2 = this.read();
        this.tokenizer.pushBackToken(pTSPreToken2);
        return pTSPreToken2;
    }

    protected boolean peekNextTokenType(int n) {
        pTSPreToken pTSPreToken2 = this.read();
        this.tokenizer.pushBackToken(pTSPreToken2);
        return pTSPreToken2.getType() == n;
    }

    protected pTSPreToken read() {
        pTSPreToken pTSPreToken2;
        pPreToken pPreToken2 = this.tokenizer.getNextToken();
        if (!(pPreToken2 instanceof pTSPreToken)) {
            pTSPreToken2 = new pTSPreToken(pPreToken2.getToken(), pPreToken2.getType(), pPreToken2.getPosition(), this.currentLine, this.currentChar);
            if (pPreToken2.getType() == 1) {
                this.currentLine += this.countLines(pPreToken2.getToken());
                this.currentChar = 0;
            } else {
                this.currentChar += pPreToken2.getToken().length();
            }
        } else {
            pTSPreToken2 = (pTSPreToken)pPreToken2;
        }
        return pTSPreToken2;
    }

    protected int countLines(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\r') {
                bl = true;
                ++n;
                continue;
            }
            if (c == '\n' && bl) {
                bl = false;
                continue;
            }
            bl = false;
            ++n;
        }
        return n;
    }
}

