/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Terms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.TranslationFailureException;
import ubc.cs.JLog.Terms.iObjectToTerm;
import ubc.cs.JLog.Terms.iTermToObject;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jFail;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jList;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jObject;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jReal;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jTrue;
import ubc.cs.JLog.Terms.jVariable;

public class jTermTranslation
implements iObjectToTerm,
iTermToObject {
    protected Hashtable createTermKeys = new Hashtable();
    protected Hashtable createObjectKeys = new Hashtable();
    protected iObjectToTerm defaultCreateTerm = null;
    protected iTermToObject defaultCreateObject = null;
    protected jPrologServices prolog = null;

    public jTermTranslation() {
        this.prolog = null;
    }

    public jTermTranslation(jPrologServices jPrologServices2) {
        this.prolog = jPrologServices2;
    }

    public void setDefaults() {
        this.setObjectDefaults();
        this.setTermDefaults();
    }

    protected void setObjectDefaults() {
        iTermToObject iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                if (jTerm2 instanceof jInteger) {
                    return new Float(((jInteger)jTerm2).getIntegerValue());
                }
                if (jTerm2 instanceof jReal) {
                    return new Float(((jReal)jTerm2).getRealValue());
                }
                throw new TranslationFailureException("Expected numerical term.");
            }
        };
        this.RegisterTermToObjectConverter(Float.class, iTermToObject2);
        this.RegisterTermToObjectConverter(jReal.class, iTermToObject2);
        iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                if (jTerm2 instanceof jInteger) {
                    return new Integer(((jInteger)jTerm2).getIntegerValue());
                }
                if (jTerm2 instanceof jReal) {
                    return new Integer((int)((jReal)jTerm2).getRealValue());
                }
                throw new TranslationFailureException("Expected numerical term.");
            }
        };
        this.RegisterTermToObjectConverter(Integer.class, iTermToObject2);
        this.RegisterTermToObjectConverter(jInteger.class, iTermToObject2);
        iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                if (jTerm2 instanceof jTrue || jTerm2 instanceof jAtom && jTerm2.getName().equals("true")) {
                    return Boolean.TRUE;
                }
                if (jTerm2 instanceof jFail || jTerm2 instanceof jAtom && jTerm2.getName().equals("fail")) {
                    return Boolean.FALSE;
                }
                throw new TranslationFailureException("Expected boolean term.");
            }
        };
        this.RegisterTermToObjectConverter(Boolean.class, iTermToObject2);
        this.RegisterTermToObjectConverter(jTrue.class, iTermToObject2);
        this.RegisterTermToObjectConverter(jFail.class, iTermToObject2);
        iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                if (jTerm2 instanceof jObject) {
                    return ((jObject)jTerm2).getObjectReference();
                }
                throw new TranslationFailureException("Expected jObject term.");
            }
        };
        this.RegisterTermToObjectConverter(jObject.class, iTermToObject2);
        iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                if (jTerm2 instanceof jList) {
                    Enumeration enumeration = ((jList)jTerm2).elements(jTermTranslation.this);
                    Vector vector = new Vector();
                    while (enumeration.hasMoreElements()) {
                        vector.addElement(enumeration.nextElement());
                    }
                    return vector;
                }
                throw new TranslationFailureException("Expected jList term.");
            }
        };
        this.RegisterTermToObjectConverter(jListPair.class, iTermToObject2);
        this.RegisterTermToObjectConverter(jNullList.class, iTermToObject2);
        iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                if (jTerm2 instanceof jVariable) {
                    return Void.TYPE;
                }
                throw new TranslationFailureException("Expected jVariable term.");
            }
        };
        this.RegisterTermToObjectConverter(jVariable.class, iTermToObject2);
        iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                return jTerm2;
            }
        };
        this.RegisterTermToObjectConverter(jTerm.class, iTermToObject2);
        iTermToObject2 = new iTermToObject(){

            public Object createObjectFromTerm(jTerm jTerm2) {
                if (jTerm2 instanceof jAtom || jTerm2 instanceof jPredicate && ((jPredicate)jTerm2).getArity() == 0) {
                    return "'" + jTerm2.toString() + "'";
                }
                return jTerm2.toString();
            }
        };
        this.RegisterTermToObjectConverter(jAtom.class, iTermToObject2);
        this.RegisterTermToObjectConverter(String.class, iTermToObject2);
        this.RegisterDefaultTermToObjectConverter(iTermToObject2);
    }

    protected void setTermDefaults() {
        iObjectToTerm iObjectToTerm2 = new iObjectToTerm(){

            public jTerm createTermFromObject(Object object) {
                if (object instanceof Float) {
                    return new jReal(((Float)object).floatValue());
                }
                if (object instanceof Double) {
                    return new jReal(((Double)object).floatValue());
                }
                if (object instanceof Integer) {
                    return new jReal(((Integer)object).floatValue());
                }
                if (object instanceof Long) {
                    return new jReal(((Long)object).floatValue());
                }
                throw new TranslationFailureException("Expected numerical object.");
            }
        };
        this.RegisterObjectToTermConverter(Float.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(Double.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(jReal.class, iObjectToTerm2);
        iObjectToTerm2 = new iObjectToTerm(){

            public jTerm createTermFromObject(Object object) {
                if (object instanceof Short) {
                    return new jInteger(((Short)object).intValue());
                }
                if (object instanceof Integer) {
                    return new jInteger((Integer)object);
                }
                if (object instanceof Long) {
                    return new jInteger(((Long)object).intValue());
                }
                if (object instanceof Float) {
                    return new jInteger(((Float)object).intValue());
                }
                if (object instanceof Double) {
                    return new jInteger(((Double)object).intValue());
                }
                throw new TranslationFailureException("Expected numerical term.");
            }
        };
        this.RegisterObjectToTermConverter(Short.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(Integer.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(Long.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(jInteger.class, iObjectToTerm2);
        iObjectToTerm2 = new iObjectToTerm(){

            public jTerm createTermFromObject(Object object) {
                if (object instanceof Boolean) {
                    return (Boolean)object != false ? jTrue.TRUE : jFail.FAIL;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if (string.equalsIgnoreCase("true")) {
                        return jTrue.TRUE;
                    }
                    if (string.equalsIgnoreCase("fail")) {
                        return jFail.FAIL;
                    }
                }
                throw new TranslationFailureException("Expected boolean term.");
            }
        };
        this.RegisterObjectToTermConverter(Boolean.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(jTrue.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(jFail.class, iObjectToTerm2);
        iObjectToTerm2 = new iObjectToTerm(){

            public jTerm createTermFromObject(Object object) {
                return new jObject(object);
            }
        };
        this.RegisterObjectToTermConverter(jObject.class, iObjectToTerm2);
        iObjectToTerm2 = new iObjectToTerm(){

            public jTerm createTermFromObject(Object object) {
                if (object instanceof Vector) {
                    return jListPair.createListFromEnumeration(((Vector)object).elements(), jTermTranslation.this);
                }
                if (object instanceof Enumeration) {
                    return jListPair.createListFromEnumeration((Enumeration)object, jTermTranslation.this);
                }
                throw new TranslationFailureException("Expected enumerable object.");
            }
        };
        this.RegisterObjectToTermConverter(Vector.class, iObjectToTerm2);
        this.RegisterObjectToTermConverter(Enumeration.class, iObjectToTerm2);
        iObjectToTerm2 = new iObjectToTerm(){

            public jTerm createTermFromObject(Object object) {
                if (object instanceof jTerm) {
                    return (jTerm)object;
                }
                throw new TranslationFailureException("Expected jTerm object.");
            }
        };
        this.RegisterObjectToTermConverter(jTerm.class, iObjectToTerm2);
        iObjectToTerm2 = new iObjectToTerm(){

            public jTerm createTermFromObject(Object object) {
                if (object instanceof jTerm) {
                    return (jTerm)object;
                }
                return new jAtom(object.toString());
            }
        };
        this.RegisterObjectToTermConverter(jAtom.class, iObjectToTerm2);
        if (this.prolog == null) {
            this.RegisterObjectToTermConverter(String.class, iObjectToTerm2);
            this.RegisterObjectToTermConverter(StringBuffer.class, iObjectToTerm2);
            this.RegisterDefaultObjectToTermConverter(iObjectToTerm2);
        }
        if (this.prolog != null) {
            iObjectToTerm2 = new iObjectToTerm(){

                public jTerm createTermFromObject(Object object) {
                    if (object instanceof jTerm) {
                        return (jTerm)object;
                    }
                    pParseStream pParseStream2 = new pParseStream(object.toString() + ".", jTermTranslation.this.prolog.getKnowledgeBase(), jTermTranslation.this.prolog.getPredicateRegistry(), jTermTranslation.this.prolog.getOperatorRegistry());
                    jTerm jTerm2 = pParseStream2.parseTerm();
                    if (jTerm2 != null) {
                        return jTerm2;
                    }
                    throw new TranslationFailureException("Invalid representation.");
                }
            };
            this.RegisterObjectToTermConverter(String.class, iObjectToTerm2);
            this.RegisterObjectToTermConverter(StringBuffer.class, iObjectToTerm2);
            this.RegisterDefaultObjectToTermConverter(iObjectToTerm2);
        }
    }

    public void RegisterTermToObjectConverter(Object object, iTermToObject iTermToObject2) {
        this.createObjectKeys.put(object, iTermToObject2);
    }

    public void RegisterDefaultTermToObjectConverter(iTermToObject iTermToObject2) {
        this.defaultCreateObject = iTermToObject2;
    }

    public void RegisterObjectToTermConverter(Object object, iObjectToTerm iObjectToTerm2) {
        this.createTermKeys.put(object, iObjectToTerm2);
    }

    public void RegisterDefaultObjectToTermConverter(iObjectToTerm iObjectToTerm2) {
        this.defaultCreateTerm = iObjectToTerm2;
    }

    public iObjectToTerm getObjectToTermConverter(Object object) {
        return (iObjectToTerm)this.createTermKeys.get(object);
    }

    public iObjectToTerm getDefaultObjectToTermConverter() {
        return this.defaultCreateTerm;
    }

    public iTermToObject getTermToObjectConverter(Object object) {
        return (iTermToObject)this.createObjectKeys.get(object);
    }

    public iTermToObject getDefaultTermToObjectConverter() {
        return this.defaultCreateObject;
    }

    public jTerm createTermFromObject(Object object) {
        return this.createTermFromObject(object, object.getClass());
    }

    public Object createObjectFromTerm(jTerm jTerm2) {
        return this.createObjectFromTerm(jTerm2, jTerm2.getClass());
    }

    public jTerm createTermFromObject(Object object, Object object2) {
        iObjectToTerm iObjectToTerm2 = (iObjectToTerm)this.createTermKeys.get(object2);
        if (iObjectToTerm2 == null) {
            iObjectToTerm2 = this.defaultCreateTerm;
        }
        if (iObjectToTerm2 != null) {
            return iObjectToTerm2.createTermFromObject(object);
        }
        throw new TranslationFailureException("No object to term conversion unit found.");
    }

    public Object createObjectFromTerm(jTerm jTerm2, Object object) {
        iTermToObject iTermToObject2 = (iTermToObject)this.createObjectKeys.get(object);
        if (iTermToObject2 == null) {
            iTermToObject2 = this.defaultCreateObject;
        }
        if (iTermToObject2 != null) {
            return iTermToObject2.createObjectFromTerm(jTerm2);
        }
        throw new TranslationFailureException("No term to object conversion unit found.");
    }
}

