/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins.Goals;

import ubc.cs.JLog.Builtins.InvalidOpArgumentException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Parser.pOperatorEntry;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPredicateOperatorEntry;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jTerm;

public class jOpGoal
extends jGoal {
    protected jTerm priority;
    protected jTerm specifier;
    protected jTerm operation;

    public jOpGoal(jTerm jTerm2, jTerm jTerm3, jTerm jTerm4) {
        this.priority = jTerm2;
        this.specifier = jTerm3;
        this.operation = jTerm4;
    }

    public boolean prove(iGoalStack iGoalStack2, iGoalStack iGoalStack3) {
        int n = this.getPriority(this.priority.getValue());
        int n2 = this.getSpecifier(this.specifier.getTerm());
        Thread thread = Thread.currentThread();
        if (thread instanceof jPrologServiceThread) {
            jPrologServiceThread jPrologServiceThread2 = (jPrologServiceThread)thread;
            jPrologServices jPrologServices2 = jPrologServiceThread2.getPrologServices();
            pOperatorRegistry pOperatorRegistry2 = jPrologServices2.getOperatorRegistry();
            this.registerOperations(pOperatorRegistry2, n, n2);
            iGoalStack3.push((jGoal)this);
            return true;
        }
        iGoalStack2.push((jGoal)this);
        return false;
    }

    public boolean retry(iGoalStack iGoalStack2, iGoalStack iGoalStack3) {
        iGoalStack2.push((jGoal)this);
        return false;
    }

    protected int getPriority(jTerm jTerm2) {
        if (jTerm2.type == 1) {
            int n = ((jInteger)jTerm2).getIntegerValue();
            if (n < 0 || n > 1200) {
                throw new InvalidOpArgumentException("Priority number in 0..1200 range required.");
            }
            return n;
        }
        throw new InvalidOpArgumentException("Priority number required.");
    }

    protected int getSpecifier(jTerm jTerm2) {
        if (jTerm2.type == 0) {
            String string = jTerm2.getName();
            if (string.equalsIgnoreCase("FX")) {
                return 1;
            }
            if (string.equalsIgnoreCase("FY")) {
                return 2;
            }
            if (string.equalsIgnoreCase("XFX")) {
                return 17;
            }
            if (string.equalsIgnoreCase("XFY")) {
                return 18;
            }
            if (string.equalsIgnoreCase("YFX")) {
                return 33;
            }
            if (string.equalsIgnoreCase("XF")) {
                return 16;
            }
            if (string.equalsIgnoreCase("YF")) {
                return 32;
            }
            throw new InvalidOpArgumentException("'fx','fy','xfx','xfy','yfx','xf' or 'yf' specifier required.");
        }
        throw new InvalidOpArgumentException("Specifier atom required.");
    }

    protected void registerOperations(pOperatorRegistry pOperatorRegistry2, int n, int n2) {
        jTerm jTerm2 = this.operation.getTerm();
        do {
            if (jTerm2.type == 0) {
                this.registerOperation(jTerm2, pOperatorRegistry2, n, n2);
                break;
            }
            if (jTerm2.type != 12) {
                throw new InvalidOpArgumentException("Operator name atom required.");
            }
            jListPair jListPair2 = (jListPair)jTerm2;
            this.registerOperation(jListPair2.getHead(), pOperatorRegistry2, n, n2);
            jTerm2 = jListPair2.getTail();
        } while (!(jTerm2 instanceof jNullList));
    }

    protected void registerOperation(jTerm jTerm2, pOperatorRegistry pOperatorRegistry2, int n, int n2) {
        if (jTerm2.type != 0) {
            throw new InvalidOpArgumentException("Operator name atom required.");
        }
        pOperatorRegistry2.addOperator((pOperatorEntry)new pPredicateOperatorEntry(jTerm2.getName(), n2, n));
    }

    public String getName() {
        return "op";
    }

    public int getArity() {
        return 3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() + "/" + String.valueOf(this.getArity()) + " goal: ");
        stringBuffer.append(this.getName() + "(" + this.priority.toString() + "," + this.specifier.toString() + "," + this.operation.toString() + ")");
        return stringBuffer.toString();
    }
}

