/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins.Goals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import ubc.cs.JLog.Builtins.MissingInputServicesException;
import ubc.cs.JLog.Builtins.jRead;
import ubc.cs.JLog.Foundation.InvalidInputException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jUnifiedVector;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.jTerm;

public class jReadGoal
extends jGoal {
    protected jRead read;
    public jTerm term;
    public jUnifiedVector unified;

    public jReadGoal(jRead jRead2, jTerm jTerm2) {
        this.read = jRead2;
        this.term = jTerm2;
        this.unified = new jUnifiedVector();
    }

    public boolean prove(iGoalStack iGoalStack2, iGoalStack iGoalStack3) {
        jTerm jTerm2 = this.getInput();
        if (this.read.prove(this, jTerm2)) {
            iGoalStack3.push((jGoal)this);
            return true;
        }
        this.unified.restoreVariables();
        iGoalStack2.push((jGoal)this);
        return false;
    }

    public boolean retry(iGoalStack iGoalStack2, iGoalStack iGoalStack3) {
        this.unified.restoreVariables();
        iGoalStack2.push((jGoal)this);
        return false;
    }

    public void internal_restore(iGoalStack iGoalStack2) {
        this.unified.restoreVariables();
    }

    protected jTerm getInput() {
        Thread thread = Thread.currentThread();
        if (thread instanceof jPrologServiceThread) {
            jPrologServiceThread jPrologServiceThread2 = (jPrologServiceThread)thread;
            jPrologServices jPrologServices2 = jPrologServiceThread2.getPrologServices();
            BufferedReader bufferedReader = jPrologServices2.getInput();
            PrintWriter printWriter = jPrologServices2.getOutput();
            String string = null;
            if (bufferedReader == null) {
                throw new MissingInputServicesException("InputStream Services unavailable");
            }
            while (string == null) {
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    throw new InvalidInputException();
                }
                if (string == null) {
                    throw new InvalidInputException();
                }
                pParseStream pParseStream2 = new pParseStream(string, jPrologServices2.getKnowledgeBase(), jPrologServices2.getPredicateRegistry(), jPrologServices2.getOperatorRegistry());
                try {
                    jTerm jTerm2 = pParseStream2.parseTerm();
                    if (jTerm2 != null) {
                        printWriter.println(jTerm2.toString(true));
                        printWriter.flush();
                        return jTerm2;
                    }
                    throw new InvalidInputException();
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    printWriter.println(string);
                    printWriter.println("SYNTAX ERROR:");
                    printWriter.println(syntaxErrorException.toString());
                    printWriter.flush();
                    string = null;
                    printWriter.println("Try Again...\n");
                    printWriter.flush();
                }
                catch (TokenizeStreamException tokenizeStreamException) {
                    printWriter.println(string);
                    printWriter.println("INTERNAL ERROR:");
                    printWriter.println(tokenizeStreamException.toString());
                    printWriter.flush();
                    string = null;
                    printWriter.println("Try Again...\n");
                    printWriter.flush();
                }
            }
            throw new InvalidInputException();
        }
        throw new MissingInputServicesException();
    }

    public String getName() {
        return this.read.getName();
    }

    public int getArity() {
        return this.read.getArity();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() + "/" + String.valueOf(this.getArity()) + " goal: ");
        stringBuffer.append(this.getName() + "(" + this.term.toString() + ")");
        return stringBuffer.toString();
    }
}

