/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import java.util.Random;
import ubc.cs.JLog.Builtins.InvalidArithmeticOperationException;
import ubc.cs.JLog.Builtins.jUnaryArithmetic;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jReal;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jUnaryBuiltinPredicate;

public class jRandom
extends jUnaryArithmetic {
    public jRandom(jTerm jTerm2) {
        super(jTerm2);
    }

    public String getName() {
        return "random";
    }

    public jTerm getValue() {
        jTerm jTerm2 = this.rhs.getValue();
        if (jTerm2.type == 1) {
            return new jInteger(this.operatorInt(((jInteger)jTerm2).getIntegerValue()));
        }
        if (jTerm2.type == 2) {
            return new jReal(this.operatorReal(((jReal)jTerm2).getRealValue()));
        }
        throw new InvalidArithmeticOperationException();
    }

    protected jUnaryBuiltinPredicate duplicate(jTerm jTerm2) {
        return new jRandom(jTerm2);
    }

    protected int operatorInt(int n) {
        Thread thread = Thread.currentThread();
        if (n < 1) {
            throw new InvalidArithmeticOperationException();
        }
        if (thread instanceof jPrologServiceThread) {
            jPrologServiceThread jPrologServiceThread2 = (jPrologServiceThread)thread;
            Random random = jPrologServiceThread2.getPrologServices().getRandomGenerator();
            double d = random.nextDouble();
            int n2 = (int)Math.floor((double)n * d);
            n2 = n2 < n ? n2 : 0;
            return n2;
        }
        throw new InvalidArithmeticOperationException();
    }

    protected float operatorReal(float f) {
        Thread thread = Thread.currentThread();
        if (thread instanceof jPrologServiceThread) {
            jPrologServiceThread jPrologServiceThread2 = (jPrologServiceThread)thread;
            Random random = jPrologServiceThread2.getPrologServices().getRandomGenerator();
            return f * random.nextFloat();
        }
        throw new InvalidArithmeticOperationException();
    }
}

