/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.EngineManager;
import alice.tuprolog.FlagManager;
import alice.tuprolog.HaltException;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.LibraryManager;
import alice.tuprolog.Number;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.TheoryManager;
import alice.tuprolog.Var;
import alice.util.Tools;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class BuiltIn
extends Library {
    private EngineManager engineManager;
    private TheoryManager theoryManager;
    private LibraryManager libraryManager;
    private FlagManager flagManager;
    private PrimitiveManager primitiveManager;
    private OperatorManager operatorManager;

    public BuiltIn(Prolog prolog) {
        this.setEngine(prolog);
        this.engineManager = prolog.getEngineManager();
        this.theoryManager = prolog.getTheoryManager();
        this.libraryManager = prolog.getLibraryManager();
        this.flagManager = prolog.getFlagManager();
        this.primitiveManager = prolog.getPrimitiveManager();
        this.operatorManager = prolog.getOperatorManager();
    }

    public String[][] getSynonymMap() {
        return new String[][]{{"!", "cut", "predicate"}, {"=", "unify", "predicate"}, {"\\=", "deunify", "predicate"}, {",", "comma", "predicate"}, {"initialization", "solve", "directive"}, {"load_library", "$load_library", "directive"}};
    }

    public boolean fail_0() {
        return false;
    }

    public boolean true_0() {
        return true;
    }

    public boolean halt_0() throws HaltException {
        throw new HaltException();
    }

    public boolean cut_0() {
        this.engineManager.cut();
        return true;
    }

    public boolean asserta_1(Term term) {
        if ((term = term.getTerm()) instanceof Struct) {
            this.theoryManager.assertA((Struct)term, true, null, false);
            return true;
        }
        return false;
    }

    public boolean assertz_1(Term term) {
        if ((term = term.getTerm()) instanceof Struct) {
            this.theoryManager.assertZ((Struct)term, true, null, false);
            return true;
        }
        return false;
    }

    public boolean $retract_1(Term term) {
        if (!((term = term.getTerm()) instanceof Struct)) {
            return false;
        }
        Struct struct = (Struct)term;
        ClauseInfo clauseInfo = this.theoryManager.retract(struct);
        if (clauseInfo != null) {
            Struct struct2 = null;
            struct2 = !struct.isClause() ? new Struct(":-", term, new Struct("true")) : struct;
            this.unify(struct2, clauseInfo.getClause());
            return true;
        }
        return false;
    }

    public boolean abolish_1(Term term) {
        if (!((term = term.getTerm()) instanceof Struct) || !term.isGround()) {
            return false;
        }
        return this.theoryManager.abolish((Struct)term);
    }

    public boolean halt_1(Term term) throws HaltException {
        if (term instanceof Number) {
            throw new HaltException(((Number)term).intValue());
        }
        return false;
    }

    public boolean load_library_1(Term term) {
        if (!(term = term.getTerm()).isAtom()) {
            return false;
        }
        try {
            this.libraryManager.loadLibrary(((Struct)term).getName());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean unload_library_1(Term term) {
        if (!(term = term.getTerm()).isAtom()) {
            return false;
        }
        try {
            this.libraryManager.unloadLibrary(((Struct)term).getName());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean flag_list_1(Term term) {
        term = term.getTerm();
        Struct struct = this.flagManager.getPrologFlagList();
        return this.unify(term, struct);
    }

    public boolean comma_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        Struct struct = new Struct(",", term, term2);
        this.engineManager.pushSubGoal(ClauseInfo.extractBody(struct));
        return true;
    }

    public boolean $call_1(Term term) {
        if ((term = term.getTerm()) instanceof Var || !this.isCallable(term)) {
            return false;
        }
        if ((term = BuiltIn.convertTermToGoal(term)) == null) {
            return false;
        }
        this.engineManager.identify(term);
        this.engineManager.pushSubGoal(ClauseInfo.extractBody(term));
        return true;
    }

    static Term convertTermToGoal(Term term) {
        Struct struct;
        String string;
        if (term instanceof Number) {
            return null;
        }
        if ((term = term.getTerm()) instanceof Var) {
            return new Struct("call", term);
        }
        if (term instanceof Struct && ((string = (struct = (Struct)term).getPredicateIndicator()).equals(";/2") || string.equals(",/2") || string.equals("->/2"))) {
            for (int i = 0; i < struct.getArity(); ++i) {
                Term term2 = struct.getArg(i);
                Term term3 = BuiltIn.convertTermToGoal(term2);
                if (term3 == null) {
                    return null;
                }
                struct.setArg(i, term3);
            }
        }
        return term;
    }

    private boolean isCallable(Term term) {
        return term.isAtom() || term.isCompound();
    }

    public boolean is_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term2);
        if (term3 == null) {
            return false;
        }
        return this.unify(term.getTerm(), term3);
    }

    public boolean unify_2(Term term, Term term2) {
        return this.unify(term, term2);
    }

    public boolean deunify_2(Term term, Term term2) {
        return !this.unify(term, term2);
    }

    public boolean $tolist_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Struct) {
            Struct struct = ((Struct)term).toList();
            return struct != null && this.unify(term2, struct);
        }
        return false;
    }

    public boolean $fromlist_2(Term term, Term term2) {
        term = term.getTerm();
        if (!(term2 = term2.getTerm()).isList()) {
            return false;
        }
        Struct struct = ((Struct)term2).fromList();
        return struct != null && this.unify(term, struct);
    }

    public boolean copy_term_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        int n = this.engineManager.env.nDemoSteps;
        return this.unify(term2, term.copy(new IdentityHashMap(), n));
    }

    public boolean $append_2(Term term, Term term2) {
        term = term.getTerm();
        if (!(term2 = term2.getTerm()).isList()) {
            return false;
        }
        ((Struct)term2).append(term);
        return true;
    }

    public boolean $find_2(Term term, Term term2) {
        term = term.getTerm();
        if (!(term2 = term2.getTerm()).isList()) {
            return false;
        }
        List list = this.theoryManager.find(term);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClauseInfo clauseInfo = (ClauseInfo)iterator.next();
            if (!this.match(term, clauseInfo.getHead())) continue;
            clauseInfo.getClause().resolveTerm();
            ((Struct)term2).append(clauseInfo.getClause());
        }
        return true;
    }

    public boolean set_prolog_flag_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (!term.isAtom() && !(term instanceof Struct) || !term2.isGround()) {
            return false;
        }
        String string = term.toString();
        return this.flagManager.setFlag(string, term2);
    }

    public boolean get_prolog_flag_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (!term.isAtom() && !(term instanceof Struct)) {
            return false;
        }
        String string = term.toString();
        Term term3 = this.flagManager.getFlag(string);
        return term3 != null ? this.unify(term3, term2) : false;
    }

    public boolean $op_3(Term term, Term term2, Term term3) {
        term = term.getTerm();
        term2 = term2.getTerm();
        term3 = term3.getTerm();
        if (!(term instanceof Number && term2.isAtom() && term3.isAtom())) {
            return false;
        }
        String string = ((Struct)term2).getName();
        if (string.equals("fx") | string.equals("fy") | string.equals("xf") | string.equals("yf") | string.equals("xfx") | string.equals("yfx") | string.equals("xfy")) {
            this.operatorManager.opNew(((Struct)term3).getName(), ((Struct)term2).getName(), ((Number)term).intValue());
        }
        return true;
    }

    public void op_3(Term term, Term term2, Term term3) {
        this.$op_3(term, term2, term3);
    }

    public void flag_4(Term term, Term term2, Term term3, Term term4) {
        term = term.getTerm();
        term2 = term2.getTerm();
        term3 = term3.getTerm();
        term4 = term4.getTerm();
        if (term2.isList() && (term4.equals(Term.TRUE) || term4.equals(Term.FALSE))) {
            String string = "";
            this.flagManager.defineFlag(term.toString(), (Struct)term2, term3, term4.equals(Term.TRUE), string);
        }
    }

    public void solve_1(Term term) {
        if ((term = term.getTerm()) instanceof Struct) {
            this.primitiveManager.identifyPredicate(term);
            this.theoryManager.addStartGoal((Struct)term);
        }
    }

    public void $load_library_1(Term term) throws InvalidLibraryException {
        if ((term = term.getTerm()).isAtom()) {
            this.libraryManager.loadLibrary(((Struct)term).getName());
        }
    }

    public void consult_1(Term term) throws FileNotFoundException, InvalidTheoryException, IOException {
        term = term.getTerm();
        this.engine.addTheory(new Theory(new FileInputStream(Tools.removeApices(term.toString()))));
    }
}

