/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ClauseDatabase
extends HashMap {
    ClauseDatabase() {
    }

    void addFirst(String string, ClauseInfo clauseInfo) {
        LinkedList<ClauseInfo> linkedList = (LinkedList<ClauseInfo>)this.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<ClauseInfo>();
            this.put(string, linkedList);
        }
        linkedList.addFirst(clauseInfo);
    }

    void addLast(String string, ClauseInfo clauseInfo) {
        LinkedList<ClauseInfo> linkedList = (LinkedList<ClauseInfo>)this.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<ClauseInfo>();
            this.put(string, linkedList);
        }
        linkedList.addLast(clauseInfo);
    }

    LinkedList abolish(String string) {
        return (LinkedList)this.remove(string);
    }

    List getPredicates(String string) {
        LinkedList linkedList = (LinkedList)this.get(string);
        if (linkedList == null) {
            return new LinkedList();
        }
        return (List)linkedList.clone();
    }

    public Iterator iterator() {
        return new CompleteIterator(this);
    }

    private static class CompleteIterator
    implements Iterator {
        Iterator values;
        Iterator workingList;

        public CompleteIterator(ClauseDatabase clauseDatabase) {
            this.values = clauseDatabase.values().iterator();
        }

        public boolean hasNext() {
            if (this.workingList != null && this.workingList.hasNext()) {
                return true;
            }
            if (this.values.hasNext()) {
                this.workingList = ((List)this.values.next()).iterator();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            return this.workingList.next();
        }

        public void remove() {
            this.workingList.remove();
        }
    }
}

