/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.OneWayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ClauseStore {
    private OneWayList clauses;
    private Term goal;
    private List vars;
    private boolean haveAlternatives;

    private ClauseStore(Term term, List list) {
        this.goal = term;
        this.vars = list;
        this.clauses = null;
    }

    public static ClauseStore build(Term term, List list, List list2) {
        ClauseStore clauseStore = new ClauseStore(term, list);
        clauseStore.clauses = OneWayList.transform(list2);
        if (clauseStore.clauses == null || !clauseStore.existCompatibleClause()) {
            return null;
        }
        return clauseStore;
    }

    public ClauseInfo fetch() {
        if (this.clauses == null) {
            return null;
        }
        this.deunify(this.vars);
        if (!this.checkCompatibility(this.goal)) {
            return null;
        }
        ClauseInfo clauseInfo = (ClauseInfo)this.clauses.getHead();
        this.clauses = this.clauses.getTail();
        this.haveAlternatives = this.checkCompatibility(this.goal);
        return clauseInfo;
    }

    public boolean haveAlternatives() {
        return this.haveAlternatives;
    }

    protected boolean existCompatibleClause() {
        List list = this.deunify(this.vars);
        boolean bl = this.checkCompatibility(this.goal);
        this.reunify(this.vars, list);
        return bl;
    }

    private List deunify(List list) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Var var = (Var)iterator.next();
            arrayList.add(var.getLink());
            var.free();
        }
        return arrayList;
    }

    private void reunify(List list, List list2) {
        int n = list.size();
        ListIterator listIterator = list.listIterator(n);
        ListIterator listIterator2 = list2.listIterator(n);
        while (listIterator.hasPrevious()) {
            ((Var)listIterator.previous()).setLink((Term)listIterator2.previous());
        }
    }

    private boolean checkCompatibility(Term term) {
        if (this.clauses == null) {
            return false;
        }
        ClauseInfo clauseInfo = null;
        do {
            if (term.match((clauseInfo = (ClauseInfo)this.clauses.getHead()).getHead())) {
                return true;
            }
            this.clauses = this.clauses.getTail();
        } while (this.clauses != null);
        return false;
    }

    public String toString() {
        return "clauses: " + this.clauses + "\n" + "goal: " + this.goal + "\n" + "vars: " + this.vars + "\n";
    }

    public List getClauses() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (OneWayList oneWayList = this.clauses; oneWayList != null; oneWayList = oneWayList.getTail()) {
            arrayList.add(oneWayList.getHead());
        }
        return arrayList;
    }

    public Term getMatchGoal() {
        return this.goal;
    }

    public List getVarsForMatch() {
        return this.vars;
    }
}

