/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Engine;
import alice.tuprolog.ExecutionContext;
import alice.tuprolog.LibraryManager;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.State;
import alice.tuprolog.StateBacktrack;
import alice.tuprolog.StateEnd;
import alice.tuprolog.StateGoalEvaluation;
import alice.tuprolog.StateGoalSelection;
import alice.tuprolog.StateInit;
import alice.tuprolog.StateRuleSelection;
import alice.tuprolog.SubGoalTree;
import alice.tuprolog.Term;
import alice.tuprolog.TheoryManager;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class EngineManager
implements Serializable {
    private Prolog mediator;
    private TheoryManager theoryManager;
    private PrimitiveManager primitiveManager;
    private LibraryManager libraryManager;
    Engine env;
    private Engine last_env;
    private LinkedList stackEnv = new LinkedList();
    private SolveInfo sinfo;
    final State INIT = new StateInit(this);
    final State GOAL_EVALUATION = new StateGoalEvaluation(this);
    final State RULE_SELECTION = new StateRuleSelection(this);
    final State GOAL_SELECTION = new StateGoalSelection(this);
    final State BACKTRACK = new StateBacktrack(this);
    final State END_FALSE = new StateEnd(this, 0);
    final State END_TRUE = new StateEnd(this, 1);
    final State END_TRUE_CP = new StateEnd(this, 2);
    final State END_HALT = new StateEnd(this, -1);
    public static final int HALT = -1;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int TRUE_CP = 2;

    void initialize(Prolog prolog) {
        this.mediator = prolog;
        this.theoryManager = prolog.getTheoryManager();
        this.primitiveManager = prolog.getPrimitiveManager();
        this.libraryManager = prolog.getLibraryManager();
    }

    void spy(String string, Engine engine) {
        this.mediator.spy(string, engine);
    }

    void warn(String string) {
        this.mediator.warn(string);
    }

    public SolveInfo solve(Term term) {
        try {
            term.resolveTerm();
            this.libraryManager.onSolveBegin(term);
            this.primitiveManager.identifyPredicate(term);
            this.freeze();
            this.env = new Engine(this, term);
            StateEnd stateEnd = this.env.run();
            this.defreeze();
            this.sinfo = new SolveInfo(this.env.query, stateEnd.getResultGoal(), stateEnd.getResultDemo(), stateEnd.getResultVars());
            if (!this.sinfo.hasOpenAlternatives()) {
                this.solveEnd();
            }
            return this.sinfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SolveInfo(term);
        }
    }

    public synchronized SolveInfo solveNext() throws NoMoreSolutionException {
        if (this.hasOpenAlternatives()) {
            this.refreeze();
            this.env.nextState = this.BACKTRACK;
            StateEnd stateEnd = this.env.run();
            this.defreeze();
            this.sinfo = new SolveInfo(this.env.query, stateEnd.getResultGoal(), stateEnd.getResultDemo(), stateEnd.getResultVars());
            if (!this.sinfo.hasOpenAlternatives()) {
                this.solveEnd();
            }
            return this.sinfo;
        }
        throw new NoMoreSolutionException();
    }

    public void solveHalt() {
        this.env.mustStop();
    }

    public void solveEnd() {
        this.libraryManager.onSolveEnd();
    }

    private void freeze() {
        if (this.env == null) {
            return;
        }
        try {
            if (this.stackEnv.getLast() == this.env) {
                return;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.stackEnv.addLast(this.env);
    }

    private void refreeze() {
        this.freeze();
        this.env = this.last_env;
    }

    private void defreeze() {
        this.last_env = this.env;
        if (this.stackEnv.isEmpty()) {
            return;
        }
        this.env = (Engine)this.stackEnv.removeLast();
    }

    List find(Term term) {
        return this.theoryManager.find(term);
    }

    void identify(Term term) {
        this.primitiveManager.identifyPredicate(term);
    }

    void pushSubGoal(SubGoalTree subGoalTree) {
        this.env.currentContext.goalsToEval.pushSubGoal(subGoalTree);
    }

    void cut() {
        this.env.choicePointSelector.cut(this.env.currentContext.choicePointAfterCut);
    }

    ExecutionContext getCurrentContext() {
        return this.env == null ? null : this.env.currentContext;
    }

    boolean hasOpenAlternatives() {
        if (this.sinfo == null) {
            return false;
        }
        return this.sinfo.hasOpenAlternatives();
    }

    boolean isHalted() {
        if (this.sinfo == null) {
            return false;
        }
        return this.sinfo.isHalted();
    }
}

