/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.IPrimitives;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.TheoryManager;
import alice.tuprolog.event.LibraryEvent;
import alice.tuprolog.event.WarningEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;

class LibraryManager {
    private ArrayList currentLibraries = new ArrayList();
    private Prolog prolog;
    private TheoryManager theoryManager;
    private PrimitiveManager primitiveManager;

    LibraryManager() {
    }

    void initialize(Prolog prolog) {
        this.prolog = prolog;
        this.theoryManager = prolog.getTheoryManager();
        this.primitiveManager = prolog.getPrimitiveManager();
    }

    public synchronized Library loadLibrary(String string) throws InvalidLibraryException {
        Object object;
        Library library = null;
        try {
            library = (Library)Class.forName(string).newInstance();
            object = library.getName();
            Library library2 = this.getLibrary((String)object);
            if (library2 != null) {
                if (this.prolog.isWarning()) {
                    String string2 = "library " + library2.getName() + " already loaded.";
                    this.prolog.notifyWarning(new WarningEvent(this.prolog, string2));
                }
                return library2;
            }
        }
        catch (Exception exception) {
            throw new InvalidLibraryException(string, -1, -1);
        }
        this.bindLibrary(library);
        object = new LibraryEvent(this.prolog, library.getName());
        this.prolog.notifyLoadedLibrary((LibraryEvent)object);
        return library;
    }

    public synchronized void loadLibrary(Library library) throws InvalidLibraryException {
        Object object;
        String string = library.getName();
        Library library2 = this.getLibrary(string);
        if (library2 != null) {
            if (this.prolog.isWarning()) {
                object = "library " + library2.getName() + " already loaded.";
                this.prolog.notifyWarning(new WarningEvent(this.prolog, (String)object));
            }
            this.unloadLibrary(string);
        }
        this.bindLibrary(library);
        object = new LibraryEvent(this.prolog, library.getName());
        this.prolog.notifyLoadedLibrary((LibraryEvent)object);
    }

    public synchronized String[] getCurrentLibraries() {
        String[] stringArray = new String[this.currentLibraries.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Library)this.currentLibraries.get(i)).getName();
        }
        return stringArray;
    }

    public synchronized void unloadLibrary(String string) throws InvalidLibraryException {
        Serializable serializable;
        boolean bl = false;
        ListIterator listIterator = this.currentLibraries.listIterator();
        while (listIterator.hasNext()) {
            serializable = (Library)listIterator.next();
            if (!serializable.getName().equals(string)) continue;
            bl = true;
            listIterator.remove();
            serializable.dismiss();
            this.primitiveManager.deletePrimitiveInfo((IPrimitives)((Object)serializable));
            break;
        }
        if (!bl) {
            throw new InvalidLibraryException();
        }
        this.theoryManager.removeLibraryTheory(string);
        this.theoryManager.rebindPrimitives();
        serializable = new LibraryEvent(this.prolog, string);
        this.prolog.notifyUnloadedLibrary((LibraryEvent)serializable);
    }

    private Library bindLibrary(Library library) throws InvalidLibraryException {
        try {
            String string = library.getName();
            library.setEngine(this.prolog);
            this.currentLibraries.add(library);
            this.primitiveManager.createPrimitiveInfo(library);
            String string2 = library.getTheory();
            if (string2 != null) {
                this.theoryManager.consult(new Theory(string2), false, string);
                this.theoryManager.solveTheoryGoal();
            }
            this.theoryManager.rebindPrimitives();
            return library;
        }
        catch (InvalidTheoryException invalidTheoryException) {
            throw new InvalidLibraryException(library.getName(), invalidTheoryException.line, invalidTheoryException.pos);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidLibraryException(library.getName(), -1, -1);
        }
    }

    public synchronized Library getLibrary(String string) {
        ListIterator listIterator = this.currentLibraries.listIterator();
        while (listIterator.hasNext()) {
            Library library = (Library)listIterator.next();
            if (!library.getName().equals(string)) continue;
            return library;
        }
        return null;
    }

    public synchronized void onSolveBegin(Term term) {
        ListIterator listIterator = this.currentLibraries.listIterator();
        while (listIterator.hasNext()) {
            ((Library)listIterator.next()).onSolveBegin(term);
        }
    }

    public synchronized void onSolveEnd() {
        ListIterator listIterator = this.currentLibraries.listIterator();
        while (listIterator.hasNext()) {
            ((Library)listIterator.next()).onSolveEnd();
        }
    }
}

