/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Operator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

class OperatorManager
implements Serializable {
    private OperatorRegister operatorList = new OperatorRegister();
    public static final int OP_LOW = 1;
    public static final int OP_HIGH = 1200;

    OperatorManager() {
    }

    public void opNew(String string, String string2, int n) {
        Operator operator = new Operator(string, string2, n);
        if (n >= 1 && n <= 1200) {
            this.operatorList.addOperator(operator);
        }
    }

    public int opPrio(String string, String string2) {
        Operator operator = this.operatorList.getOperator(string, string2);
        return operator == null ? 0 : operator.prio;
    }

    public int opNext(int n) {
        int n2 = 0;
        Iterator iterator = this.operatorList.iterator();
        while (iterator.hasNext()) {
            Operator operator = (Operator)iterator.next();
            if (operator.prio <= n2 || operator.prio >= n) continue;
            n2 = operator.prio;
        }
        return n2;
    }

    public List getOperators() {
        return new LinkedList(this.operatorList);
    }

    private static class OperatorRegister
    extends LinkedHashSet {
        private HashMap nameTypeToKey = new HashMap();

        private OperatorRegister() {
        }

        public boolean addOperator(Operator operator) {
            String string = operator.name + operator.type;
            Operator operator2 = (Operator)this.nameTypeToKey.get(string);
            if (operator2 != null) {
                super.remove(operator2);
            }
            this.nameTypeToKey.put(string, operator);
            return super.add(operator);
        }

        public Operator getOperator(String string, String string2) {
            return (Operator)this.nameTypeToKey.get(string + string2);
        }
    }
}

