/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.BuiltIn;
import alice.tuprolog.IPrimitives;
import alice.tuprolog.Library;
import alice.tuprolog.PrimitiveInfo;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PrimitiveManager {
    private IdentityHashMap libHashMap = new IdentityHashMap();
    private HashMap directiveHashMap = new HashMap();
    private HashMap predicateHashMap = new HashMap();
    private HashMap functorHashMap = new HashMap();

    void initialize(Prolog prolog) {
        this.createPrimitiveInfo(new BuiltIn(prolog));
    }

    void createPrimitiveInfo(IPrimitives iPrimitives) {
        Object object;
        List[] listArray = iPrimitives.getPrimitives();
        Iterator iterator = listArray[0].iterator();
        while (iterator.hasNext()) {
            object = (PrimitiveInfo)iterator.next();
            this.directiveHashMap.put(((PrimitiveInfo)object).getKey(), object);
        }
        iterator = listArray[1].iterator();
        while (iterator.hasNext()) {
            object = (PrimitiveInfo)iterator.next();
            this.predicateHashMap.put(((PrimitiveInfo)object).getKey(), object);
        }
        iterator = listArray[2].iterator();
        while (iterator.hasNext()) {
            object = (PrimitiveInfo)iterator.next();
            this.functorHashMap.put(((PrimitiveInfo)object).getKey(), object);
        }
        object = new LinkedList(listArray[0]);
        object.addAll(listArray[1]);
        object.addAll(listArray[2]);
        this.libHashMap.put(iPrimitives, object);
    }

    void deletePrimitiveInfo(IPrimitives iPrimitives) {
        Iterator iterator = ((List)this.libHashMap.remove(iPrimitives)).iterator();
        while (iterator.hasNext()) {
            String string = ((PrimitiveInfo)iterator.next()).invalidate();
            this.directiveHashMap.remove(string);
            this.predicateHashMap.remove(string);
            this.functorHashMap.remove(string);
        }
    }

    public Term identifyDirective(Term term) {
        this.identify(term, 0);
        return term;
    }

    public boolean evalAsDirective(Struct struct) throws Throwable {
        PrimitiveInfo primitiveInfo = ((Struct)this.identifyDirective(struct)).getPrimitive();
        if (primitiveInfo != null) {
            try {
                primitiveInfo.evalAsDirective(struct);
                return true;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        return false;
    }

    public void identifyPredicate(Term term) {
        this.identify(term, 1);
    }

    public void identifyFunctor(Term term) {
        this.identify(term, 2);
    }

    private void identify(Term term, int n) {
        int n2;
        if (term == null) {
            return;
        }
        if (!((term = term.getTerm()) instanceof Struct)) {
            return;
        }
        Struct struct = (Struct)term;
        int n3 = struct.getArity();
        String string = struct.getName();
        if (string.equals(",") || string.equals("':-'") || string.equals(":-")) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.identify(struct.getArg(n2), 1);
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                this.identify(struct.getArg(n2), 2);
            }
        }
        PrimitiveInfo primitiveInfo = null;
        String string2 = string + "/" + n3;
        switch (n) {
            case 0: {
                primitiveInfo = (PrimitiveInfo)this.directiveHashMap.get(string2);
                break;
            }
            case 1: {
                primitiveInfo = (PrimitiveInfo)this.predicateHashMap.get(string2);
                break;
            }
            case 2: {
                primitiveInfo = (PrimitiveInfo)this.functorHashMap.get(string2);
            }
        }
        struct.setPrimitive(primitiveInfo);
    }

    Library getLibraryDirective(String string, int n) {
        try {
            return (Library)((PrimitiveInfo)this.directiveHashMap.get(string + "/" + n)).getSource();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    Library getLibraryPredicate(String string, int n) {
        try {
            return (Library)((PrimitiveInfo)this.predicateHashMap.get(string + "/" + n)).getSource();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    Library getLibraryFunctor(String string, int n) {
        try {
            return (Library)((PrimitiveInfo)this.functorHashMap.get(string + "/" + n)).getSource();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

