/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Engine;
import alice.tuprolog.EngineManager;
import alice.tuprolog.ExecutionContext;
import alice.tuprolog.FlagManager;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.LibraryManager;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Parser;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.TheoryManager;
import alice.tuprolog.event.LibraryEvent;
import alice.tuprolog.event.LibraryListener;
import alice.tuprolog.event.OutputEvent;
import alice.tuprolog.event.OutputListener;
import alice.tuprolog.event.QueryEvent;
import alice.tuprolog.event.QueryListener;
import alice.tuprolog.event.SpyEvent;
import alice.tuprolog.event.SpyListener;
import alice.tuprolog.event.TheoryEvent;
import alice.tuprolog.event.TheoryListener;
import alice.tuprolog.event.WarningEvent;
import alice.tuprolog.event.WarningListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Prolog
implements Serializable {
    private static final String VERSION = "2.1";
    private TheoryManager theoryManager;
    private PrimitiveManager primitiveManager;
    private OperatorManager opManager;
    private FlagManager flagManager;
    private LibraryManager libraryManager;
    private EngineManager engineManager;
    private boolean spy;
    private boolean warning;
    private ArrayList outputListeners = new ArrayList();
    private ArrayList spyListeners = new ArrayList();
    private ArrayList warningListeners = new ArrayList();
    private ArrayList theoryListeners;
    private ArrayList libraryListeners;
    private ArrayList queryListeners;

    public Prolog() {
        this(false, true);
        try {
            this.loadLibrary("alice.tuprolog.lib.BasicLibrary");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.ISOLibrary");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.IOLibrary");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.JavaLibrary");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Prolog(String[] stringArray) throws InvalidLibraryException {
        this(false, true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.loadLibrary(stringArray[i]);
            }
        }
    }

    private Prolog(boolean bl, boolean bl2) {
        this.spy = bl;
        this.warning = bl2;
        this.theoryListeners = new ArrayList();
        this.queryListeners = new ArrayList();
        this.libraryListeners = new ArrayList();
        this.initializeManagers();
    }

    private void initializeManagers() {
        this.flagManager = new FlagManager();
        this.libraryManager = new LibraryManager();
        this.opManager = new OperatorManager();
        this.theoryManager = new TheoryManager();
        this.primitiveManager = new PrimitiveManager();
        this.engineManager = new EngineManager();
        this.theoryManager.initialize(this);
        this.libraryManager.initialize(this);
        this.flagManager.initialize(this);
        this.primitiveManager.initialize(this);
        this.engineManager.initialize(this);
    }

    FlagManager getFlagManager() {
        return this.flagManager;
    }

    TheoryManager getTheoryManager() {
        return this.theoryManager;
    }

    PrimitiveManager getPrimitiveManager() {
        return this.primitiveManager;
    }

    LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    OperatorManager getOperatorManager() {
        return this.opManager;
    }

    EngineManager getEngineManager() {
        return this.engineManager;
    }

    public static String getVersion() {
        return VERSION;
    }

    public synchronized void setTheory(Theory theory) throws InvalidTheoryException {
        this.theoryManager.clear();
        this.addTheory(theory);
    }

    public synchronized void addTheory(Theory theory) throws InvalidTheoryException {
        Theory theory2 = this.theoryManager.getLastConsultedTheory();
        this.theoryManager.consult(theory, true, null);
        this.theoryManager.solveTheoryGoal();
        Theory theory3 = this.theoryManager.getLastConsultedTheory();
        TheoryEvent theoryEvent = new TheoryEvent(this, theory2, theory3);
        this.notifyChangedTheory(theoryEvent);
    }

    public synchronized Theory getTheory() {
        try {
            return new Theory(this.theoryManager.getTheory(true));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized Theory getLastConsultedTheory() {
        try {
            return this.theoryManager.getLastConsultedTheory();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void clearTheory() {
        try {
            this.setTheory(new Theory());
        }
        catch (InvalidTheoryException invalidTheoryException) {
            // empty catch block
        }
    }

    public synchronized Library loadLibrary(String string) throws InvalidLibraryException {
        return this.libraryManager.loadLibrary(string);
    }

    public synchronized void loadLibrary(Library library) throws InvalidLibraryException {
        this.libraryManager.loadLibrary(library);
    }

    public synchronized String[] getCurrentLibraries() {
        return this.libraryManager.getCurrentLibraries();
    }

    public synchronized void unloadLibrary(String string) throws InvalidLibraryException {
        this.libraryManager.unloadLibrary(string);
    }

    public synchronized Library getLibrary(String string) {
        return this.libraryManager.getLibrary(string);
    }

    protected Library getLibraryPredicate(String string, int n) {
        return this.primitiveManager.getLibraryPredicate(string, n);
    }

    protected Library getLibraryFunctor(String string, int n) {
        return this.primitiveManager.getLibraryFunctor(string, n);
    }

    public synchronized List getCurrentOperatorList() {
        return this.opManager.getOperators();
    }

    public synchronized SolveInfo solve(Term term) {
        if (term == null) {
            return null;
        }
        SolveInfo solveInfo = this.engineManager.solve(term);
        QueryEvent queryEvent = new QueryEvent(this, solveInfo);
        this.notifyNewQueryResultAvailable(queryEvent);
        return solveInfo;
    }

    public synchronized SolveInfo solve(String string) throws MalformedGoalException {
        try {
            Parser parser = new Parser(this.opManager, string);
            Term term = parser.nextTerm(true);
            return this.solve(term);
        }
        catch (InvalidTermException invalidTermException) {
            throw new MalformedGoalException();
        }
    }

    public synchronized SolveInfo solveNext() throws NoMoreSolutionException {
        if (this.hasOpenAlternatives()) {
            SolveInfo solveInfo = this.engineManager.solveNext();
            QueryEvent queryEvent = new QueryEvent(this, solveInfo);
            this.notifyNewQueryResultAvailable(queryEvent);
            return solveInfo;
        }
        throw new NoMoreSolutionException();
    }

    public void solveHalt() {
        this.engineManager.solveHalt();
    }

    public synchronized void solveEnd() {
        this.engineManager.solveEnd();
    }

    public synchronized boolean hasOpenAlternatives() {
        return this.engineManager.hasOpenAlternatives();
    }

    public synchronized boolean isHalted() {
        return this.engineManager.isHalted();
    }

    public synchronized boolean match(Term term, Term term2) {
        return term.match(term2);
    }

    public synchronized boolean unify(Term term, Term term2) {
        return term.unify(this, term2);
    }

    public synchronized void identifyFunctor(Term term) {
        this.primitiveManager.identifyFunctor(term);
    }

    public synchronized Term toTerm(String string) throws InvalidTermException {
        return Parser.parseSingleTerm(string, this.opManager);
    }

    public synchronized String toString(Term term) {
        return term.toStringAsArgY(this.opManager, 1200);
    }

    boolean defineFlag(String string, Struct struct, Term term, boolean bl, String string2) {
        return this.flagManager.defineFlag(string, struct, term, bl, string2);
    }

    public synchronized void setSpy(boolean bl) {
        this.spy = bl;
    }

    public synchronized boolean isSpy() {
        return this.spy;
    }

    protected void spy(String string) {
        if (this.spy) {
            this.notifySpy(new SpyEvent(this, string));
        }
    }

    protected void spy(String string, Engine engine) {
        if (this.spy) {
            ExecutionContext executionContext = engine.currentContext;
            int n = 0;
            String string2 = "-";
            if (executionContext.fatherCtx != null) {
                n = executionContext.depth - 1;
                string2 = executionContext.fatherCtx.currentGoal.toString();
            }
            this.notifySpy(new SpyEvent(this, engine, "spy: " + n + "  " + string + "  " + string2));
        }
    }

    public synchronized void setWarning(boolean bl) {
        this.warning = bl;
    }

    public synchronized boolean isWarning() {
        return this.warning;
    }

    public void warn(String string) {
        if (this.warning) {
            this.notifyWarning(new WarningEvent(this, string));
        }
    }

    public synchronized void stdOutput(String string) {
        this.notifyOutput(new OutputEvent(this, string));
    }

    public synchronized void addOutputListener(OutputListener outputListener) {
        this.outputListeners.add(outputListener);
    }

    public synchronized void addTheoryListener(TheoryListener theoryListener) {
        this.theoryListeners.add(theoryListener);
    }

    public synchronized void addLibraryListener(LibraryListener libraryListener) {
        this.libraryListeners.add(libraryListener);
    }

    public synchronized void addQueryListener(QueryListener queryListener) {
        this.queryListeners.add(queryListener);
    }

    public synchronized void addSpyListener(SpyListener spyListener) {
        this.spyListeners.add(spyListener);
    }

    public synchronized void addWarningListener(WarningListener warningListener) {
        this.warningListeners.add(warningListener);
    }

    public synchronized void removeOutputListener(OutputListener outputListener) {
        this.outputListeners.remove(outputListener);
    }

    public synchronized void removeAllOutputListeners() {
        this.outputListeners.clear();
    }

    public synchronized void removeTheoryListener(TheoryListener theoryListener) {
        this.theoryListeners.remove(theoryListener);
    }

    public synchronized void removeLibraryListener(LibraryListener libraryListener) {
        this.libraryListeners.remove(libraryListener);
    }

    public synchronized void removeQueryListener(QueryListener queryListener) {
        this.queryListeners.remove(queryListener);
    }

    public synchronized void removeSpyListener(SpyListener spyListener) {
        this.spyListeners.remove(spyListener);
    }

    public synchronized void removeAllSpyListeners() {
        this.spyListeners.clear();
    }

    public synchronized void removeWarningListener(WarningListener warningListener) {
        this.warningListeners.remove(warningListener);
    }

    public synchronized void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    public synchronized List getOutputListenerList() {
        return (List)this.outputListeners.clone();
    }

    public synchronized List getWarningListenerList() {
        return (List)this.warningListeners.clone();
    }

    public synchronized List getSpyListenerList() {
        return (List)this.spyListeners.clone();
    }

    public synchronized List getTheoryListenerList() {
        return (List)this.theoryListeners.clone();
    }

    public synchronized List getLibraryListenerList() {
        return (List)this.libraryListeners.clone();
    }

    public synchronized List getQueryListenerList() {
        return (List)this.queryListeners.clone();
    }

    protected void notifyOutput(OutputEvent outputEvent) {
        ListIterator listIterator = this.outputListeners.listIterator();
        while (listIterator.hasNext()) {
            ((OutputListener)listIterator.next()).onOutput(outputEvent);
        }
    }

    protected void notifySpy(SpyEvent spyEvent) {
        ListIterator listIterator = this.spyListeners.listIterator();
        while (listIterator.hasNext()) {
            ((SpyListener)listIterator.next()).onSpy(spyEvent);
        }
    }

    protected void notifyWarning(WarningEvent warningEvent) {
        ListIterator listIterator = this.warningListeners.listIterator();
        while (listIterator.hasNext()) {
            ((WarningListener)listIterator.next()).onWarning(warningEvent);
        }
    }

    protected void notifyChangedTheory(TheoryEvent theoryEvent) {
        ListIterator listIterator = this.theoryListeners.listIterator();
        while (listIterator.hasNext()) {
            ((TheoryListener)listIterator.next()).theoryChanged(theoryEvent);
        }
    }

    protected void notifyLoadedLibrary(LibraryEvent libraryEvent) {
        ListIterator listIterator = this.libraryListeners.listIterator();
        while (listIterator.hasNext()) {
            ((LibraryListener)listIterator.next()).libraryLoaded(libraryEvent);
        }
    }

    protected void notifyUnloadedLibrary(LibraryEvent libraryEvent) {
        ListIterator listIterator = this.libraryListeners.listIterator();
        while (listIterator.hasNext()) {
            ((LibraryListener)listIterator.next()).libraryUnloaded(libraryEvent);
        }
    }

    protected void notifyNewQueryResultAvailable(QueryEvent queryEvent) {
        ListIterator listIterator = this.queryListeners.listIterator();
        while (listIterator.hasNext()) {
            ((QueryListener)listIterator.next()).newQueryResultAvailable(queryEvent);
        }
    }
}

