/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Parser;
import alice.tuprolog.Term;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

class TermIterator
implements Iterator,
Serializable {
    private Parser parser;
    private boolean hasNext;
    private Term next;
    private String parserError;

    TermIterator(Parser parser) {
        this.parser = parser;
        try {
            this.next = this.parser.nextTerm(true);
            this.hasNext = this.next != null;
        }
        catch (InvalidTermException invalidTermException) {
            this.parserError = invalidTermException.getMessage();
            this.hasNext = false;
        }
    }

    public Object next() {
        if (this.hasNext) {
            if (this.next == null) {
                try {
                    this.next = this.parser.nextTerm(true);
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                catch (InvalidTermException invalidTermException) {
                    throw new NoSuchElementException();
                }
            }
            this.hasNext = false;
            Term term = this.next;
            this.next = null;
            return term;
        }
        if (this.hasNext()) {
            this.hasNext = false;
            Term term = this.next;
            this.next = null;
            return term;
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        if (this.hasNext) {
            return this.hasNext;
        }
        if (this.parserError != null) {
            return this.hasNext;
        }
        try {
            this.next = this.parser.nextTerm(true);
            if (this.next != null) {
                this.hasNext = true;
            }
        }
        catch (InvalidTermException invalidTermException) {
            this.parserError = invalidTermException.getMessage();
            this.next = null;
            this.hasNext = false;
        }
        return this.hasNext;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String getParserError() {
        return this.parserError;
    }
}

