/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseDatabase;
import alice.tuprolog.ClauseInfo;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.Var;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class TheoryManager
implements Serializable {
    private ClauseDatabase dynamicDBase;
    private ClauseDatabase staticDBase;
    private Prolog engine;
    private PrimitiveManager primitiveManager;
    private Stack startGoalStack;
    Theory lastConsultedTheory;

    void initialize(Prolog prolog) {
        this.dynamicDBase = new ClauseDatabase();
        this.staticDBase = new ClauseDatabase();
        this.lastConsultedTheory = new Theory();
        this.engine = prolog;
        this.primitiveManager = this.engine.getPrimitiveManager();
    }

    void assertA(Struct struct, boolean bl, String string, boolean bl2) {
        ClauseInfo clauseInfo = new ClauseInfo(this.toClause(struct), string);
        String string2 = clauseInfo.getHead().getPredicateIndicator();
        if (bl) {
            this.dynamicDBase.addFirst(string2, clauseInfo);
            if (this.staticDBase.containsKey(string2)) {
                this.engine.warn("A static predicate with signature " + string2 + " has been overriden.");
            }
        } else {
            this.staticDBase.addFirst(string2, clauseInfo);
        }
        this.engine.spy("INSERTA: " + clauseInfo.getClause() + "\n");
    }

    void assertZ(Struct struct, boolean bl, String string, boolean bl2) {
        ClauseInfo clauseInfo = new ClauseInfo(this.toClause(struct), string);
        String string2 = clauseInfo.getHead().getPredicateIndicator();
        if (bl) {
            this.dynamicDBase.addLast(string2, clauseInfo);
            if (this.staticDBase.containsKey(string2)) {
                this.engine.warn("A static predicate with signature " + string2 + " has been overriden.");
            }
        } else {
            this.staticDBase.addLast(string2, clauseInfo);
        }
        this.engine.spy("INSERTZ: " + clauseInfo.getClause() + "\n");
    }

    ClauseInfo retract(Struct struct) {
        Struct struct2 = this.toClause(struct);
        Struct struct3 = (Struct)struct2.getArg(0);
        LinkedList linkedList = (LinkedList)this.dynamicDBase.get(struct3.getPredicateIndicator());
        if (linkedList == null) {
            return null;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ClauseInfo clauseInfo = (ClauseInfo)iterator.next();
            if (!struct2.match(clauseInfo.getClause())) continue;
            iterator.remove();
            this.engine.spy("DELETE: " + clauseInfo.getClause() + "\n");
            return new ClauseInfo(clauseInfo.getClause(), null);
        }
        return null;
    }

    boolean abolish(Struct struct) {
        String string = (struct = this.toClause(struct)).getPredicateIndicator();
        LinkedList linkedList = this.dynamicDBase.abolish(string);
        if (linkedList != null) {
            this.engine.spy("ABOLISHED: " + string + " number of clauses=" + linkedList.size() + "\n");
        }
        return true;
    }

    List find(Term term) {
        if (term instanceof Struct) {
            String string = ((Struct)term).getPredicateIndicator();
            List list = this.dynamicDBase.getPredicates(string);
            if (list.isEmpty()) {
                list = this.staticDBase.getPredicates(string);
            }
            return list;
        }
        if (term instanceof Var) {
            throw new RuntimeException();
        }
        return new LinkedList();
    }

    void consult(Theory theory, boolean bl, String string) throws InvalidTheoryException {
        this.startGoalStack = new Stack();
        Iterator iterator = theory.iterator(this.engine);
        while (iterator.hasNext()) {
            Struct struct = (Struct)iterator.next();
            if (this.runDirective(struct)) continue;
            this.assertZ(struct, bl, string, true);
        }
        if (string == null) {
            this.lastConsultedTheory.append(theory);
        }
    }

    void rebindPrimitives() {
        Iterator iterator = this.dynamicDBase.iterator();
        while (iterator.hasNext()) {
            ClauseInfo clauseInfo = (ClauseInfo)iterator.next();
            Iterator iterator2 = clauseInfo.getBody().iterator();
            while (iterator2.hasNext()) {
                this.primitiveManager.identifyPredicate((Struct)iterator2.next());
            }
        }
    }

    void clear() {
        this.dynamicDBase = new ClauseDatabase();
    }

    void removeLibraryTheory(String string) {
        Iterator iterator = this.staticDBase.iterator();
        while (iterator.hasNext()) {
            ClauseInfo clauseInfo = (ClauseInfo)iterator.next();
            if (clauseInfo.libName == null || !string.equals(clauseInfo.libName)) continue;
            iterator.remove();
        }
    }

    private boolean runDirective(Struct struct) {
        if ("':-'".equals(struct.getName()) || ":-".equals(struct.getName()) && struct.getArity() == 1 && struct.getTerm(0) instanceof Struct) {
            Struct struct2 = (Struct)struct.getTerm(0);
            try {
                if (!this.primitiveManager.evalAsDirective(struct2)) {
                    this.engine.warn("The directive " + struct2.getPredicateIndicator() + " is unknown.");
                }
            }
            catch (Throwable throwable) {
                this.engine.warn("An exception has been thrown during the execution of the " + struct2.getPredicateIndicator() + " directive.\n" + throwable.getMessage());
            }
            return true;
        }
        return false;
    }

    private Struct toClause(Struct struct) {
        try {
            struct = (Struct)Term.createTerm(struct.toString(), this.engine.getOperatorManager());
        }
        catch (InvalidTermException invalidTermException) {
            // empty catch block
        }
        if (!struct.isClause()) {
            struct = new Struct(":-", struct, new Struct("true"));
        }
        this.primitiveManager.identifyPredicate(struct);
        return struct;
    }

    void solveTheoryGoal() {
        Struct struct = null;
        while (!this.startGoalStack.empty()) {
            struct = struct == null ? (Struct)this.startGoalStack.pop() : new Struct(",", (Struct)this.startGoalStack.pop(), struct);
        }
        if (struct != null) {
            try {
                this.engine.solve(struct);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void addStartGoal(Struct struct) {
        this.startGoalStack.push(struct);
    }

    boolean save(OutputStream outputStream, boolean bl) {
        try {
            new DataOutputStream(outputStream).writeBytes(this.getTheory(bl));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String getTheory(boolean bl) {
        ClauseInfo clauseInfo;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.dynamicDBase.iterator();
        while (iterator.hasNext()) {
            clauseInfo = (ClauseInfo)iterator.next();
            stringBuffer.append(clauseInfo.toString(this.engine.getOperatorManager())).append("\n");
        }
        if (!bl) {
            iterator = this.staticDBase.iterator();
            while (iterator.hasNext()) {
                clauseInfo = (ClauseInfo)iterator.next();
                stringBuffer.append(clauseInfo.toString(this.engine.getOperatorManager())).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    Theory getLastConsultedTheory() {
        return this.lastConsultedTheory;
    }
}

