/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;

public class Var
extends Term {
    static final String ANY = "_";
    private String name;
    private String completeName;
    private Term link;
    private long timestamp;
    private int id;
    static final int ORIGINAL = -1;
    static final int PROGRESSIVE = -2;

    public Var(String string) throws InvalidTermException {
        this.link = null;
        this.id = -1;
        if (string.equals(ANY)) {
            this.name = null;
            this.completeName = null;
        } else if (Character.isUpperCase(string.charAt(0)) || string.startsWith(ANY)) {
            this.name = string;
            this.completeName = string;
        } else {
            throw new InvalidTermException("Illegal variable name: " + string);
        }
    }

    public Var() {
        this.name = null;
        this.completeName = null;
        this.link = null;
        this.id = -1;
        this.timestamp = 0L;
    }

    private Var(String string, int n, int n2, long l) {
        this.name = string;
        this.timestamp = l;
        this.link = null;
        if (n < 0) {
            n = -1;
        }
        this.rename(n, n2);
    }

    void rename(int n, int n2) {
        this.id = n;
        if (n > -1) {
            this.completeName = this.name + "_e" + n;
        }
        if (this.id == -1) {
            this.completeName = this.name;
        }
        if (this.id == -2) {
            this.completeName = ANY + n2;
        }
    }

    Term copy(AbstractMap abstractMap, int n) {
        Term term = this.getTerm();
        if (term == this) {
            Var var = (Var)abstractMap.get(this);
            if (var == null) {
                var = new Var(this.name, n, 0, this.timestamp);
                abstractMap.put(this, var);
            }
            return var;
        }
        return term.copy(abstractMap, n);
    }

    Term copy(AbstractMap abstractMap, AbstractMap abstractMap2) {
        Var var;
        Object v = abstractMap.get(this);
        if (v == null) {
            var = new Var(null, -2, abstractMap.size(), this.timestamp);
            abstractMap.put(this, var);
        } else {
            var = (Var)v;
        }
        Term term = this.getTerm();
        if (term instanceof Var) {
            Object v2 = abstractMap2.get(term);
            if (v2 == null) {
                abstractMap2.put(term, var);
                var.link = null;
            } else {
                Term term2 = var.link = v2 != var ? (Var)v2 : null;
            }
        }
        if (term instanceof Struct) {
            var.link = term.copy(abstractMap, abstractMap2);
        }
        if (term instanceof Number) {
            var.link = term;
        }
        return var;
    }

    public void free() {
        this.link = null;
    }

    public static void free(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((Var)iterator.next()).free();
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.completeName;
        }
        return ANY;
    }

    public String getOriginalName() {
        if (this.name != null) {
            return this.name;
        }
        return ANY;
    }

    public Term getTerm() {
        Term term = this;
        Term term2 = this.link;
        while (term2 != null) {
            term = term2;
            if (!(term2 instanceof Var)) break;
            term2 = ((Var)term2).link;
        }
        return term;
    }

    Term getLink() {
        return this.link;
    }

    void setLink(Term term) {
        this.link = term;
    }

    void setTimestamp(long l) {
        this.timestamp = l;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isStruct() {
        return false;
    }

    public boolean isVar() {
        return true;
    }

    public boolean isEmptyList() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isEmptyList();
    }

    public boolean isAtomic() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isAtomic();
    }

    public boolean isCompound() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isCompound();
    }

    public boolean isAtom() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isAtom();
    }

    public boolean isList() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isList();
    }

    public boolean isGround() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isGround();
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public boolean isBound() {
        return this.link != null;
    }

    private boolean occurCheck(List list, Struct struct) {
        int n = struct.getArity();
        for (int i = 0; i < n; ++i) {
            Term term = struct.getTerm(i);
            if (term instanceof Struct) {
                if (!this.occurCheck(list, (Struct)term)) continue;
                return true;
            }
            if (!(term instanceof Var)) continue;
            Var var = (Var)term;
            if (var.link == null) {
                list.add(var);
            }
            if (this != var) continue;
            return true;
        }
        return false;
    }

    long resolveTerm(long l) {
        Term term = this.getTerm();
        if (term != this) {
            return term.resolveTerm(l);
        }
        this.timestamp = l;
        return l++;
    }

    boolean unify(List list, List list2, Term term) {
        Term term2 = this.getTerm();
        if (term2 == this) {
            if ((term = term.getTerm()) instanceof Var) {
                if (this == term) {
                    try {
                        list.add(this);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    return true;
                }
            } else if (term instanceof Struct ? this.occurCheck(list2, (Struct)term) : !(term instanceof Number)) {
                return false;
            }
            this.link = term;
            try {
                list.add(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        return term2.unify(list, list2, term);
    }

    public boolean isGreater(Term term) {
        Term term2 = this.getTerm();
        if (term2 == this) {
            if (!((term = term.getTerm()) instanceof Var)) {
                return false;
            }
            return this.timestamp > ((Var)term).timestamp;
        }
        return term2.isGreater(term);
    }

    public boolean isEqual(Term term) {
        Term term2 = this.getTerm();
        if (term2 == this) {
            return (term = term.getTerm()) instanceof Var && this.timestamp == ((Var)term).timestamp;
        }
        return term2.isEqual(term);
    }

    public String toString() {
        Term term = this.getTerm();
        if (this.name != null) {
            if (term == this) {
                return this.completeName;
            }
            return this.completeName + " / " + term.toString();
        }
        if (term == this) {
            return ANY;
        }
        return term.toString();
    }

    public String toStringFlattened() {
        Term term = this.getTerm();
        if (this.name != null) {
            if (term == this) {
                return this.completeName;
            }
            return term.toString();
        }
        if (term == this) {
            return ANY;
        }
        return term.toString();
    }
}

