/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Agent;
import alice.tuprolog.Double;
import alice.tuprolog.Float;
import alice.tuprolog.Int;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.Operator;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.Var;
import alice.tuprolog.lib.TheoryLibrary;
import alice.util.Tools;
import java.util.Iterator;

public class BasicLibrary
extends Library {
    public boolean set_theory_1(Term term) {
        Struct struct = (Struct)term.getTerm();
        try {
            if (!struct.isAtom()) {
                return false;
            }
            this.getEngine().setTheory(new Theory(struct.getName()));
            return true;
        }
        catch (InvalidTheoryException invalidTheoryException) {
            System.err.println("invalid theory - line " + invalidTheoryException.line);
            return false;
        }
    }

    public boolean add_theory_1(Term term) {
        Struct struct = (Struct)term.getTerm();
        try {
            if (!struct.isAtom()) {
                return false;
            }
            this.getEngine().addTheory(new Theory(struct.getName()));
            return true;
        }
        catch (InvalidTheoryException invalidTheoryException) {
            System.err.println("invalid theory - line " + invalidTheoryException.line);
            return false;
        }
    }

    public boolean get_theory_1(Term term) {
        term = term.getTerm();
        try {
            Struct struct = new Struct(this.getEngine().getTheory().toString());
            return this.unify(term, struct);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean load_library_2(Term term, Term term2) {
        Struct struct = (Struct)term.getTerm();
        term2 = term2.getTerm();
        try {
            Library library = this.getEngine().loadLibrary(Tools.removeApices(struct.getName()));
            return this.unify(term2, new Struct(library.getName()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean load_library_from_theory_2(Term term, Term term2) {
        Struct struct = (Struct)term.getTerm();
        Struct struct2 = (Struct)term2.getTerm();
        try {
            if (!struct.isAtom()) {
                return false;
            }
            if (!struct2.isAtom()) {
                return false;
            }
            Theory theory = new Theory(struct.getName());
            TheoryLibrary theoryLibrary = new TheoryLibrary(struct2.getName(), theory);
            this.getEngine().loadLibrary(theoryLibrary);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean get_operators_list_1(Term term) {
        Struct struct = (Struct)term.getTerm();
        Struct struct2 = new Struct();
        Iterator iterator = this.getEngine().getCurrentOperatorList().iterator();
        while (iterator.hasNext()) {
            Operator operator = (Operator)iterator.next();
            struct2 = new Struct(new Struct("op", new Int(operator.prio), new Struct(operator.type), new Struct(operator.name)), (Term)struct2);
        }
        return this.unify(struct, struct2);
    }

    public boolean agent_1(Term term) {
        Struct struct = (Struct)term.getTerm();
        try {
            new Agent(Tools.removeApices(struct.toString())).spawn();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean agent_2(Term term, Term term2) {
        Struct struct = (Struct)term.getTerm();
        Struct struct2 = (Struct)term2.getTerm();
        try {
            new Agent(Tools.removeApices(struct.toString()), struct2.toString() + ".").spawn();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean spy_0() {
        this.getEngine().setSpy(true);
        return true;
    }

    public boolean nospy_0() {
        this.getEngine().setSpy(false);
        return true;
    }

    public boolean warning_0() {
        this.getEngine().setWarning(true);
        return true;
    }

    public boolean nowarning_0() {
        this.getEngine().setWarning(false);
        return true;
    }

    public boolean constant_1(Term term) {
        term = term.getTerm();
        return term.isAtomic();
    }

    public boolean number_1(Term term) {
        return term.getTerm() instanceof Number;
    }

    public boolean integer_1(Term term) {
        Number number = (Number)term.getTerm();
        return number.isInteger();
    }

    public boolean float_1(Term term) {
        Number number = (Number)term.getTerm();
        return number.isReal();
    }

    public boolean atom_1(Term term) {
        term = term.getTerm();
        return term.isAtom();
    }

    public boolean compound_1(Term term) {
        return (term = term.getTerm()) instanceof Struct && !term.isAtom();
    }

    public boolean list_1(Term term) {
        term = term.getTerm();
        return term.isList();
    }

    public boolean var_1(Term term) {
        term = term.getTerm();
        return term instanceof Var;
    }

    public boolean nonvar_1(Term term) {
        return !((term = term.getTerm()) instanceof Var);
    }

    public boolean atomic_1(Term term) {
        return (term = term.getTerm()).isAtom() || term instanceof Number;
    }

    public boolean ground_1(Term term) {
        term = term.getTerm();
        return term.isGround();
    }

    public boolean expression_equality_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 == null || term4 == null || !(term3 instanceof Number) || !(term4 instanceof Number)) {
            return false;
        }
        Number number = (Number)term3;
        Number number2 = (Number)term4;
        if (number.isInteger() && number2.isInteger()) {
            return number.intValue() == number2.intValue();
        }
        return number.doubleValue() == number2.doubleValue();
    }

    public boolean expression_greater_than_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 == null || term4 == null || !(term3 instanceof Number) || !(term4 instanceof Number)) {
            return false;
        }
        return this.expression_greater_than((Number)term3, (Number)term4);
    }

    public boolean expression_less_or_equal_than_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 == null || term4 == null || !(term3 instanceof Number) || !(term4 instanceof Number)) {
            return false;
        }
        return !this.expression_greater_than((Number)term3, (Number)term4);
    }

    private boolean expression_greater_than(Number number, Number number2) {
        if (number.isInteger() && number2.isInteger()) {
            return number.intValue() > number2.intValue();
        }
        return number.doubleValue() > number2.doubleValue();
    }

    public boolean expression_less_than_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 == null || term4 == null || !(term3 instanceof Number) || !(term4 instanceof Number)) {
            return false;
        }
        return this.expression_less_than((Number)term3, (Number)term4);
    }

    public boolean expression_greater_or_equal_than_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 == null || term4 == null || !(term3 instanceof Number) || !(term4 instanceof Number)) {
            return false;
        }
        return !this.expression_less_than((Number)term3, (Number)term4);
    }

    private boolean expression_less_than(Number number, Number number2) {
        if (number.isInteger() && number2.isInteger()) {
            return number.intValue() < number2.intValue();
        }
        return number.doubleValue() < number2.doubleValue();
    }

    public boolean term_equality_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        return term.isEqual(term2);
    }

    public boolean term_greater_than_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        return term.isGreater(term2);
    }

    public boolean term_less_than_2(Term term, Term term2) {
        return !(term = term.getTerm()).isGreater(term2 = term2.getTerm()) && !term.isEqual(term2);
    }

    public Term expression_plus_1(Term term) {
        Term term2 = this.evalExpression(term);
        if (term2 != null && term2 instanceof Number) {
            return term2;
        }
        return null;
    }

    public Term expression_minus_1(Term term) {
        Term term2 = this.evalExpression(term);
        if (term2 != null && term2 instanceof Number) {
            Number number = (Number)term2;
            if (number instanceof Int) {
                return new Int(number.intValue() * -1);
            }
            if (number instanceof Double) {
                return new Double(number.doubleValue() * -1.0);
            }
            if (number instanceof Long) {
                return new Long(number.longValue() * -1L);
            }
            if (number instanceof Float) {
                return new Float(number.floatValue() * -1.0f);
            }
            return null;
        }
        return null;
    }

    public Term expression_bitwise_not_1(Term term) {
        Term term2 = this.evalExpression(term);
        if (term2 != null && term2 instanceof Number) {
            return new Int(~((Number)term2).intValue());
        }
        return null;
    }

    Number getIntegerNumber(long l) {
        if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            return new Int((int)l);
        }
        return new Long(l);
    }

    public Term expression_plus_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(number.longValue() + number2.longValue());
            }
            return new Double(number.doubleValue() + number2.doubleValue());
        }
        return null;
    }

    public Term expression_minus_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(number.longValue() - number2.longValue());
            }
            return new Double(number.doubleValue() - number2.doubleValue());
        }
        return null;
    }

    public Term expression_multiply_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(number.longValue() * number2.longValue());
            }
            return new Double(number.doubleValue() * number2.doubleValue());
        }
        return null;
    }

    public Term expression_div_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            Double double_ = new Double(number.doubleValue() / number2.doubleValue());
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(double_.longValue());
            }
            return double_;
        }
        return null;
    }

    public Term expression_integer_div_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return this.getIntegerNumber(number.longValue() / number2.longValue());
        }
        return null;
    }

    public Term expression_pow_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Double(Math.pow(number.doubleValue(), number2.doubleValue()));
        }
        return null;
    }

    public Term expression_bitwise_shift_right_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Int(number.intValue() >> number2.intValue());
        }
        return null;
    }

    public Term expression_bitwise_shift_left_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Int(number.intValue() << number2.intValue());
        }
        return null;
    }

    public Term expression_bitwise_and_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Int(number.intValue() & number2.intValue());
        }
        return null;
    }

    public Term expression_bitwise_or_2(Term term, Term term2) {
        Term term3 = this.evalExpression(term);
        Term term4 = this.evalExpression(term2);
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Int(number.intValue() | number2.intValue());
        }
        return null;
    }

    public boolean text_term_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (!term.isGround()) {
            return this.unify(term, new Struct(term2.toString()));
        }
        try {
            String string = Tools.removeApices(term.toString());
            return this.unify(term2, this.getEngine().toTerm(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean text_concat_3(Term term, Term term2, Term term3) {
        term = term.getTerm();
        term2 = term2.getTerm();
        term3 = term3.getTerm();
        if (term.isAtom() && term2.isAtom()) {
            return this.unify(term3, new Struct(((Struct)term).getName() + ((Struct)term2).getName()));
        }
        return false;
    }

    public boolean num_atom_2(Term term, Term term2) {
        term = term.getTerm();
        if ((term2 = term2.getTerm()) instanceof Var) {
            if (!(term instanceof Number)) {
                return false;
            }
            Number number = (Number)term;
            String string = null;
            string = number.isInteger() ? new Integer(number.intValue()).toString() : new java.lang.Double(number.doubleValue()).toString();
            return this.unify(term2, new Struct(string));
        }
        if (!term2.isAtom()) {
            return false;
        }
        String string = ((Struct)term2).getName();
        try {
            if (string.startsWith("'") && string.endsWith("'")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Number number = null;
        try {
            number = new Int(Integer.parseInt(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (number == null) {
            try {
                number = new Double(java.lang.Double.parseDouble(((Struct)term2).getName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (number == null) {
            return false;
        }
        return this.unify(term, number);
    }

    public String getTheory() {
        return "':-'(op( 1200, fx,   ':-')). \n:- op( 1200, xfx,  ':-'). \n:- op( 1200, fx,   '?-'). \n:- op( 1100, xfy,  ';'). \n:- op( 1050, xfy,  '->'). \n:- op( 1000, xfy,  ','). \n:- op(  900, fy,   '\\+'). \n:- op(  900, fy,   'not'). \n:- op(  700, xfx,  '='). \n:- op(  700, xfx,  '\\='). \n:- op(  700, xfx,  '=='). \n:- op(  700, xfx,  '\\=='). \n:- op(  700, xfx,  '@>'). \n:- op(  700, xfx,  '@<'). \n:- op(  700, xfx,  '@=<'). \n:- op(  700, xfx,  '@>='). \n:- op(  700, xfx,  '=:='). \n:- op(  700, xfx,  '=\\='). \n:- op(  700, xfx,  '>'). \n:- op(  700, xfx,  '<'). \n:- op(  700, xfx,  '=<'). \n:- op(  700, xfx,  '>='). \n:- op(  700, xfx,  'is'). \n:- op(  700, xfx,  '=..'). \n:- op(  500, yfx,  '+'). \n:- op(  500, yfx,  '-'). \n:- op(  500, yfx,  '/\\'). \n:- op(  500, yfx,  '\\/'). \n:- op(  400, yfx,  '*'). \n:- op(  400, yfx,  '/'). \n:- op(  400, yfx,  '//'). \n:- op(  400, yfx,  '>>'). \n:- op(  400, yfx,  '<<'). \n:- op(  400, yfx,  'rem'). \n:- op(  400, yfx,  'mod'). \n:- op(  200, xfx,  '**'). \n:- op(  200, xfy,  '^'). \n:- op(  200, fy,   '\\'). \n:- op(  200, fy,   '-'). \ncurrent_prolog_flag(Name,Value) :- get_prolog_flag(Name,Value),!.\ncurrent_prolog_flag(Name,Value) :- flag_list(L), member(flag(Name,Value),L).\n'=:='(X,Y):- expression_equality(X,Y). \n'=\\='(X,Y):- not expression_equality(X,Y). \n'>'(X,Y):- expression_greater_than(X,Y). \n'<'(X,Y):- expression_less_than(X,Y). \n'>='(X,Y):- expression_greater_or_equal_than(X,Y). \n'=<'(X,Y):- expression_less_or_equal_than(X,Y). \n'=='(X,Y):- term_equality(X,Y).\n'\\=='(X,Y):- not term_equality(X,Y).\n'@>'(X,Y):- term_greater_than(X,Y).\n'@<'(X,Y):- term_less_than(X,Y).\n'@>='(X,Y):- not term_less_than(X,Y).\n'@=<'(X,Y):- not term_greater_than(X,Y).\n'=..'(T, [L]) :- atomic(T), !. \n'=..'(T,L)    :- compound(T),!,'$tolist'(T,L). \n                                                          '=..'(T,L)    :- nonvar(L),'$fromlist'(T,L). \n                                                          functor(Term, Name, Arity) :- atomic(Term), !, Name = Term, Arity = 0. \nfunctor(Term, Name, Arity) :- compound(Term), !, Term =.. [Name | Args], length(Args, Arity). \nfunctor(Term, Name, Arity) :- var(Term), atomic(Name), Arity == 0, !, Term = Name. \nfunctor(Term, Name, Arity) :- var(Term), atom(Name), I is Arity, integer(I), I > 0, newlist([], I, L), Term =.. [Name | L]. \narg(N,C,T):- nonvar(N), C =.. [_|Args], element(N,Args,T).\nclause(H,B)   :- L=[],'$find'(H,L),member((':-'(H,B)),L). \n                                            call(G) :- '$call'(G). \n'\\+'(P):- P,!,fail.\n                                                                            '\\+'(_).\n                                                                                             C -> T ; B :- !, or((call(C), !, call(T)), '$call'(B)). \nC -> T :- call(C), !, call(T). \nor(A, B) :- '$call'(A). \nor(A, B) :- '$call'(B). \nA ; B :- A =.. ['->', C, T], !, ('$call'(C), !, '$call'(T) ; '$call'(B)). \nA ; B :- '$call'(A). \nA ; B :- '$call'(B). \n unify_with_occurs_check(X,Y):-X=Y.\n                                                                     current_op(Pri,Type,Name):-get_operators_list(L),member(op(Pri,Type,Name),L).\n                          once(X) :- myonce(X).\n                                                                                  myonce(X):-X,!.\n                                                                                        repeat. \n                                                                                              repeat        :- repeat. \n                                                                             not(G)        :- G,!,fail. \n                                                                     not(_). \n                                                                                              findall(Template, Goal, Instances) :- \nL = [], \n'$findall0'(Template, Goal, L), \nInstances = L. \n'$findall0'(Template, Goal, L) :- \ncall(Goal), \ncopy_term(Template, CL), \n'$append'(CL, L), \nfail. \n'$findall0'(_, _, _). \nvariable_set(T, []) :- atomic(T), !. \nvariable_set(T, [T]) :- var(T), !. \nvariable_set([H | T], [SH | ST]) :- \nvariable_set(H, SH), variable_set(T, ST). \nvariable_set(T, S) :- \nT =.. [_ | Args], variable_set(Args, L), flatten(L, FL), no_duplicates(FL, S), !. \nflatten(L, FL) :- '$flatten0'(L, FL), !. \n'$flatten0'(T, []) :- nonvar(T), T = []. \n'$flatten0'(T, [T]) :- var(T). \n'$flatten0'([H | T], [H | FT]) :- \nnot(islist(H)), !, '$flatten0'(T, FT). \n'$flatten0'([H | T], FL) :- \n'$flatten0'(H, FH), '$flatten0'(T, FT), append(FH, FT, FL). \nislist([]). \nislist([_|L]):- islist(L). \n existential_variables_set(Term, Set) :- '$existential_variables_set0'(Term, Set), !. \n'$existential_variables_set0'(Term, []) :- var(Term), !. \n'$existential_variables_set0'(Term, []) :- atomic(Term), !. \n'$existential_variables_set0'(V ^ G, Set) :- \nvariable_set(V, VS), '$existential_variables_set0'(G, EVS), append(VS, EVS, Set). \n'$existential_variables_set0'(Term, []) :- nonvar(Term), !. \nfree_variables_set(Term, WithRespectTo, Set) :- \nvariable_set(Term, VS), \nvariable_set(WithRespectTo, VS1), existential_variables_set(Term, EVS1), append(VS1, EVS1, BV), \nlist_difference(VS, BV, List), no_duplicates(List, Set), !. \nlist_difference(List, Subtrahend, Difference) :- '$ld'(List, Subtrahend, Difference). \n'$ld'([], _, []). \n'$ld'([H | T], S, D) :- is_member(H, S), !, '$ld'(T, S, D). \n'$ld'([H | T], S, [H | TD]) :- '$ld'(T, S, TD). \nno_duplicates([], []). \nno_duplicates([H | T], L) :- is_member(H, T), !, no_duplicates(T, L). \nno_duplicates([H | T], [H | L]) :- no_duplicates(T, L). \nis_member(E, [H | _]) :- E == H, !. \nis_member(E, [_ | T]) :- is_member(E, T). \n'$wt_list'([], []). \n'$wt_list'([W + T | STail], [WW + T | WTTail]) :- copy_term(W, WW), '$wt_list'(STail, WTTail). \n'$s_next'(Witness, WT_List, S_Next) :- copy_term(Witness, W2), '$s_next0'(W2, WT_List, S_Next), !. \nbagof(Template, Goal, Instances) :- \nfree_variables_set(Goal, Template, Set), \nWitness =.. [witness | Set], \niterated_goal_term(Goal, G), \nfindall(Witness + Template, G, S), \n'$bagof0'(Witness, S, Instances). \n'$bagof0'(_, [], _) :- !, fail. \n'$bagof0'(Witness, S, Instances) :- \n'$wt_list'(S, WT_List), \n'$wt_unify'(Witness, WT_List, T_List), \nInstances = T_List. \n'$bagof0'(Witness, S, Instances) :- \n'$wt_list'(S, WT_List), \n'$s_next'(Witness, WT_List, S_Next), \n'$bagof0'(Witness, S_Next, Instances). \nsetof(Template, Goal, Instances) :- \nbagof(Template, Goal, List), \nquicksort(List, '@<', OrderedList), \nno_duplicates(OrderedList, Instances). \nassert(C) :- assertz(C). \nretract(Rule) :- Rule = ':-'(Head, Body), !, clause(Head, Body), '$retract'(Rule). \nretract(Fact) :- clause(Fact, true), '$retract'(Fact). \nretractall(Head) :- findall(Head, clause(Head, _), L), '$retract_clause_list'(L), !. \n'$retract_clause_list'([]). \n'$retract_clause_list'([E | T]) :- !, '$retract'(E), '$retract_clause_list'(T). \nmember(E,[E|_]). \n                                                                                     member(E,[_|L]):- member(E,L). \n                                                                       length(L, S) :- number(S), !, lengthN(L, S), !. \nlength(L, S) :- var(S), lengthX(L, S). \nlengthN([],0). \nlengthN(_, N) :- N < 0, !, fail. \nlengthN([_|L], N) :- lengthN(L,M), N is M + 1. \nlengthX([],0). \nlengthX([_|L], N) :- lengthX(L,M), N is M + 1. \nappend([],L2,L2). \n                                                                                    append([E|T1],L2,[E|T2]):- append(T1,L2,T2). \n                                                         reverse(L1,L2):- reverse0(L1,[],L2). \n                                                                 reverse0([],Acc,Acc). \n                                                                                reverse0([H|T],Acc,Y):- reverse0(T,[H|Acc],Y). \n                                                       delete(E,[],[]). \n                                                                                     delete(E,[E|T],L):- !,delete(E,T,L). \n                                                                 delete(E,[H|T],[H|L]):- delete(E,T,L). \n                                                               element(1,[E|L],E):- !. \n                                                                              element(N,[_|L],E):- M is N - 1,element(M,L,E). \n                                                      newlist(Ls,0,Ls):- !. \n                                                                                newlist(Ls,N,Ld):- M is N - 1,newlist([_|Ls],M,Ld). \n                                                  quicksort([],Pred,[]).                             \nquicksort([X|Tail],Pred,Sorted):-                  \n   split(X,Tail,Pred,Small,Big),                   \n   quicksort(Small,Pred,SortedSmall),              \n   quicksort(Big,Pred,SortedBig),                  \n   append(SortedSmall,[X|SortedBig],Sorted).       \nsplit(_,[],_,[],[]).                               \nsplit(X,[Y|Tail],Pred,Small,[Y|Big]):-             \n   Predicate =..[Pred,X,Y],                        \n   call(Predicate),!,                              \n   split(X,Tail,Pred,Small,Big).                   \nsplit(X,[Y|Tail],Pred,[Y|Small],Big):-             \n   split(X,Tail,Pred,Small,Big).                   \n";
    }

    public boolean $wt_unify_3(Term term, Term term2, Term term3) {
        Struct struct = (Struct)term2.getTerm();
        Struct struct2 = new Struct();
        Iterator iterator = struct.listIterator();
        while (iterator.hasNext()) {
            Struct struct3 = (Struct)iterator.next();
            Term term4 = struct3.getArg(0);
            Term term5 = struct3.getArg(1);
            if (!this.unify(term, term4)) continue;
            struct2.append(term5);
        }
        return this.unify(term3, struct2);
    }

    public boolean $s_next0_3(Term term, Term term2, Term term3) {
        Struct struct = (Struct)term2.getTerm();
        Struct struct2 = new Struct();
        Iterator iterator = struct.listIterator();
        while (iterator.hasNext()) {
            Struct struct3 = (Struct)iterator.next();
            Term term4 = struct3.getArg(0);
            if (this.unify(term, term4)) continue;
            struct2.append(struct3);
        }
        return this.unify(term3, struct2);
    }

    public boolean iterated_goal_term_2(Term term, Term term2) {
        Term term3 = term.getTerm();
        Term term4 = term3.iteratedGoalTerm();
        return this.unify(term4, term2);
    }

    public String[][] getSynonymMap() {
        return new String[][]{{"+", "expression_plus", "functor"}, {"-", "expression_minus", "functor"}, {"*", "expression_multiply", "functor"}, {"/", "expression_div", "functor"}, {"**", "expression_pow", "functor"}, {">>", "expression_bitwise_shift_right", "functor"}, {"<<", "expression_bitwise_shift_left", "functor"}, {"/\\", "expression_bitwise_and", "functor"}, {"\\/", "expression_bitwise_or", "functor"}, {"//", "expression_integer_div", "functor"}, {"\\", "expression_bitwise_not", "functor"}};
    }
}

