/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Double;
import alice.tuprolog.Int;
import alice.tuprolog.Library;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.util.Tools;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Random;

public class IOLibrary
extends Library {
    protected String inputStreamName = "stdin";
    protected InputStream inputStream = System.in;
    protected String outputStreamName = "stdout";
    protected OutputStream outputStream = System.out;
    private Random gen = new Random();

    public IOLibrary() {
        this.gen.setSeed(System.currentTimeMillis());
    }

    public boolean see_1(Term term) throws Exception {
        Struct struct = (Struct)term.getTerm();
        if (!struct.isAtom()) {
            return false;
        }
        if (this.inputStream != System.in) {
            this.inputStream.close();
        }
        this.inputStream = struct.getName().equals("stdin") ? System.in : new FileInputStream(struct.getName());
        this.inputStreamName = struct.getName();
        return true;
    }

    public boolean seen_0() throws Exception {
        if (this.inputStream != System.in) {
            this.inputStream.close();
            this.inputStream = System.in;
            this.inputStreamName = "stdin";
        }
        return true;
    }

    public boolean seeing_1(Term term) {
        return this.unify(term, new Struct(this.inputStreamName));
    }

    public boolean tell_1(Term term) throws Exception {
        Struct struct = (Struct)term.getTerm();
        if (!struct.isAtom()) {
            return false;
        }
        if (this.outputStream != System.out) {
            this.outputStream.close();
        }
        this.outputStream = struct.getName().equals("stdout") ? System.out : new FileOutputStream(struct.getName());
        this.outputStreamName = struct.getName();
        return true;
    }

    public boolean told_0() throws Exception {
        if (this.outputStream != System.out) {
            this.outputStream.close();
            this.outputStream = System.out;
            this.outputStreamName = "stdout";
        }
        return true;
    }

    public boolean telling_1(Term term) {
        return this.unify(term, new Struct(this.outputStreamName));
    }

    public boolean put_1(Term term) throws Exception {
        Struct struct = (Struct)term.getTerm();
        if (!struct.isAtom()) {
            return false;
        }
        String string = struct.getName();
        if (string.length() > 1) {
            return false;
        }
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput(string);
        } else {
            this.outputStream.write((byte)string.charAt(0));
        }
        return true;
    }

    public boolean get0_1(Term term) throws Exception {
        int n = this.inputStream.read();
        if (n == -1) {
            return this.unify(term, new Int(-1));
        }
        return this.unify(term, new Struct(new Character((char)n).toString()));
    }

    public boolean get_1(Term term) throws Exception {
        int n = 0;
        while ((n = this.inputStream.read()) < 32 && n >= 0) {
        }
        if (n == -1) {
            return this.unify(term, new Int(-1));
        }
        return this.unify(term, new Struct(new Character((char)n).toString()));
    }

    public boolean tab_1(Number number) throws Exception {
        int n = number.intValue();
        if (this.outputStreamName.equals("stdout")) {
            for (int i = 0; i < n; ++i) {
                this.getEngine().stdOutput("\t");
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.outputStream.write(32);
            }
        }
        return true;
    }

    public boolean read_1(Term term) throws Exception {
        term = term.getTerm();
        try {
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            String string = "";
            while ((n = this.inputStream.read()) != -1) {
                boolean bl3 = true;
                if (n == 39) {
                    bl = !bl;
                } else if (n == 34) {
                    bl2 = !bl2;
                } else if (n == 46 && !bl && !bl2) break;
                if (!bl3) continue;
                string = string + new Character((char)n).toString();
            }
            return this.unify(term, this.getEngine().toTerm(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean write_1(Term term) throws Exception {
        term = term.getTerm();
        try {
            if (this.outputStreamName.equals("stdout")) {
                this.getEngine().stdOutput(term.toString());
            } else {
                this.outputStream.write(term.toString().getBytes());
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean print_1(Term term) throws Exception {
        term = term.getTerm();
        try {
            if (this.outputStreamName.equals("stdout")) {
                this.getEngine().stdOutput(Tools.removeApices(term.toString()));
            } else {
                this.outputStream.write(Tools.removeApices(term.toString()).getBytes());
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean nl_0() throws Exception {
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput("\n");
        } else {
            this.outputStream.write(10);
        }
        return true;
    }

    public boolean text_from_file_2(Term term, Term term2) {
        Struct struct = (Struct)term.getTerm();
        try {
            Struct struct2 = new Struct(Tools.loadText(Tools.removeApices(struct.toString())));
            return this.unify(term2, struct2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean rand_float_1(Term term) {
        return this.unify(term, new Double(this.gen.nextFloat()));
    }

    public boolean rand_int_2(Term term, Term term2) {
        Number number = (Number)term.getTerm();
        return this.unify(term2, new Int(this.gen.nextInt(number.intValue())));
    }

    public String getTheory() {
        return "consult(File) :- text_from_file(File,Text), add_theory(Text).\nreconsult(File) :- text_from_file(File,Text), set_theory(Text).\nsolve_file(File,Goal) :- text_from_file(File,Text),text_term(Text,Goal),call(Goal).\nagent_file(X)  :- text_from_file(X,Y),agent(Y).\n";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InputStream inputStream = this.inputStream;
        OutputStream outputStream = this.outputStream;
        this.inputStream = null;
        this.outputStream = null;
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (IOException iOException) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
            throw new IOException();
        }
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.outputStreamName.equals("user")) {
            this.outputStream = System.out;
        }
        if (this.inputStreamName.equals("user")) {
            this.inputStream = System.in;
        }
    }
}

