/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Theory;
import alice.tuprolog.event.OutputEvent;
import alice.tuprolog.event.OutputListener;
import alice.tuprolog.event.QueryEvent;
import alice.tuprolog.event.QueryListener;
import alice.tuprologx.ide.EngineThread;
import alice.tuprologx.ide.IDE;
import alice.tuprologx.ide.InputField;
import alice.util.thinlet.Thinlet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ThinletConsole
extends Thinlet
implements OutputListener,
QueryListener {
    private Prolog engine;
    private IDE ide;
    private InputField inputField;
    private String statusMessage;
    private String lastSolution;
    private PropertyChangeSupport propertyChangeSupport;

    public ThinletConsole(IDE iDE) {
        try {
            this.add(this.parse("xml/ThinletConsole.xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ide = iDE;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.lastSolution = "";
    }

    public void solve() {
        if (!this.ide.isFeededTheory()) {
            try {
                this.engine.setTheory(new Theory(this.ide.getEditorContent()));
                this.ide.setFeededTheory(true);
            }
            catch (InvalidTheoryException invalidTheoryException) {
                this.showSolution("error reading theory.");
                this.setStatusMessage("Error setting theory: Syntax Error at/before line " + invalidTheoryException.line);
            }
        }
        this.enableStopButton(true);
        this.showSolution("");
        try {
            this.ide.enableTheoryCommands(false);
            this.setStatusMessage("Solving...");
            new EngineThread(this.engine, this.getGoal(), this).start();
        }
        catch (Exception exception) {
            this.setStatusMessage("Error: " + exception);
        }
    }

    public void setEngine(Prolog prolog) {
        this.engine = prolog;
    }

    public void setInputField(InputField inputField) {
        this.inputField = inputField;
        this.inputField.setConsole(this);
    }

    public void setStatusMessage(String string) {
        String string2 = this.getStatusMessage();
        this.statusMessage = string;
        this.propertyChangeSupport.firePropertyChange("StatusMessage", string2, this.statusMessage);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected String getGoal() {
        return this.inputField.getGoal();
    }

    protected void showSolution(String string) {
        Object object = this.find("solutionArea");
        this.setString(object, "text", string);
    }

    protected void enableSolutionCommands(boolean bl) {
        Object object = this.find("nextButton");
        this.setBoolean(object, "enabled", bl);
        Object object2 = this.find("acceptButton");
        this.setBoolean(object2, "enabled", bl);
    }

    protected void enableStopButton(boolean bl) {
        Object object = this.find("stopButton");
        this.setBoolean(object, "enabled", bl);
    }

    protected void enableSolveCommands(boolean bl) {
        this.inputField.enableSolveCommands(bl);
    }

    public void getNextSolution() {
        this.enableStopButton(true);
        this.enableSolutionCommands(false);
        this.showSolution("");
        this.setStatusMessage("Solving...");
        try {
            new EngineThread(this.engine).start();
        }
        catch (Exception exception) {
            this.setStatusMessage("Error: " + exception);
        }
    }

    public void acceptSolution() {
        this.enableStopButton(false);
        this.enableSolutionCommands(false);
        this.enableSolveCommands(true);
        this.ide.enableTheoryCommands(true);
        this.engine.solveEnd();
        this.setStatusMessage("Ready.");
        this.showSolution(this.lastSolution);
    }

    public void stopEngine() {
        this.engine.solveHalt();
        this.enableSolutionCommands(false);
        this.enableStopButton(false);
    }

    public void onOutput(OutputEvent outputEvent) {
        Object object = this.find("outputArea");
        String string = this.getString(object, "text");
        this.setString(object, "text", string + outputEvent.getMsg());
    }

    public void newQueryResultAvailable(QueryEvent queryEvent) {
        this.enableStopButton(false);
        this.enableSolutionCommands(true);
        SolveInfo solveInfo = queryEvent.getSolveInfo();
        if (solveInfo.isSuccess()) {
            String string = solveInfo.toString();
            if (!this.engine.hasOpenAlternatives()) {
                this.ide.enableTheoryCommands(true);
                this.enableSolutionCommands(false);
                this.setStatusMessage("Ready.");
            } else {
                this.enableSolutionCommands(true);
                this.setStatusMessage("Found a solution. Other alternatives can be explored.");
            }
            try {
                this.lastSolution = string + "\nSolution: " + solveInfo.getSolution();
                this.showSolution(this.lastSolution);
            }
            catch (Exception exception) {
                this.setStatusMessage("Internal error.");
            }
        } else {
            this.showSolution("no.");
            this.enableSolutionCommands(false);
            this.ide.enableTheoryCommands(true);
            this.setStatusMessage("Ready.");
        }
    }

    public void enableClearOutput() {
        Object object = this.find("areas");
        int n = this.getInteger(object, "selected");
        Object object2 = this.find("clearOutputButton");
        if (n == 1) {
            this.setBoolean(object2, "enabled", true);
        } else {
            this.setBoolean(object2, "enabled", false);
        }
    }

    public void clearOutput() {
        Object object = this.find("outputArea");
        this.setString(object, "text", "");
    }
}

