/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.runtime.tcp;

import alice.tuprologx.runtime.tcp.NetMsg;
import alice.tuprologx.runtime.tcp.PrologImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.Socket;

class Acceptor
implements Runnable {
    ObjectOutputStream outStream;
    ObjectInputStream inStream;
    Socket socket;
    PrologImpl core;
    boolean initOk = true;

    Acceptor(Socket socket, PrologImpl prologImpl) {
        this.core = prologImpl;
        this.socket = socket;
        try {
            this.outStream = new ObjectOutputStream(this.socket.getOutputStream());
            this.inStream = new ObjectInputStream(this.socket.getInputStream());
        }
        catch (Exception exception) {
            this.initOk = false;
        }
    }

    public void run() {
        if (!this.initOk) {
            return;
        }
        System.out.println("[ User " + Thread.currentThread() + " ] start.");
        try {
            while (true) {
                NetMsg netMsg = (NetMsg)this.inStream.readObject();
                Method method = this.core.getClass().getMethod(netMsg.methodName, this.inStream.getClass(), this.outStream.getClass());
                method.invoke((Object)this.core, this.inStream, this.outStream);
            }
        }
        catch (Exception exception) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("[ User " + Thread.currentThread() + "] shutdown.");
            return;
        }
    }
}

