/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Transform {
    private static final File PWD = new File(".");
    private final Source inputSource;
    private final Transformer transformer;

    public Transform(String input, String stylesheet) {
        this(new StreamSource(new StringReader(input)), (Source)new StreamSource(new StringReader(stylesheet)));
    }

    public Transform(String input, File stylesheet) {
        this(new StreamSource(new StringReader(input)), (Source)new StreamSource(stylesheet));
    }

    public Transform(InputSource input, InputSource stylesheet) {
        this(new SAXSource(input), (Source)new SAXSource(stylesheet));
    }

    public Transform(InputSource input, File stylesheet) {
        this(new SAXSource(input), (Source)new StreamSource(stylesheet));
    }

    public Transform(Node sourceNode) {
        this(sourceNode, (Source)null);
    }

    public Transform(Node sourceNode, String stylesheet) {
        this(sourceNode, (Source)new StreamSource(new StringReader(stylesheet)));
    }

    public Transform(Node sourceNode, File stylesheet) {
        this(sourceNode, (Source)new StreamSource(stylesheet));
    }

    private Transform(Node sourceNode, Source stylesheetSource) {
        this(new DOMSource(sourceNode), stylesheetSource);
    }

    public Transform(Source inputSource, Source stylesheetSource) {
        this.inputSource = inputSource;
        this.provideSystemIdIfRequired(inputSource);
        this.provideSystemIdIfRequired(stylesheetSource);
        this.transformer = this.getTransformer(stylesheetSource);
    }

    private void provideSystemIdIfRequired(Source source) {
        if (source != null && (source.getSystemId() == null || source.getSystemId().length() == 0)) {
            source.setSystemId(this.getDefaultSystemId());
        }
    }

    private String getDefaultSystemId() {
        try {
            return PWD.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to determine current working directory!");
        }
    }

    private Transformer getTransformer(Source stylesheetSource) throws ConfigurationException {
        try {
            Transformer t;
            TransformerFactory factory = XMLUnit.getTransformerFactory();
            Transformer transformer = t = stylesheetSource == null ? factory.newTransformer() : factory.newTransformer(stylesheetSource);
            if (XMLUnit.getURIResolver() != null) {
                t.setURIResolver(XMLUnit.getURIResolver());
            }
            return t;
        }
        catch (TransformerConfigurationException ex) {
            throw new ConfigurationException(ex);
        }
    }

    protected void transformTo(Result result) throws TransformerException {
        this.transformer.transform(this.inputSource, result);
    }

    public String getResultString() throws TransformerException {
        StringWriter outputWriter = new StringWriter();
        this.transformTo(new StreamResult(outputWriter));
        return outputWriter.toString();
    }

    public Document getResultDocument() throws TransformerException {
        DOMResult result = new DOMResult();
        this.transformTo(result);
        return (Document)result.getNode();
    }

    public void setOutputProperty(String name, String value) {
        Properties properties = new Properties();
        properties.setProperty(name, value);
        this.setOutputProperties(properties);
    }

    public void setOutputProperties(Properties outputProperties) {
        this.transformer.setOutputProperties(outputProperties);
    }

    public void setParameter(String name, Object value) {
        this.transformer.setParameter(name, value);
    }

    public Object getParameter(String name) {
        return this.transformer.getParameter(name);
    }

    public void clearParameters() {
        this.transformer.clearParameters();
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.transformer.setURIResolver(uriResolver);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.transformer.setErrorListener(errorListener);
    }
}

