/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Applet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import ubc.cs.JLog.Applet.gOutputStreamTextArea;
import ubc.cs.JLog.Applet.gPrologServiceTextArea;
import ubc.cs.JLog.Foundation.iPrologServiceText;
import ubc.cs.JLog.Foundation.jConsultSourceThread;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jResetDatabaseThread;

public class gConsultPanel
extends Panel {
    protected static final String RESET = "Reset KB";
    protected static final String CONSULT = "Consult";
    protected static final String FIND = "Find";
    protected static final String GOTOLINE = "Goto";
    protected static final String ERRLABEL = "Status";
    protected static final String SRCLABEL = "Source";
    protected static final int ERRROWS = 3;
    protected TextArea source;
    protected TextArea errors;
    protected TextField find_field;
    protected TextField gotoline_field;
    protected Button resetdb;
    protected Button consult;
    protected Button find;
    protected Button gotoline;
    protected Label srclabel;
    protected Label errlabel;
    protected jPrologServices prolog;
    protected String find_str = null;
    protected int find_pos = 0;

    public gConsultPanel(jPrologServices jPrologServices2, String string, boolean bl) {
        this.prolog = jPrologServices2;
        this.prolog.addBeginQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultPanel.this.disable_buttons();
            }
        });
        this.prolog.addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultPanel.this.reset_buttons();
            }
        });
        this.prolog.addEndConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultPanel.this.reset_buttons();
            }
        });
        this.prolog.addThreadStoppedListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultPanel.this.reset_buttons();
            }
        });
        this.source = new TextArea("", 0, 0, 1);
        this.source.setBackground(Color.white);
        this.source.setForeground(Color.black);
        this.source.setFont(new Font("Monospaced", 0, 12));
        this.source.setText(string);
        this.srclabel = new Label(SRCLABEL, 0);
        this.errors = new TextArea("", 3, 1, 1);
        this.errors.setBackground(Color.white);
        this.errors.setForeground(Color.black);
        this.errors.setEditable(false);
        this.errors.setFont(new Font("Monospaced", 0, 12));
        this.errlabel = new Label(ERRLABEL, 0);
        this.resetdb = new Button(RESET);
        this.resetdb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gConsultPanel.this.resetdb();
            }
        });
        this.resetdb.setBackground(Color.white);
        this.resetdb.setForeground(Color.black);
        this.consult = new Button(CONSULT);
        this.consult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gConsultPanel.this.consult();
            }
        });
        this.consult.setBackground(Color.white);
        this.consult.setForeground(Color.black);
        this.find = new Button(FIND);
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gConsultPanel.this.find();
            }
        });
        this.find.setBackground(Color.white);
        this.find.setForeground(Color.black);
        this.find_field = new TextField("");
        this.find_field.setFont(new Font("SansSerif", 0, 12));
        this.find_field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    gConsultPanel.this.find();
                }
            }
        });
        this.gotoline = new Button(GOTOLINE);
        this.gotoline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gConsultPanel.this.goLine();
            }
        });
        this.gotoline.setBackground(Color.white);
        this.gotoline.setForeground(Color.black);
        this.gotoline_field = new TextField("");
        this.gotoline_field.setFont(new Font("Monospaced", 0, 12));
        this.gotoline_field.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                gConsultPanel.this.gotoline_field.setText(Integer.toString(gConsultPanel.this.getCurrentSourceLine()));
                gConsultPanel.this.gotoline_field.selectAll();
            }
        });
        this.gotoline_field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    gConsultPanel.this.goLine();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.add((Component)new Panel(), "North");
        this.add((Component)new Panel(), "West");
        this.add((Component)new Panel(), "East");
        this.add((Component)new Panel(), "South");
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new GridLayout(0, 1));
        Panel panel4 = new Panel(new GridLayout(0, 1));
        Panel panel5 = new Panel(new BorderLayout());
        Panel panel6 = new Panel(new BorderLayout());
        Panel panel7 = new Panel(new BorderLayout());
        Panel panel8 = new Panel(new BorderLayout());
        Panel panel9 = new Panel(new BorderLayout());
        Panel panel10 = new Panel(new BorderLayout());
        Panel panel11 = new Panel(new BorderLayout());
        Panel panel12 = new Panel(new BorderLayout());
        panel3.add(this.resetdb);
        panel4.add(this.consult);
        panel11.add((Component)new Panel(), "North");
        panel11.add((Component)this.find_field, "Center");
        panel11.add((Component)this.find, "South");
        panel12.add((Component)new Panel(), "North");
        panel12.add((Component)this.gotoline_field, "Center");
        panel12.add((Component)this.gotoline, "South");
        panel5.add((Component)new Panel(), "Center");
        panel5.add((Component)panel11, "South");
        panel6.add((Component)panel5, "Center");
        panel6.add((Component)panel12, "South");
        panel7.add((Component)panel6, "Center");
        panel7.add((Component)new Panel(), "North");
        panel7.add((Component)new Panel(), "South");
        panel8.add((Component)panel3, "North");
        panel8.add((Component)panel7, "Center");
        panel8.add((Component)panel4, "South");
        panel9.add((Component)panel8, "Center");
        panel9.add((Component)new Panel(), "West");
        panel.add((Component)this.source, "Center");
        if (bl) {
            panel.add((Component)panel9, "East");
        }
        panel.add((Component)this.srclabel, "North");
        panel2.add((Component)this.errors, "Center");
        panel2.add((Component)this.errlabel, "North");
        panel2.add((Component)new Panel(), "South");
        panel10.add((Component)panel, "Center");
        panel10.add((Component)panel2, "South");
        this.add((Component)panel10, "Center");
    }

    public iPrologServiceText getSource() {
        return new gPrologServiceTextArea(this.source);
    }

    public TextArea getSourceTextArea() {
        return this.source;
    }

    public int getCurrentSourceLine() {
        String string = this.source.getText();
        int n = this.source.getCaretPosition();
        int n2 = 0;
        int n3 = 1;
        do {
            if ((n2 = string.indexOf("\n", n2)) >= n || n2 < 0) {
                return n3;
            }
            if (n2 >= 0) {
                ++n2;
            }
            ++n3;
        } while (n2 >= 0);
        return 0;
    }

    public void setCurrentSourceLine(int n) {
        String string = this.source.getText();
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        do {
            n3 = string.indexOf("\n", n2);
            if (n4 == n) {
                this.source.select(n2, n3 >= 0 ? n3 : string.length());
                return;
            }
            n2 = n3 + 1;
        } while (n3 >= 0 && ++n4 <= n);
        this.source.setCaretPosition(string.length());
    }

    public String getFindString() {
        return this.find_str;
    }

    public boolean findSource(String string) {
        this.find_str = string;
        this.find_pos = this.source.getSelectionStart() != this.source.getSelectionEnd() ? this.source.getSelectionEnd() : this.source.getCaretPosition();
        return this.findNextSource();
    }

    public boolean findNextSource() {
        String string = this.source.getText();
        if (this.source.getSelectionEnd() != this.find_pos) {
            this.find_pos = this.source.getCaretPosition();
        }
        if (this.find_str != null) {
            if (this.find_pos >= 0) {
                this.find_pos = string.indexOf(this.find_str, this.find_pos);
            }
            if (this.find_pos < 0) {
                this.find_pos = 0;
                this.find_pos = string.indexOf(this.find_str, this.find_pos);
            }
            if (this.find_pos >= 0) {
                int n = this.find_pos;
                this.find_pos += this.find_str.length();
                this.source.select(n, this.find_pos);
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
        }
        return false;
    }

    public PrintWriter getErrorsStream() {
        return new PrintWriter(new gOutputStreamTextArea(this.errors));
    }

    public void resetdb() {
        this.errors.setText("");
        this.consult.setEnabled(false);
        this.resetdb.setEnabled(false);
        if (!this.prolog.start(new jResetDatabaseThread(this.prolog, this.getErrorsStream()))) {
            this.errors.append("reset failed. other events pending.\n");
        }
    }

    public void pre_consult() {
        this.errors.setText("");
        this.source.setEditable(false);
        this.consult.setEnabled(false);
        this.resetdb.setEnabled(false);
    }

    public void consult() {
        this.pre_consult();
        if (!this.prolog.start(new jConsultSourceThread(this.prolog, this.getSource(), this.getErrorsStream()))) {
            this.errors.append("consult failed. other events pending.\n");
        }
    }

    public void find() {
        this.findSource(this.find_field.getText());
    }

    public void goLine() {
        try {
            this.setCurrentSourceLine(Integer.parseInt(this.gotoline_field.getText()));
            this.gotoline_field.setText(Integer.toString(this.getCurrentSourceLine()));
            this.gotoline_field.selectAll();
        }
        catch (NumberFormatException numberFormatException) {
            this.gotoline_field.setText(Integer.toString(this.getCurrentSourceLine()));
            this.gotoline_field.selectAll();
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void reset_buttons() {
        this.consult.setEnabled(true);
        this.resetdb.setEnabled(true);
        this.source.setEditable(true);
    }

    protected void disable_buttons() {
        this.consult.setEnabled(false);
        this.resetdb.setEnabled(false);
    }
}

