/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Applet;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import ubc.cs.JLog.Applet.gClosingDialog;
import ubc.cs.JLog.Applet.gConsultPanel;
import ubc.cs.JLog.Applet.gFindDialog;
import ubc.cs.JLog.Applet.gGotoLineDialog;
import ubc.cs.JLog.Applet.gJLogApplicationBase;
import ubc.cs.JLog.Applet.gWindowBase;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;

public class gConsultWindow
extends gWindowBase {
    protected gConsultPanel consult;
    protected String file_path = null;
    protected boolean src_changed = false;
    protected int events_pending = 1;

    gConsultWindow(gJLogApplicationBase gJLogApplicationBase2, String string) {
        super(gJLogApplicationBase2);
        Object object = this.parent.getPrologServices();
        ((jPrologServices)object).addBeginQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultWindow.this.updateToolMenuConsult(false);
            }
        });
        ((jPrologServices)object).addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultWindow.this.updateToolMenuConsult(true);
            }
        });
        ((jPrologServices)object).addBeginConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultWindow.this.updateToolMenuConsult(false);
            }
        });
        ((jPrologServices)object).addEndConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultWindow.this.updateToolMenuConsult(true);
            }
        });
        ((jPrologServices)object).addThreadStoppedListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gConsultWindow.this.updateToolMenuConsult(true);
            }
        });
        this.setLayout(new GridLayout());
        this.consult = new gConsultPanel(this.parent.getPrologServices(), string, false);
        this.add(this.consult);
        this.pack();
        this.setSize(600, 480);
        object = this.getLocation();
        int n = this.parent.getKBWindowCount();
        int n2 = 24;
        ((Point)object).move(30 + n2 * n, 30 + n2 * n);
        this.setLocation((Point)object);
        this.setTitle("JLog - Untitled");
        this.parent.addKBWindow(this);
        this.consult.getSourceTextArea().addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                if (gConsultWindow.this.events_pending > 0) {
                    --gConsultWindow.this.events_pending;
                } else {
                    gConsultWindow.this.src_changed = true;
                }
            }
        });
        this.setVisible(true);
    }

    public boolean close() {
        if (this.canClose()) {
            this.parent.removeKBWindow(this);
            this.dispose();
            return true;
        }
        return false;
    }

    public boolean canClose() {
        if (this.src_changed) {
            switch (this.shouldSave()) {
                case 1: {
                    return false;
                }
                case 2: {
                    return this.save(this.file_path);
                }
                case 3: {
                    return this.save(null);
                }
                case 4: {
                    return true;
                }
            }
            return true;
        }
        return true;
    }

    protected int shouldSave() {
        gClosingDialog gClosingDialog2 = new gClosingDialog(this);
        return gClosingDialog2.getChoiceValue();
    }

    public boolean save(String string) {
        Object object;
        File file = null;
        if (string == null) {
            object = new FileDialog((Frame)this, "Save As", 1);
            if (this.parent.getCurrentDirectory() == null) {
                ((FileDialog)object).setDirectory(System.getProperty("user.dir"));
            } else {
                ((FileDialog)object).setDirectory(this.parent.getCurrentDirectory());
            }
            this.setVisible(true);
            ((Dialog)object).setVisible(true);
            if (((FileDialog)object).getFile() == null) {
                return false;
            }
            this.parent.setCurrentDirectory(((FileDialog)object).getDirectory());
            file = new File(((FileDialog)object).getDirectory(), ((FileDialog)object).getFile());
        } else {
            file = new File(string);
        }
        this.file_path = file.getAbsolutePath();
        this.setTitle("JLog - saving: " + this.file_path);
        try {
            object = new BufferedWriter(new FileWriter(file));
            String string2 = this.consult.getSource().getText();
            ((Writer)object).write(string2);
            ((BufferedWriter)object).close();
            this.setTitle("JLog - " + this.file_path);
            this.src_changed = false;
        }
        catch (Exception exception) {
            this.displayErrorDialog("Could not save " + this.file_path);
            this.setTitle("JLog - Untitled");
            this.file_path = null;
            this.src_changed = true;
            this.parent.updateWindowMenu();
            return false;
        }
        this.parent.updateWindowMenu();
        return true;
    }

    public boolean open(File file) {
        String string = System.getProperty("line.separator", "\n");
        this.file_path = file.getAbsolutePath();
        this.setTitle("JLog - opening: " + this.file_path);
        try {
            StringBuffer stringBuffer = new StringBuffer((int)file.length());
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                stringBuffer.append(string2 + string);
            }
            bufferedReader.close();
            ++this.events_pending;
            this.src_changed = false;
            this.consult.getSource().setText(stringBuffer.toString());
            this.setTitle("JLog - " + this.file_path);
        }
        catch (Exception exception) {
            this.displayErrorDialog("Could not load " + this.file_path);
            this.setTitle("JLog - Untitled");
            this.file_path = null;
            this.parent.updateWindowMenu();
            return false;
        }
        this.parent.updateWindowMenu();
        return true;
    }

    public String getFilePath() {
        return this.file_path;
    }

    public boolean useMenuItem(MenuItem menuItem) {
        if (menuItem.getActionCommand() == "close") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gConsultWindow.this.close();
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "save") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gConsultWindow.this.save(gConsultWindow.this.file_path);
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "saveas") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gConsultWindow.this.save(null);
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "cut") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    TextArea textArea = gConsultWindow.this.consult.getSourceTextArea();
                    int n = textArea.getSelectionStart();
                    int n2 = textArea.getSelectionEnd();
                    StringSelection stringSelection = new StringSelection(textArea.getSelectedText());
                    gConsultWindow.this.consult.getSource().remove(n, n2);
                    clipboard.setContents(stringSelection, stringSelection);
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "copy") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    TextArea textArea = gConsultWindow.this.consult.getSourceTextArea();
                    StringSelection stringSelection = new StringSelection(textArea.getSelectedText());
                    clipboard.setContents(stringSelection, stringSelection);
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "paste") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(this);
                    if (transferable != null) {
                        try {
                            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            TextArea textArea = gConsultWindow.this.consult.getSourceTextArea();
                            int n = textArea.getCaretPosition();
                            gConsultWindow.this.consult.getSource().insert(string, n);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "selectall") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gConsultWindow.this.consult.getSource().selectAll();
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "find") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gFindDialog gFindDialog2 = new gFindDialog(gConsultWindow.this, gConsultWindow.this.consult.getFindString());
                    String string = gFindDialog2.getFindString();
                    if (string != null) {
                        gConsultWindow.this.consult.findSource(string);
                    }
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "findnext") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gConsultWindow.this.consult.findNextSource();
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "gotoline") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gGotoLineDialog gGotoLineDialog2 = new gGotoLineDialog(gConsultWindow.this, gConsultWindow.this.consult.getCurrentSourceLine());
                    if (gGotoLineDialog2.wasAccepted()) {
                        gConsultWindow.this.consult.setCurrentSourceLine(gGotoLineDialog2.getGotoLine());
                    }
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "consultkb") {
            menuItem.setEnabled(this.parent.getPrologServices().isAvailable());
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gConsultWindow.this.consult();
                }
            });
            return true;
        }
        if (menuItem.getActionCommand() == "resetkb") {
            menuItem.setEnabled(this.parent.getPrologServices().isAvailable());
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gConsultWindow.this.resetdb();
                }
            });
            return true;
        }
        return false;
    }

    public void consult() {
        this.consult.consult();
    }

    public void resetdb() {
        this.consult.resetdb();
    }

    protected void updateToolMenuConsult(boolean bl) {
        Menu menu = this.getMenuBar().getMenu(this.parent.getToolMenuID());
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = menu.getItem(i);
            if (menuItem.getActionCommand() == "consultkb") {
                menuItem.setEnabled(bl);
                continue;
            }
            if (menuItem.getActionCommand() != "resetkb") continue;
            menuItem.setEnabled(bl);
        }
    }
}

