/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Applet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import ubc.cs.JLog.Applet.gButtonTab;
import ubc.cs.JLog.Applet.gButtonTabMenu;
import ubc.cs.JLog.Applet.gCardPanel;
import ubc.cs.JLog.Applet.gProverStackPanel;
import ubc.cs.JLog.Applet.gStackPanel;
import ubc.cs.JLog.Applet.gTracePanel;
import ubc.cs.JLog.Foundation.jDebugFailGoalEvent;
import ubc.cs.JLog.Foundation.jDebugProveGoalEvent;
import ubc.cs.JLog.Foundation.jDebugProvedGoalStack;
import ubc.cs.JLog.Foundation.jDebugProvedGoalsEvent;
import ubc.cs.JLog.Foundation.jDebugProver;
import ubc.cs.JLog.Foundation.jDebugProverStartedEvent;
import ubc.cs.JLog.Foundation.jDebugRetryGoalEvent;
import ubc.cs.JLog.Foundation.jDebugTryGoalEvent;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jUserQueryEvent;

public class gDebugPanel
extends Panel {
    protected static final String TRACE_TAB = "trace";
    protected static final String PROVED_TAB = "proved";
    protected static final String GOALS_TAB = "goals";
    protected static final String DEBUG = "Debugger On";
    protected static final String A_UNKNOWNPRED = "Abort on Unknown Predicate";
    protected static final String BREAKALL = "Break on Fail";
    protected static final String TRACEALL = "Trace All";
    protected static final String RUN = "Run";
    protected static final String STEPIN = "Step In";
    protected static final String STEPOVER = "Step Over";
    protected static final String BREAK = "Break";
    protected static final String CLEAR = "Clear";
    protected gCardPanel lists;
    protected gButtonTabMenu menu;
    protected TextArea info;
    protected Checkbox debug;
    protected Checkbox unkpred;
    protected Checkbox breakall;
    protected Checkbox traceall;
    protected Button runpro;
    protected Button stepin;
    protected Button stepover;
    protected Button stop;
    protected Button clear;
    protected gButtonTab trace;
    protected gButtonTab proved;
    protected gButtonTab goals;
    protected gStackPanel proved_stack;
    protected gStackPanel goals_stack;
    protected gTracePanel trace_list;
    protected jPrologServices prolog;
    protected jDebugProver prover = null;
    protected int run_state;
    protected jGoal prover_currentnextgoal;
    protected jGoal prover_stopgoal;
    protected static final int STATE_STOP = 0;
    protected static final int STATE_RUN = 1;
    protected static final int STATE_STEPIN = 2;
    protected static final int STATE_STEPOVER = 3;

    public gDebugPanel(jPrologServices jPrologServices2, boolean bl) {
        this.prolog = jPrologServices2;
        this.prolog.addBeginQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gDebugPanel.this.debug.setEnabled(false);
            }
        });
        this.prolog.addRetryQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                if (jPrologServiceEvent2 instanceof jUserQueryEvent) {
                    jUserQueryEvent jUserQueryEvent2 = (jUserQueryEvent)jPrologServiceEvent2;
                    gDebugPanel.this.setRunState(0);
                    if (gDebugPanel.this.prolog.getDebugging() && jUserQueryEvent2.getResult()) {
                        gDebugPanel.this.info.append("\nQuery Succeeded\n");
                    }
                }
            }
        });
        this.prolog.addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gDebugPanel.this.queryTerminated();
                if (gDebugPanel.this.prolog.getDebugging()) {
                    gDebugPanel.this.info.append("\nQuery Failed\n");
                }
            }
        });
        this.prolog.addEndConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                if (gDebugPanel.this.prolog.getDebugging()) {
                    gDebugPanel.this.trace_list.updatePredicates();
                }
            }
        });
        this.prolog.addThreadStoppedListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gDebugPanel.this.queryTerminated();
            }
        });
        this.prolog.addDebugMessagesListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                if (jPrologServiceEvent2 instanceof jDebugProverStartedEvent) {
                    gDebugPanel.this.debugProverStarted((jDebugProverStartedEvent)jPrologServiceEvent2);
                } else if (jPrologServiceEvent2 instanceof jDebugTryGoalEvent) {
                    gDebugPanel.this.debugTryGoal((jDebugTryGoalEvent)jPrologServiceEvent2);
                } else if (jPrologServiceEvent2 instanceof jDebugProveGoalEvent) {
                    gDebugPanel.this.debugProveGoal((jDebugProveGoalEvent)jPrologServiceEvent2);
                } else if (jPrologServiceEvent2 instanceof jDebugProvedGoalsEvent) {
                    gDebugPanel.this.debugProvedGoals((jDebugProvedGoalsEvent)jPrologServiceEvent2);
                } else if (jPrologServiceEvent2 instanceof jDebugRetryGoalEvent) {
                    gDebugPanel.this.debugRetryGoal((jDebugRetryGoalEvent)jPrologServiceEvent2);
                } else if (jPrologServiceEvent2 instanceof jDebugFailGoalEvent) {
                    gDebugPanel.this.debugFailGoal((jDebugFailGoalEvent)jPrologServiceEvent2);
                }
            }
        });
        this.prolog.addStateChangedListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gDebugPanel.this.syncCheckboxes();
            }
        });
        this.info = new TextArea("", 0, 0, 0);
        this.info.setBackground(Color.white);
        this.info.setForeground(Color.black);
        this.info.setEditable(false);
        this.info.setFont(new Font("Monospaced", 0, 10));
        this.trace_list = new gTracePanel(this.prolog);
        this.goals_stack = new gStackPanel("Goals", this.info, this.prolog, false);
        this.proved_stack = new gProverStackPanel("Proved", this.info, this.prolog, this.goals_stack);
        this.lists = new gCardPanel();
        this.lists.add((Component)this.trace_list, TRACE_TAB);
        this.lists.add((Component)this.proved_stack, PROVED_TAB);
        this.lists.add((Component)this.goals_stack, GOALS_TAB);
        this.menu = new gButtonTabMenu(0, new Font("SansSerif", 0, 12));
        this.trace = new gButtonTab("Trace", this.menu, this.lists, TRACE_TAB);
        this.menu.add(this.trace);
        this.proved = new gButtonTab("Proved", this.menu, this.lists, PROVED_TAB);
        this.menu.add(this.proved);
        this.goals = new gButtonTab("Goal", this.menu, this.lists, GOALS_TAB);
        this.menu.add(this.goals);
        this.proved.setEnabled(false);
        this.goals.setEnabled(false);
        this.runpro = new Button(RUN);
        this.runpro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gDebugPanel.this.runprogram();
            }
        });
        this.runpro.setBackground(Color.white);
        this.runpro.setForeground(Color.black);
        this.runpro.setEnabled(false);
        this.stepin = new Button(STEPIN);
        this.stepin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gDebugPanel.this.stepin();
            }
        });
        this.stepin.setBackground(Color.white);
        this.stepin.setForeground(Color.black);
        this.stepin.setEnabled(false);
        this.stepover = new Button(STEPOVER);
        this.stepover.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gDebugPanel.this.stepover();
            }
        });
        this.stepover.setBackground(Color.white);
        this.stepover.setForeground(Color.black);
        this.stepover.setEnabled(false);
        this.stop = new Button(BREAK);
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gDebugPanel.this.stop();
            }
        });
        this.stop.setBackground(Color.white);
        this.stop.setForeground(Color.black);
        this.stop.setEnabled(false);
        this.clear = new Button(CLEAR);
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gDebugPanel.this.clear();
            }
        });
        this.clear.setBackground(Color.white);
        this.clear.setForeground(Color.black);
        this.debug = new Checkbox(DEBUG);
        this.debug.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                gDebugPanel.this.debug(itemEvent.getStateChange() == 1);
            }
        });
        this.unkpred = new Checkbox(A_UNKNOWNPRED);
        this.unkpred.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                gDebugPanel.this.prolog.setFailUnknownPredicate(!bl);
            }
        });
        this.breakall = new Checkbox(BREAKALL);
        this.breakall.setEnabled(false);
        this.traceall = new Checkbox(TRACEALL);
        this.traceall.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.add((Component)new Panel(), "North");
        this.add((Component)new Panel(), "West");
        this.add((Component)new Panel(), "East");
        this.add((Component)new Panel(), "South");
        Panel panel = new Panel(new FlowLayout(0));
        Panel panel2 = new Panel(new GridLayout(1, 0));
        Panel panel3 = new Panel(new BorderLayout());
        Panel panel4 = new Panel(new BorderLayout());
        Panel panel5 = new Panel(new BorderLayout());
        Panel panel6 = new Panel(new BorderLayout());
        Panel panel7 = new Panel(new BorderLayout());
        Panel panel8 = new Panel(new BorderLayout());
        panel.add(this.debug);
        panel.add(this.unkpred);
        panel.add(this.traceall);
        panel.add(this.breakall);
        panel2.add(this.runpro);
        panel2.add(this.stepin);
        panel2.add(this.stepover);
        panel2.add(this.stop);
        panel3.add((Component)panel2, "Center");
        panel3.add((Component)new Panel(), "South");
        panel4.add((Component)this.clear, "East");
        panel4.add((Component)new Panel(), "North");
        panel6.add((Component)this.info, "Center");
        panel6.add((Component)panel3, "North");
        panel6.add((Component)panel4, "South");
        panel7.add((Component)this.menu, "North");
        panel7.add((Component)this.lists, "Center");
        panel5.add((Component)panel7, "Center");
        panel5.add((Component)new Panel(), "East");
        if (bl) {
            panel8.add((Component)panel, "North");
        }
        panel8.add((Component)panel6, "Center");
        panel8.add((Component)panel5, "West");
        panel8.add((Component)new Panel(), "South");
        this.add((Component)panel8, "Center");
        this.menu.setActiveTab(this.trace);
        this.debug.setState(this.prolog.getDebugging());
        this.debug(this.prolog.getDebugging());
        this.unkpred.setState(!this.prolog.getFailUnknownPredicate());
    }

    public void syncCheckboxes() {
        if (this.debug.getState() != this.prolog.getDebugging()) {
            this.debug.setState(this.prolog.getDebugging());
            this.debug(this.prolog.getDebugging());
        }
        if (this.unkpred.getState() == this.prolog.getFailUnknownPredicate()) {
            this.unkpred.setState(!this.prolog.getFailUnknownPredicate());
        }
    }

    public void runprogram() {
        if (this.prover != null) {
            this.setRunState(1);
        }
    }

    public void stepin() {
        if (this.prover != null) {
            this.setRunState(2);
        }
    }

    public void stepover() {
        if (this.prover != null) {
            this.prover_stopgoal = this.prover_currentnextgoal;
            this.setRunState(3);
        }
    }

    public void stop() {
        if (this.prover != null) {
            this.setRunState(0);
        }
    }

    public void clear() {
        this.info.setText("");
    }

    public void setBreakState(boolean bl) {
        this.breakall.setState(bl);
    }

    public void setTraceState(boolean bl) {
        this.traceall.setState(bl);
    }

    public boolean getBreakState() {
        return this.breakall.getState();
    }

    public boolean getTraceState() {
        return this.traceall.getState();
    }

    public void setRunState(int n) {
        this.run_state = n;
        boolean bl = this.run_state != 0;
        this.proved_stack.enablePanel(!bl);
        this.goals_stack.enablePanel(!bl);
        if (!bl) {
            this.proved_stack.update();
            this.goals_stack.update();
        }
        this.runpro.setEnabled(!bl);
        this.stepin.setEnabled(!bl);
        this.stepover.setEnabled(!bl);
        this.stop.setEnabled(bl);
        if (bl) {
            this.prover.step();
        }
    }

    public void queryTerminated() {
        this.debug.setEnabled(true);
        this.setRunState(0);
        this.runpro.setEnabled(false);
        this.stepin.setEnabled(false);
        this.stepover.setEnabled(false);
        this.stop.setEnabled(false);
        this.prover = null;
    }

    public void debug(boolean bl) {
        this.prolog.setDebugging(bl);
        this.traceall.setEnabled(bl);
        this.breakall.setEnabled(bl);
        if (!bl) {
            this.menu.setActiveTab(this.trace);
            this.trace_list.disableDebugging();
            this.prover = null;
        } else {
            this.trace_list.enableDebugging();
        }
        this.proved.setEnabled(bl);
        this.goals.setEnabled(bl);
    }

    public void debugProverStarted(jDebugProverStartedEvent jDebugProverStartedEvent2) {
        this.prover = jDebugProverStartedEvent2.getDebugProver();
        this.setRunState(0);
        this.prover_stopgoal = null;
        this.prover_currentnextgoal = null;
    }

    public void debugTryGoal(jDebugTryGoalEvent jDebugTryGoalEvent2) {
        gTracePanel.gTraceItem gTraceItem2 = this.trace_list.getTraceInfo(jDebugTryGoalEvent2.getGoal());
        this.prover_currentnextgoal = jDebugTryGoalEvent2.getNextGoal();
        if (this.run_state == 3 && this.prover_stopgoal == jDebugTryGoalEvent2.getGoal() || this.run_state == 2 || gTraceItem2 != null && gTraceItem2.getBreak()) {
            this.setRunState(0);
        }
        if (this.traceGoal(gTraceItem2)) {
            this.info.append("trying: " + jDebugTryGoalEvent2.getGoal().toString());
            this.info.append("\n");
        }
        switch (this.run_state) {
            case 1: 
            case 3: {
                this.prover.step();
            }
        }
    }

    public void debugProveGoal(jDebugProveGoalEvent jDebugProveGoalEvent2) {
        if (this.traceGoal(jDebugProveGoalEvent2.getGoal())) {
            this.info.append("proving: " + jDebugProveGoalEvent2.getGoal().toString());
            this.info.append("\n");
            if (jDebugProveGoalEvent2.getSubGoals().size() > 0) {
                Enumeration enumeration = jDebugProveGoalEvent2.getSubGoals().elements();
                this.info.append("sub goals:\n");
                while (enumeration.hasMoreElements()) {
                    this.info.append(enumeration.nextElement().toString());
                    this.info.append("\n");
                }
            }
            this.info.append("\n");
        }
    }

    public void debugProvedGoals(jDebugProvedGoalsEvent jDebugProvedGoalsEvent2) {
        Vector vector = this.traceableDebugItems(jDebugProvedGoalsEvent2.getProvedGoals());
        if (vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            this.info.append("proved:\n");
            while (enumeration.hasMoreElements()) {
                jDebugProvedGoalStack.jDebugGoalItem jDebugGoalItem2 = (jDebugProvedGoalStack.jDebugGoalItem)enumeration.nextElement();
                this.info.append(jDebugGoalItem2.getGoal().toString());
                this.info.append("\n");
            }
            this.info.append("\n");
        }
    }

    public void debugRetryGoal(jDebugRetryGoalEvent jDebugRetryGoalEvent2) {
        if (this.traceGoal(jDebugRetryGoalEvent2.getGoal())) {
            this.info.append("retry: " + jDebugRetryGoalEvent2.getGoal().toString());
            this.info.append("\n");
        }
    }

    public void debugFailGoal(jDebugFailGoalEvent jDebugFailGoalEvent2) {
        if (this.traceGoal(jDebugFailGoalEvent2.getGoal())) {
            if (this.breakall.getState()) {
                this.setRunState(0);
            }
            this.info.append("failed: " + jDebugFailGoalEvent2.getGoal().toString());
            this.info.append("\n\n");
        }
    }

    protected boolean traceGoal(gTracePanel.gTraceItem gTraceItem2) {
        if (this.traceall.getState() || this.run_state == 0 || this.run_state == 2) {
            return true;
        }
        if (gTraceItem2 != null) {
            return gTraceItem2.getTrace();
        }
        return false;
    }

    protected boolean traceGoal(jGoal jGoal2) {
        gTracePanel.gTraceItem gTraceItem2 = this.trace_list.getTraceInfo(jGoal2);
        return this.traceGoal(gTraceItem2);
    }

    protected Vector traceableDebugItems(Vector vector) {
        Vector<jDebugProvedGoalStack.jDebugGoalItem> vector2 = new Vector<jDebugProvedGoalStack.jDebugGoalItem>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            jDebugProvedGoalStack.jDebugGoalItem jDebugGoalItem2 = (jDebugProvedGoalStack.jDebugGoalItem)enumeration.nextElement();
            if (!this.traceGoal(jDebugGoalItem2.getGoal())) continue;
            vector2.addElement(jDebugGoalItem2);
        }
        return vector2;
    }
}

