/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Applet;

import java.awt.CheckboxMenuItem;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import ubc.cs.JLog.Applet.gAboutDialog;
import ubc.cs.JLog.Applet.gAnimationWindow;
import ubc.cs.JLog.Applet.gConsultWindow;
import ubc.cs.JLog.Applet.gDebugWindow;
import ubc.cs.JLog.Applet.gHelpWindow;
import ubc.cs.JLog.Applet.gJLogApplicationBase;
import ubc.cs.JLog.Applet.gQueryPanel;
import ubc.cs.JLog.Applet.gWindowBase;
import ubc.cs.JLog.Applet.iMenuServiceRequester;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jResetDatabaseThread;

public class gJLogApplication
extends gJLogApplicationBase {
    protected static gAboutDialog about_box = null;
    protected static Frame query_window = null;
    protected static gDebugWindow debug_window = null;
    protected static gWindowBase animation_window = null;
    protected static gWindowBase help_window = null;
    protected static gQueryPanel query;
    protected static boolean useBuiltinApplicationMenu;
    protected static boolean query_state;
    protected static Enumeration consult_enum;

    public static void main(String[] stringArray) {
        new gJLogApplication();
    }

    public gJLogApplication() {
        Object object;
        this.setLayout(new GridLayout());
        try {
            object = Class.forName("com.apple.eawt.Application");
            Class<?> clazz = Class.forName("com.apple.eawt.ApplicationListener");
            Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationAdapter");
            Class<?> clazz3 = Class.forName("java.lang.reflect.InvocationHandler");
            Class<?> clazz4 = Class.forName("java.lang.reflect.Proxy");
            Method method = ((Class)object).getMethod("addApplicationListener", clazz);
            Method method2 = ((Class)object).getMethod("getApplication", new Class[0]);
            Method method3 = clazz4.getMethod("newProxyInstance", ClassLoader.class, Class[].class, clazz3);
            Object object2 = method2.invoke(object, new Object[0]);
            Object object3 = method3.invoke(clazz4, clazz2.getClassLoader(), clazz2.getInterfaces(), new eawtApplicationAdapter(this));
            method.invoke(object2, object3);
            useBuiltinApplicationMenu = true;
        }
        catch (Throwable throwable) {
            useBuiltinApplicationMenu = false;
        }
        query = new gQueryPanel(this.getPrologServices(), null, false);
        this.add(query);
        if (query_window == null) {
            query_window = this;
        }
        if (about_box == null) {
            about_box = new gAboutDialog(this, false);
        }
        if (debug_window == null) {
            debug_window = new gDebugWindow(this, false);
        }
        if (animation_window == null) {
            animation_window = new gAnimationWindow(this, false);
        }
        if (help_window == null) {
            help_window = new gHelpWindow(this, false);
        }
        this.setMenuBar(this.createMenuBar(this));
        object = this.getPrologServices();
        ((jPrologServices)object).addStateChangedListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gJLogApplication.this.updateToolMenuDebug();
            }
        });
        ((jPrologServices)object).addBeginQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                query_state = true;
                gJLogApplication.this.updateToolMenuDebug();
                gJLogApplication.this.updateToolMenuQuery();
                gJLogApplication.this.updateToolMenuReset(false);
                gJLogApplication.this.updateToolMenuConsultAll(false);
            }
        });
        ((jPrologServices)object).addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                query_state = false;
                gJLogApplication.this.updateToolMenuDebug();
                gJLogApplication.this.updateToolMenuQuery();
                gJLogApplication.this.updateToolMenuReset(true);
                gJLogApplication.this.updateToolMenuConsultAll(true);
            }
        });
        ((jPrologServices)object).addThreadStoppedListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                query_state = false;
                gJLogApplication.this.updateToolMenuDebug();
                gJLogApplication.this.updateToolMenuQuery();
                gJLogApplication.this.updateToolMenuReset(true);
                gJLogApplication.this.updateToolMenuConsultAll(true);
            }
        });
        ((jPrologServices)object).addBeginConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gJLogApplication.this.updateToolMenuReset(false);
                gJLogApplication.this.updateToolMenuConsultAll(false);
            }
        });
        ((jPrologServices)object).addEndConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gJLogApplication.this.updateToolMenuReset(true);
                gJLogApplication.this.updateToolMenuConsultAll(true);
                gJLogApplication.consultNext();
            }
        });
        object = this.getLocation();
        this.pack();
        this.setSize(640, 480);
        ((Point)object).move(30, 30);
        this.setLocation((Point)object);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                gJLogApplication.this.close();
            }
        });
        this.setTitle("JLog - Query");
        this.setVisible(true);
    }

    public MenuBar createMenuBar(iMenuServiceRequester iMenuServiceRequester2) {
        MenuItem menuItem;
        Menu menu;
        MenuBar menuBar = new MenuBar();
        if (!useBuiltinApplicationMenu) {
            menu = menuBar.add(new Menu("JLog"));
            menuItem = menu.add(new MenuItem("About JLog..."));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gJLogApplication.showAboutBox();
                }
            });
            menu.addSeparator();
            menuItem = menu.add(new MenuItem("Quit JLog", new MenuShortcut(81)));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gJLogApplication.quit();
                }
            });
        }
        menu = menuBar.add(new Menu("File"));
        menuItem = menu.add(new MenuItem("New KB", new MenuShortcut(78)));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new gConsultWindow(gJLogApplication.this, null);
            }
        });
        menuItem = menu.add(new MenuItem("Open KB...", new MenuShortcut(79)));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gJLogApplication.this.open(null);
            }
        });
        menu.addSeparator();
        menuItem = menu.add(new MenuItem("Close", new MenuShortcut(87)));
        menuItem.setActionCommand("close");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menuItem = menu.add(new MenuItem("Save", new MenuShortcut(83)));
        menuItem.setActionCommand("save");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menuItem = menu.add(new MenuItem("Save As...", new MenuShortcut(83, true)));
        menuItem.setActionCommand("saveas");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menu = menuBar.add(new Menu("Edit"));
        menuItem = menu.add(new MenuItem("Cut", new MenuShortcut(88)));
        menuItem.setActionCommand("cut");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menuItem = menu.add(new MenuItem("Copy", new MenuShortcut(67)));
        menuItem.setActionCommand("copy");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menuItem = menu.add(new MenuItem("Paste", new MenuShortcut(86)));
        menuItem.setActionCommand("paste");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menuItem = menu.add(new MenuItem("Select All", new MenuShortcut(65)));
        menuItem.setActionCommand("selectall");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menu.addSeparator();
        menuItem = menu.add(new MenuItem("Find...", new MenuShortcut(70)));
        menuItem.setActionCommand("find");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menuItem = menu.add(new MenuItem("Find Next", new MenuShortcut(71)));
        menuItem.setActionCommand("findnext");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menu.addSeparator();
        menuItem = menu.add(new MenuItem("Goto Line...", new MenuShortcut(76)));
        menuItem.setActionCommand("gotoline");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menu = menuBar.add(new Menu("Tool"));
        menuItem = menu.add(new MenuItem("Consult KB", new MenuShortcut(75)));
        menuItem.setActionCommand("consultkb");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menuItem = menu.add(new MenuItem("Consult All", new MenuShortcut(75, true)));
        menuItem.setActionCommand("consultallkb");
        menuItem.setEnabled(this.getPrologServices().isAvailable());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gJLogApplication.consultAll();
            }
        });
        menuItem = menu.add(new MenuItem("Reset KB", new MenuShortcut(82)));
        menuItem.setActionCommand("resetkb");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(this.getPrologServices().isAvailable());
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gJLogApplication.resetdb();
                }
            });
        }
        menu.addSeparator();
        menuItem = query.isPaused() ? menu.add(new MenuItem("Continue Query", null)) : menu.add(new MenuItem("Pause Query", null));
        menuItem.setEnabled(query_state);
        menuItem.setActionCommand("pauseq");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                query.pause();
                gJLogApplication.this.updateToolMenuQuery();
            }
        });
        menuItem = menu.add(new MenuItem("Stop Query", new MenuShortcut(46)));
        menuItem.setEnabled(query_state);
        menuItem.setActionCommand("stopq");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                query.stop();
                gJLogApplication.this.updateToolMenuQuery();
            }
        });
        menu.addSeparator();
        menuItem = menu.add(new CheckboxMenuItem("Debugger On", false));
        ((CheckboxMenuItem)menuItem).setState(this.getPrologServices().getDebugging());
        menuItem.setEnabled(!query_state);
        menuItem.setActionCommand("debug");
        ((CheckboxMenuItem)menuItem).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = gJLogApplication.this.getPrologServices().getDebugging();
                gJLogApplication.this.getPrologServices().setDebugging(!bl);
            }
        });
        menuItem = menu.add(new CheckboxMenuItem("Abort on Unknown Predicates", false));
        ((CheckboxMenuItem)menuItem).setState(!this.getPrologServices().getFailUnknownPredicate());
        menuItem.setEnabled(!query_state);
        menuItem.setActionCommand("unknownpredicate");
        ((CheckboxMenuItem)menuItem).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = gJLogApplication.this.getPrologServices().getFailUnknownPredicate();
                gJLogApplication.this.getPrologServices().setFailUnknownPredicate(!bl);
            }
        });
        menuItem = menu.add(new CheckboxMenuItem("Trace All", false));
        ((CheckboxMenuItem)menuItem).setState(false);
        menuItem.setEnabled(this.getPrologServices().getDebugging());
        menuItem.setActionCommand("trace");
        ((CheckboxMenuItem)menuItem).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = debug_window.getTraceState();
                debug_window.setTraceState(!bl);
                gJLogApplication.this.updateToolMenuDebug();
            }
        });
        menuItem = menu.add(new CheckboxMenuItem("Break on Failure", false));
        ((CheckboxMenuItem)menuItem).setState(false);
        menuItem.setEnabled(this.getPrologServices().getDebugging());
        menuItem.setActionCommand("break");
        ((CheckboxMenuItem)menuItem).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = debug_window.getBreakState();
                debug_window.setBreakState(!bl);
                gJLogApplication.this.updateToolMenuDebug();
            }
        });
        menu = menuBar.add(new Menu("Window"));
        menuItem = menu.add(new MenuItem("Close", new MenuShortcut(87)));
        menuItem.setActionCommand("close");
        if (!iMenuServiceRequester2.useMenuItem(menuItem)) {
            menuItem.setEnabled(false);
        }
        menu.addSeparator();
        menuItem = menu.add(new MenuItem("Query", null));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gJLogApplication.this.showQueryWindow();
            }
        });
        menuItem = menu.add(new MenuItem("Debug", null));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gJLogApplication.this.showDebugWindow();
            }
        });
        menuItem = menu.add(new MenuItem("Animation", null));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gJLogApplication.this.showAnimationWindow();
            }
        });
        menu.addSeparator();
        menu = new Menu("Help");
        menuBar.setHelpMenu(menu);
        menuItem = menu.add(new MenuItem("JLog Help", new MenuShortcut(63)));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gJLogApplication.this.showHelpWindow();
            }
        });
        return menuBar;
    }

    public boolean useMenuItem(MenuItem menuItem) {
        if (menuItem.getActionCommand() == "close") {
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gJLogApplication.this.close();
                }
            });
            return true;
        }
        return false;
    }

    protected static void showAboutBox() {
        if (about_box != null) {
            about_box.setVisible(true);
        }
    }

    protected void showQueryWindow() {
        if (query_window != null) {
            query_window.setVisible(true);
        }
    }

    protected void showDebugWindow() {
        if (debug_window != null) {
            debug_window.setVisible(true);
        }
    }

    protected void showAnimationWindow() {
        if (animation_window != null) {
            animation_window.setVisible(true);
        }
    }

    protected void showHelpWindow() {
        if (help_window != null) {
            help_window.setVisible(true);
        }
    }

    public void updateWindowMenu() {
        super.updateWindowMenu();
        this.updateWindowMenu(query_window.getMenuBar());
        this.updateWindowMenu(debug_window.getMenuBar());
        this.updateWindowMenu(animation_window.getMenuBar());
        this.updateWindowMenu(help_window.getMenuBar());
    }

    protected void updateToolMenuDebug() {
        boolean bl = this.getPrologServices().getDebugging();
        boolean bl2 = this.getPrologServices().getFailUnknownPredicate();
        boolean bl3 = debug_window.getTraceState();
        boolean bl4 = debug_window.getBreakState();
        this.updateToolMenuDebug(bl, !bl2, bl3, bl4, query_state);
    }

    public void updateToolMenuDebug(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super.updateToolMenuDebug(bl, bl2, bl3, bl4, bl5);
        this.updateToolMenuDebug(query_window.getMenuBar(), bl, bl2, bl3, bl4, bl5);
        this.updateToolMenuDebug(debug_window.getMenuBar(), bl, bl2, bl3, bl4, bl5);
        this.updateToolMenuDebug(animation_window.getMenuBar(), bl, bl2, bl3, bl4, bl5);
        this.updateToolMenuDebug(help_window.getMenuBar(), bl, bl2, bl3, bl4, bl5);
    }

    protected void updateToolMenuQuery() {
        this.updateToolMenuQuery(query_state, query.isPaused());
    }

    public void updateToolMenuQuery(boolean bl, boolean bl2) {
        super.updateToolMenuQuery(bl, bl2);
        this.updateToolMenuQuery(query_window.getMenuBar(), bl, bl2);
        this.updateToolMenuQuery(debug_window.getMenuBar(), bl, bl2);
        this.updateToolMenuQuery(animation_window.getMenuBar(), bl, bl2);
        this.updateToolMenuQuery(help_window.getMenuBar(), bl, bl2);
    }

    public void updateToolMenuReset(boolean bl) {
        this.updateToolMenuReset(query_window.getMenuBar(), bl);
        this.updateToolMenuReset(debug_window.getMenuBar(), bl);
        this.updateToolMenuReset(animation_window.getMenuBar(), bl);
        this.updateToolMenuReset(help_window.getMenuBar(), bl);
    }

    public void updateToolMenuConsultAll(boolean bl) {
        super.updateToolMenuConsultAll(bl);
        this.updateToolMenuConsultAll(query_window.getMenuBar(), bl);
        this.updateToolMenuConsultAll(debug_window.getMenuBar(), bl);
        this.updateToolMenuConsultAll(animation_window.getMenuBar(), bl);
        this.updateToolMenuConsultAll(help_window.getMenuBar(), bl);
    }

    protected int getToolMenuID() {
        int n = super.getToolMenuID();
        return useBuiltinApplicationMenu ? n - 1 : n;
    }

    protected int getWindowMenuID() {
        int n = super.getWindowMenuID();
        return useBuiltinApplicationMenu ? n - 1 : n;
    }

    protected void open(String string) {
        File file;
        Object object;
        if (string == null) {
            object = new FileDialog((Frame)this, "Open File", 0);
            if (this.getCurrentDirectory() == null) {
                ((FileDialog)object).setDirectory(System.getProperty("user.dir"));
            } else {
                ((FileDialog)object).setDirectory(this.getCurrentDirectory());
            }
            ((Dialog)object).setVisible(true);
            if (((FileDialog)object).getFile() == null) {
                return;
            }
            this.setCurrentDirectory(((FileDialog)object).getDirectory());
            file = new File(((FileDialog)object).getDirectory(), ((FileDialog)object).getFile());
        } else {
            file = new File(string);
        }
        object = file.getAbsolutePath();
        gConsultWindow gConsultWindow2 = this.getConsultWindow((String)object);
        if (gConsultWindow2 == null) {
            gConsultWindow2 = new gConsultWindow(this, null);
            gConsultWindow2.open(file);
        } else {
            gConsultWindow2.setVisible(true);
        }
    }

    protected boolean close() {
        if (query_window != null) {
            query_window.setVisible(false);
        }
        return true;
    }

    protected static boolean closeAll() {
        Vector vector = (Vector)kb_windows.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            gConsultWindow gConsultWindow2 = (gConsultWindow)enumeration.nextElement();
            if (gConsultWindow2.close()) continue;
            return false;
        }
        return true;
    }

    protected static boolean quit() {
        if (gJLogApplication.closeAll()) {
            System.exit(0);
            return true;
        }
        return false;
    }

    protected gConsultWindow getConsultWindow(String string) {
        Enumeration enumeration = kb_windows.elements();
        while (enumeration.hasMoreElements()) {
            gConsultWindow gConsultWindow2 = (gConsultWindow)enumeration.nextElement();
            String string2 = gConsultWindow2.getFilePath();
            if (string2 == null || !string2.equals(string)) continue;
            return gConsultWindow2;
        }
        return null;
    }

    protected static void consultAll() {
        consult_enum = ((Vector)kb_windows.clone()).elements();
        gJLogApplication.consultNext();
    }

    protected static void consultNext() {
        if (consult_enum == null) {
            return;
        }
        if (consult_enum.hasMoreElements()) {
            gConsultWindow gConsultWindow2 = (gConsultWindow)consult_enum.nextElement();
            gConsultWindow2.consult();
        } else {
            consult_enum = null;
        }
    }

    public static void resetdb() {
        PrintWriter printWriter;
        jPrologServices jPrologServices2 = base.getPrologServices();
        if (!jPrologServices2.start(new jResetDatabaseThread(jPrologServices2, printWriter = query.getOutputStream()))) {
            printWriter.println("reset failed. other events pending.");
            printWriter.flush();
        }
    }

    static {
        query_state = false;
        consult_enum = null;
    }

    protected class eawtApplicationAdapter
    implements InvocationHandler {
        protected gJLogApplication application = null;
        protected Method SetHandledMethod = null;

        public eawtApplicationAdapter(gJLogApplication gJLogApplication3) throws Throwable {
            Class<?> clazz = Class.forName("com.apple.eawt.ApplicationEvent");
            this.SetHandledMethod = clazz.getMethod("setHandled", Boolean.TYPE);
            this.application = gJLogApplication3;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("handleAbout")) {
                this.handleAbout(objectArray[0]);
            } else if (string.equals("handleOpenApplication")) {
                this.handleOpenApplication(objectArray[0]);
            } else if (string.equals("handleOpenFile")) {
                this.handleOpenFile(objectArray[0]);
            } else if (string.equals("handlePreferences")) {
                this.handlePreferences(objectArray[0]);
            } else if (string.equals("handlePrintFile")) {
                this.handlePrintFile(objectArray[0]);
            } else if (string.equals("handleQuit")) {
                this.handleQuit(objectArray[0]);
            }
            return null;
        }

        public void handleAbout(Object object) throws Throwable {
            eawtApplicationAdapter eawtApplicationAdapter2 = this;
            eawtApplicationAdapter2.application.showAboutBox();
            this.SetHandledMethod.invoke(object, Boolean.TRUE);
        }

        public void handleOpenApplication(Object object) throws Throwable {
        }

        public void handleOpenFile(Object object) throws Throwable {
        }

        public void handlePreferences(Object object) throws Throwable {
        }

        public void handlePrintFile(Object object) throws Throwable {
        }

        public void handleQuit(Object object) throws Throwable {
            eawtApplicationAdapter eawtApplicationAdapter2 = this;
            boolean bl = eawtApplicationAdapter2.application.quit();
            this.SetHandledMethod.invoke(object, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }
}

