/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Applet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.PrintWriter;
import ubc.cs.JLog.Applet.gButtonTabMenuAction;
import ubc.cs.JLog.Applet.gInputStreamTextField;
import ubc.cs.JLog.Applet.gOutputStreamTextArea;
import ubc.cs.JLog.Applet.gPrologServiceTextField;
import ubc.cs.JLog.Foundation.iPrologServiceText;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jRetryQueryThread;
import ubc.cs.JLog.Foundation.jUserQueryEvent;
import ubc.cs.JLog.Foundation.jUserQueryThread;

public class gQueryPanel
extends Panel {
    protected static final String QUERY = "   Query  ";
    protected static final String INPUT = "   Input  ";
    protected static final String RETRY = "   Retry  ";
    protected static final String PAUSE = "   Pause  ";
    protected static final String CONTINUE = " Continue ";
    protected static final String STOP = "   Stop  ";
    protected static final String CLEAR = "   Clear  ";
    protected static final String QLABEL = "Query";
    protected static final String INLABEL = "Input";
    protected static final String OUTLABEL = "Output";
    protected TextArea output = new TextArea("", 0, 0, 1);
    protected TextField input;
    protected TextField qinput;
    protected Button query;
    protected Button retry;
    protected Button pause;
    protected Button stop;
    protected Button enter;
    protected Button clear;
    protected Label outlabel;
    protected Label inlabel;
    protected Label qlabel;
    protected jPrologServices prolog;
    protected jRetryQueryThread thread = null;
    protected gButtonTabMenuAction debug_action = null;

    public gQueryPanel(jPrologServices jPrologServices2, String string, boolean bl) {
        this.output.setBackground(Color.white);
        this.output.setForeground(Color.black);
        this.output.setFont(new Font("Monospaced", 0, 12));
        this.outlabel = new Label(OUTLABEL, 0);
        this.input = new TextField();
        this.input.setBackground(Color.white);
        this.input.setForeground(Color.black);
        this.input.setEditable(false);
        this.inlabel = new Label(INLABEL, 0);
        this.enter = new Button(INPUT);
        this.enter.setBackground(Color.white);
        this.enter.setForeground(Color.black);
        this.enter.setEnabled(false);
        this.prolog = jPrologServices2;
        this.prolog.setDefaultOutput(this.getOutputStream());
        this.prolog.setDefaultInput(this.getInputStream());
        this.prolog.addRetryQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                jUserQueryEvent jUserQueryEvent2;
                if (jPrologServiceEvent2 instanceof jUserQueryEvent && (jUserQueryEvent2 = (jUserQueryEvent)jPrologServiceEvent2).getResult()) {
                    gQueryPanel.this.retry.setEnabled(true);
                    gQueryPanel.this.query.setEnabled(true);
                    gQueryPanel.this.qinput.setEditable(true);
                }
            }
        });
        this.prolog.addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gQueryPanel.this.reset_buttons();
            }
        });
        this.prolog.addBeginConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gQueryPanel.this.query.setEnabled(false);
            }
        });
        this.prolog.addEndConsultListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gQueryPanel.this.query.setEnabled(true);
            }
        });
        this.qinput = new TextField();
        this.qinput.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && gQueryPanel.this.qinput.isEditable() && gQueryPanel.this.query.isEnabled()) {
                    gQueryPanel.this.query();
                }
            }
        });
        this.qinput.setBackground(Color.white);
        this.qinput.setForeground(Color.black);
        this.qinput.setText(string);
        this.qlabel = new Label(QLABEL, 0);
        this.query = new Button(QUERY);
        this.query.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gQueryPanel.this.query();
            }
        });
        this.query.setBackground(Color.white);
        this.query.setForeground(Color.black);
        this.retry = new Button(RETRY);
        this.retry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gQueryPanel.this.retry();
            }
        });
        this.retry.setBackground(Color.white);
        this.retry.setForeground(Color.black);
        this.retry.setEnabled(false);
        this.pause = new Button(PAUSE);
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gQueryPanel.this.pause();
            }
        });
        this.pause.setBackground(Color.white);
        this.pause.setForeground(Color.black);
        this.pause.setEnabled(false);
        this.stop = new Button(STOP);
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gQueryPanel.this.stop();
            }
        });
        this.stop.setBackground(Color.white);
        this.stop.setForeground(Color.black);
        this.stop.setEnabled(false);
        this.clear = new Button(CLEAR);
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gQueryPanel.this.clear();
            }
        });
        this.clear.setBackground(Color.white);
        this.clear.setForeground(Color.black);
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.add((Component)new Panel(), "North");
        this.add((Component)new Panel(), "West");
        this.add((Component)new Panel(), "East");
        this.add((Component)new Panel(), "South");
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new GridLayout(1, 0));
        Panel panel4 = new Panel(new GridLayout(1, 0));
        Panel panel5 = new Panel(new GridLayout(1, 0));
        Panel panel6 = new Panel(new BorderLayout());
        Panel panel7 = new Panel(new BorderLayout());
        Panel panel8 = new Panel(new BorderLayout());
        Panel panel9 = new Panel(new BorderLayout());
        Panel panel10 = new Panel(new BorderLayout());
        Panel panel11 = new Panel(new BorderLayout());
        panel3.add(this.query);
        panel3.add(this.retry);
        if (bl) {
            panel3.add(this.pause);
            panel3.add(this.stop);
        }
        panel4.add(this.enter);
        panel5.add(this.clear);
        panel7.add((Component)panel3, "Center");
        panel7.add((Component)new Panel(), "West");
        panel8.add((Component)panel4, "Center");
        panel8.add((Component)new Panel(), "West");
        panel9.add((Component)panel5, "East");
        panel9.add((Component)new Panel(), "North");
        panel9.add((Component)new Panel(), "South");
        panel.add((Component)this.qinput, "Center");
        panel.add((Component)panel7, "East");
        panel.add((Component)this.qlabel, "North");
        panel2.add((Component)this.input, "Center");
        panel2.add((Component)panel8, "East");
        panel2.add((Component)this.inlabel, "North");
        panel6.add((Component)this.output, "Center");
        panel6.add((Component)panel9, "South");
        panel6.add((Component)this.outlabel, "North");
        panel11.add((Component)panel, "North");
        panel11.add((Component)panel2, "South");
        panel10.add((Component)panel11, "North");
        panel10.add((Component)panel6, "Center");
        this.add((Component)panel10, "Center");
    }

    public void setSelectDebugPanel(gButtonTabMenuAction gButtonTabMenuAction2) {
        this.debug_action = gButtonTabMenuAction2;
    }

    public iPrologServiceText getQinput() {
        return new gPrologServiceTextField(this.qinput);
    }

    public iPrologServiceText getInput() {
        return new gPrologServiceTextField(this.input);
    }

    public PrintWriter getOutputStream() {
        return new PrintWriter(new gOutputStreamTextArea(this.output));
    }

    public BufferedReader getInputStream() {
        return new BufferedReader(new gInputStreamTextField(this.input, this.enter));
    }

    public void pre_query() {
        this.input.setText("");
        this.pause.setLabel(PAUSE);
        this.qinput.setEditable(false);
        this.query.setEnabled(false);
        this.retry.setEnabled(false);
        this.pause.setEnabled(true);
        this.stop.setEnabled(true);
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.output.append("done.\n");
        }
    }

    public void set_thread(jRetryQueryThread jRetryQueryThread2) {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.output.append("done.\n");
        }
        this.thread = jRetryQueryThread2;
    }

    public void query() {
        this.pre_query();
        this.thread = new jUserQueryThread(this.prolog, this.getQinput(), this.getOutputStream());
        if (!this.prolog.start(this.thread)) {
            this.output.append("query failed. other events pending.\n");
        } else if (this.prolog.getDebugging() && this.debug_action != null) {
            this.debug_action.switchToCard();
        }
    }

    public void retry() {
        this.qinput.setEditable(false);
        this.query.setEnabled(false);
        this.retry.setEnabled(false);
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.retry();
            if (this.prolog.getDebugging() && this.debug_action != null) {
                this.debug_action.switchToCard();
            }
        } else {
            this.output.append("prolog thread not available.\n");
        }
    }

    public void pause() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.pause.setEnabled(false);
            this.output.append("prolog thread not available.\n");
        } else if (this.pause.getLabel() == PAUSE) {
            this.pause.setLabel(CONTINUE);
            this.thread.suspend();
        } else {
            this.pause.setLabel(PAUSE);
            this.thread.resume();
        }
    }

    public boolean isPaused() {
        return this.pause.getLabel() == CONTINUE;
    }

    public void stop() {
        this.reset_buttons();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
        }
        this.thread = null;
        this.output.append("done.\n");
    }

    protected void reset_buttons() {
        this.pause.setLabel(PAUSE);
        this.qinput.setEditable(true);
        this.input.setEditable(false);
        this.enter.setEnabled(false);
        this.query.setEnabled(true);
        this.retry.setEnabled(false);
        this.pause.setEnabled(false);
        this.stop.setEnabled(false);
    }

    public void clear() {
        this.output.setText("");
    }
}

