/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Applet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import ubc.cs.JLog.Foundation.iDebugGoalStack;
import ubc.cs.JLog.Foundation.jDebugProvedGoalStack;
import ubc.cs.JLog.Foundation.jDebugProverGoalStackEvent;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Terms.iNameArity;

public class gStackPanel
extends Panel {
    protected static final String STACKLABEL = " Stack";
    protected static final String DISPLAY = "Display";
    protected List stacklist;
    protected Label stacklabel;
    protected Button display;
    protected TextArea displayarea;
    protected jPrologServices prolog;
    protected iDebugGoalStack debugstack = null;
    protected Vector debugstack_vector;
    protected boolean use_proved_stack;

    public gStackPanel(String string, TextArea textArea, jPrologServices jPrologServices2, boolean bl) {
        this.displayarea = textArea;
        this.debugstack_vector = new Vector(0);
        this.use_proved_stack = bl;
        this.prolog = jPrologServices2;
        this.prolog.addDebugMessagesListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                if (jPrologServiceEvent2 instanceof jDebugProverGoalStackEvent && ((jDebugProverGoalStackEvent)jPrologServiceEvent2).isProvedStack() == gStackPanel.this.use_proved_stack) {
                    gStackPanel.this.debugProverStarted((jDebugProverGoalStackEvent)jPrologServiceEvent2);
                }
            }
        });
        this.prolog.addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gStackPanel.this.queryTerminated();
            }
        });
        this.prolog.addThreadStoppedListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent jPrologServiceEvent2) {
                gStackPanel.this.queryTerminated();
            }
        });
        this.stacklist = new List();
        this.stacklist.setBackground(Color.white);
        this.stacklist.setForeground(Color.black);
        this.stacklist.setMultipleMode(false);
        this.stacklist.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                gStackPanel.this.display.setEnabled(itemEvent.getStateChange() == 1);
            }
        });
        this.stacklist.setFont(new Font("Monospaced", 0, 10));
        this.stacklabel = new Label(string + STACKLABEL, 0);
        this.stacklist.setEnabled(false);
        this.display = new Button(DISPLAY);
        this.display.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = gStackPanel.this.stacklist.getSelectedIndex();
                if (n >= 0) {
                    gStackPanel.this.displayGoal(n);
                }
            }
        });
        this.display.setBackground(Color.white);
        this.display.setForeground(Color.black);
        this.display.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.add((Component)new Panel(), "North");
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new BorderLayout());
        panel.add((Component)this.display, "East");
        panel.add((Component)new Panel(), "North");
        panel2.add((Component)this.stacklist, "Center");
        panel2.add((Component)this.stacklabel, "North");
        panel3.add((Component)panel2, "Center");
        panel3.add((Component)panel, "South");
        this.add((Component)panel3, "Center");
    }

    public synchronized void debugProverStarted(jDebugProverGoalStackEvent jDebugProverGoalStackEvent2) {
        this.debugstack = jDebugProverGoalStackEvent2.getDebugGoalStack();
        this.debugstack_vector = this.debugstack.getStackCopy();
        this.internal_updateStackList(-1);
    }

    public synchronized void queryTerminated() {
        this.debugstack = null;
        this.debugstack_vector = new Vector(0);
        this.stacklist.removeAll();
    }

    public void enablePanel(boolean bl) {
        this.stacklist.setEnabled(bl);
        this.display.setEnabled(this.stacklist.getSelectedIndex() < 0 ? false : bl);
    }

    public synchronized void update() {
        if (this.debugstack != null) {
            this.updateStackVector();
        }
    }

    public void displayGoal(int n) {
        if (this.debugstack != null) {
            this.internal_displayGoal(this.debugstack_vector.elementAt(n));
        }
    }

    public synchronized void updateStackVector() {
        jGoal jGoal2;
        jGoal jGoal3;
        Vector vector = this.debugstack.getStackCopy();
        int n = -1;
        int n2 = Math.min(this.debugstack_vector.size(), vector.size());
        int n3 = 0;
        while (n3 < n2 && (jGoal3 = this.internal_getGoal(this.debugstack_vector.elementAt(n3))) == (jGoal2 = this.internal_getGoal(vector.elementAt(n3)))) {
            n = n3++;
        }
        this.debugstack_vector = vector;
        this.internal_updateStackList(n);
    }

    protected void internal_updateStackList(int n) {
        int n2;
        for (n2 = this.stacklist.getItemCount() - 1; n2 > n; --n2) {
            this.stacklist.remove(n2);
        }
        int n3 = this.debugstack_vector.size();
        for (n2 = n + 1; n2 < n3; ++n2) {
            this.stacklist.add(this.internal_getNameArityString(n2, this.internal_getGoal(this.debugstack_vector.elementAt(n2))), n2);
        }
        this.display.setEnabled(this.stacklist.getSelectedIndex() >= 0);
    }

    protected String internal_getNameArityString(int n, iNameArity iNameArity2) {
        return new String("[" + String.valueOf(n) + "] " + iNameArity2.getName() + "/" + String.valueOf(iNameArity2.getArity()));
    }

    protected jGoal internal_getGoal(Object object) {
        if (object instanceof jDebugProvedGoalStack.jDebugGoalItem) {
            return ((jDebugProvedGoalStack.jDebugGoalItem)object).getGoal();
        }
        return (jGoal)object;
    }

    protected void internal_displayGoal(Object object) {
        this.displayarea.append("\n" + this.internal_getDisplayString(this.debugstack_vector.indexOf(object), this.internal_getGoal(object)) + "\n");
    }

    protected String internal_getDisplayString(int n, jGoal jGoal2) {
        return "[g" + String.valueOf(n) + "] " + jGoal2.toString();
    }

    public synchronized int getGoalIndex(jGoal jGoal2) {
        if (this.debugstack != null) {
            int n = this.debugstack_vector.size();
            for (int i = 0; i < n; ++i) {
                if (jGoal2 != this.internal_getGoal(this.debugstack_vector.elementAt(i))) continue;
                return i;
            }
        }
        return -1;
    }
}

