/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Applet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ubc.cs.JLog.Applet.InvalidTraceItemException;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jRuleDefinitions;
import ubc.cs.JLog.Terms.iNameArity;

public class gTracePanel
extends Panel {
    protected static final String TRACELABEL = "Predicates";
    protected static final String TRACEUPDATE = " Update ";
    protected static final String HIDEBUTTON = "   Hide   ";
    protected static final String SHOWBUTTON = " Show All ";
    protected static final String SETTRACE = "  Set Trace  ";
    protected static final String UNSETTRACE = " Unset Trace ";
    protected static final String SETBREAK = " Set Break ";
    protected static final String UNSETBREAK = " Unset Break ";
    protected static final String CLEARTRACE = "Clear Traces";
    protected static final String CLEARBREAK = "Clear Breaks";
    protected List predlist;
    protected Label predlabel;
    protected Button hideshow;
    protected Button update;
    protected Button settrace;
    protected Button setbreak;
    protected Button cleartrace;
    protected Button clearbreak;
    protected jPrologServices prolog;
    protected Vector user_predicates = new Vector(0);
    protected Vector builtin_predicates = new Vector(0);
    protected Hashtable traceitem_hash = new Hashtable(1);

    public gTracePanel(jPrologServices jPrologServices2) {
        this.prolog = jPrologServices2;
        this.predlist = new List();
        this.predlist.setBackground(Color.white);
        this.predlist.setForeground(Color.black);
        this.predlist.setMultipleMode(false);
        this.predlist.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                gTracePanel.this.settrace.setEnabled(itemEvent.getStateChange() == 1);
                gTracePanel.this.setbreak.setEnabled(itemEvent.getStateChange() == 1);
                if (itemEvent.getStateChange() == 1) {
                    gTracePanel.this.updateSelectedState();
                }
            }
        });
        this.predlist.setEnabled(false);
        this.predlist.setFont(new Font("Monospaced", 0, 10));
        this.predlabel = new Label(TRACELABEL, 0);
        this.update = new Button(TRACEUPDATE);
        this.update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gTracePanel.this.updatePredicates();
            }
        });
        this.update.setBackground(Color.white);
        this.update.setForeground(Color.black);
        this.update.setEnabled(false);
        this.hideshow = new Button(SHOWBUTTON);
        this.hideshow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gTracePanel.this.toggleHideShow();
            }
        });
        this.hideshow.setBackground(Color.white);
        this.hideshow.setForeground(Color.black);
        this.hideshow.setEnabled(false);
        this.settrace = new Button(SETTRACE);
        this.settrace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gTracePanel.this.setTrace();
            }
        });
        this.settrace.setBackground(Color.white);
        this.settrace.setForeground(Color.black);
        this.settrace.setEnabled(false);
        this.setbreak = new Button(SETBREAK);
        this.setbreak.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gTracePanel.this.setBreakpoint();
            }
        });
        this.setbreak.setBackground(Color.white);
        this.setbreak.setForeground(Color.black);
        this.setbreak.setEnabled(false);
        this.cleartrace = new Button(CLEARTRACE);
        this.cleartrace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gTracePanel.this.clearTrace();
            }
        });
        this.cleartrace.setBackground(Color.white);
        this.cleartrace.setForeground(Color.black);
        this.cleartrace.setEnabled(false);
        this.clearbreak = new Button(CLEARBREAK);
        this.clearbreak.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gTracePanel.this.clearBreakpoint();
            }
        });
        this.clearbreak.setBackground(Color.white);
        this.clearbreak.setForeground(Color.black);
        this.clearbreak.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.add((Component)new Panel(), "North");
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new BorderLayout());
        Panel panel4 = new Panel(new GridLayout(4, 0));
        Panel panel5 = new Panel(new GridLayout(4, 0));
        panel4.add(this.update);
        panel4.add(new Panel());
        panel4.add(this.settrace);
        panel4.add(this.setbreak);
        panel5.add(this.hideshow);
        panel5.add(new Panel());
        panel5.add(this.cleartrace);
        panel5.add(this.clearbreak);
        panel.add((Component)panel5, "West");
        panel.add((Component)panel4, "East");
        panel.add((Component)new Panel(), "Center");
        panel.add((Component)new Panel(), "North");
        panel2.add((Component)this.predlist, "Center");
        panel2.add((Component)this.predlabel, "North");
        panel3.add((Component)panel2, "Center");
        panel3.add((Component)panel, "South");
        this.add((Component)panel3, "Center");
    }

    public gTraceItem getTraceInfo(iNameArity iNameArity2) {
        return (gTraceItem)this.traceitem_hash.get(this.internal_getNameArityString(iNameArity2));
    }

    public void setTrace() {
        try {
            gTraceItem gTraceItem2 = this.internal_getSelectedTraceItem();
            gTraceItem2.setTrace(!gTraceItem2.getTrace());
            this.internal_updatePredicateListItem(gTraceItem2);
        }
        catch (InvalidTraceItemException invalidTraceItemException) {
            // empty catch block
        }
        this.updateSelectedState();
    }

    public void setBreakpoint() {
        try {
            gTraceItem gTraceItem2 = this.internal_getSelectedTraceItem();
            gTraceItem2.setBreak(!gTraceItem2.getBreak());
            this.internal_updatePredicateListItem(gTraceItem2);
        }
        catch (InvalidTraceItemException invalidTraceItemException) {
            // empty catch block
        }
        this.updateSelectedState();
    }

    public void clearTrace() {
        gTraceItem gTraceItem2;
        Enumeration enumeration = this.user_predicates.elements();
        while (enumeration.hasMoreElements()) {
            gTraceItem2 = (gTraceItem)enumeration.nextElement();
            if (!gTraceItem2.getTrace()) continue;
            gTraceItem2.setTrace(false);
            this.internal_updatePredicateListItem(gTraceItem2);
        }
        enumeration = this.builtin_predicates.elements();
        while (enumeration.hasMoreElements()) {
            gTraceItem2 = (gTraceItem)enumeration.nextElement();
            if (!gTraceItem2.getTrace()) continue;
            gTraceItem2.setTrace(false);
            this.internal_updatePredicateListItem(gTraceItem2);
        }
        this.settrace.setLabel(SETTRACE);
        this.updateSelectedState();
    }

    public void clearBreakpoint() {
        gTraceItem gTraceItem2;
        Enumeration enumeration = this.user_predicates.elements();
        while (enumeration.hasMoreElements()) {
            gTraceItem2 = (gTraceItem)enumeration.nextElement();
            if (!gTraceItem2.getBreak()) continue;
            gTraceItem2.setBreak(false);
            this.internal_updatePredicateListItem(gTraceItem2);
        }
        enumeration = this.builtin_predicates.elements();
        while (enumeration.hasMoreElements()) {
            gTraceItem2 = (gTraceItem)enumeration.nextElement();
            if (!gTraceItem2.getBreak()) continue;
            gTraceItem2.setBreak(false);
            this.internal_updatePredicateListItem(gTraceItem2);
        }
        this.setbreak.setLabel(SETBREAK);
        this.updateSelectedState();
    }

    public void toggleHideShow() {
        gTraceItem gTraceItem2;
        this.hideshow.setLabel(this.hideshow.getLabel() == HIDEBUTTON ? SHOWBUTTON : HIDEBUTTON);
        try {
            gTraceItem2 = this.internal_getSelectedTraceItem();
        }
        catch (InvalidTraceItemException invalidTraceItemException) {
            gTraceItem2 = null;
        }
        this.internal_updatePredicateList(gTraceItem2);
    }

    public void updateSelectedState() {
        try {
            gTraceItem gTraceItem2 = this.internal_getSelectedTraceItem();
            this.settrace.setLabel(gTraceItem2.getTrace() ? UNSETTRACE : SETTRACE);
            this.setbreak.setLabel(gTraceItem2.getBreak() ? UNSETBREAK : SETBREAK);
        }
        catch (InvalidTraceItemException invalidTraceItemException) {
            this.settrace.setLabel(SETTRACE);
            this.setbreak.setLabel(SETBREAK);
            this.settrace.setEnabled(false);
            this.setbreak.setEnabled(false);
        }
    }

    public void enableDebugging() {
        this.updatePredicates();
        this.predlist.setEnabled(true);
        this.hideshow.setEnabled(true);
        this.update.setEnabled(true);
        this.settrace.setEnabled(this.predlist.getSelectedIndex() >= 0);
        this.setbreak.setEnabled(this.predlist.getSelectedIndex() >= 0);
        this.updateSelectedState();
        this.cleartrace.setEnabled(true);
        this.clearbreak.setEnabled(true);
    }

    public void disableDebugging() {
        this.predlist.setEnabled(false);
        this.hideshow.setEnabled(false);
        this.update.setEnabled(false);
        this.settrace.setEnabled(false);
        this.setbreak.setEnabled(false);
        this.cleartrace.setEnabled(false);
        this.clearbreak.setEnabled(false);
        this.user_predicates = new Vector(0);
        this.builtin_predicates = new Vector(0);
        this.traceitem_hash = new Hashtable(1);
        this.internal_updatePredicateList(null);
    }

    public void updatePredicates() {
        gTraceItem gTraceItem2;
        iNameArity iNameArity2;
        gTraceItem gTraceItem3;
        try {
            gTraceItem3 = this.internal_getSelectedTraceItem();
        }
        catch (InvalidTraceItemException invalidTraceItemException) {
            gTraceItem3 = null;
        }
        Enumeration enumeration = this.prolog.getPredicateRegistry().enumPredicates();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            iNameArity2 = (iNameArity)enumeration.nextElement();
            try {
                gTraceItem2 = this.internal_getNameArityTraceItem(iNameArity2);
                this.internal_sortInsertNameArity(vector, new gTraceItem(iNameArity2, gTraceItem2.getTrace(), gTraceItem2.getBreak()));
            }
            catch (InvalidTraceItemException invalidTraceItemException) {
                this.internal_sortInsertNameArity(vector, new gTraceItem(iNameArity2, false, false));
            }
        }
        enumeration = this.prolog.getKnowledgeBase().enumDefinitions();
        while (enumeration.hasMoreElements()) {
            iNameArity2 = (jRuleDefinitions)enumeration.nextElement();
            if (!((jRuleDefinitions)iNameArity2).isBuiltin()) continue;
            try {
                gTraceItem2 = this.internal_getNameArityTraceItem(iNameArity2);
                this.internal_sortInsertNameArity(vector, new gTraceItem(iNameArity2, gTraceItem2.getTrace(), gTraceItem2.getBreak()));
            }
            catch (InvalidTraceItemException invalidTraceItemException) {
                this.internal_sortInsertNameArity(vector, new gTraceItem(iNameArity2, false, false));
            }
        }
        enumeration = this.prolog.getKnowledgeBase().enumDefinitions();
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            iNameArity2 = (jRuleDefinitions)enumeration.nextElement();
            if (((jRuleDefinitions)iNameArity2).isBuiltin()) continue;
            try {
                gTraceItem2 = this.internal_getNameArityTraceItem(iNameArity2);
                this.internal_sortInsertNameArity(vector2, new gTraceItem(iNameArity2, gTraceItem2.getTrace(), gTraceItem2.getBreak()));
            }
            catch (InvalidTraceItemException invalidTraceItemException) {
                this.internal_sortInsertNameArity(vector2, new gTraceItem(iNameArity2, false, false));
            }
        }
        this.user_predicates = vector2;
        this.builtin_predicates = vector;
        this.traceitem_hash = new Hashtable(this.user_predicates.size() + this.builtin_predicates.size() + 1);
        enumeration = this.user_predicates.elements();
        while (enumeration.hasMoreElements()) {
            iNameArity2 = (gTraceItem)enumeration.nextElement();
            this.traceitem_hash.put(this.internal_getNameArityString(iNameArity2), iNameArity2);
        }
        enumeration = this.builtin_predicates.elements();
        while (enumeration.hasMoreElements()) {
            iNameArity2 = (gTraceItem)enumeration.nextElement();
            this.traceitem_hash.put(this.internal_getNameArityString(iNameArity2), iNameArity2);
        }
        this.internal_updatePredicateList(gTraceItem3);
    }

    protected synchronized void internal_updatePredicateList(iNameArity iNameArity2) {
        this.predlist.removeAll();
        Enumeration enumeration = this.user_predicates.elements();
        while (enumeration.hasMoreElements()) {
            this.predlist.add(((gTraceItem)enumeration.nextElement()).toString());
        }
        if (this.hideshow.getLabel() == HIDEBUTTON) {
            enumeration = this.builtin_predicates.elements();
            while (enumeration.hasMoreElements()) {
                this.predlist.add(((gTraceItem)enumeration.nextElement()).toString());
            }
        }
        if (iNameArity2 != null) {
            try {
                this.predlist.select(this.internal_getNameArityIndex(iNameArity2));
            }
            catch (InvalidTraceItemException invalidTraceItemException) {
                // empty catch block
            }
        }
        this.updateSelectedState();
    }

    protected synchronized void internal_updatePredicateListItem(gTraceItem gTraceItem2) {
        try {
            int n = this.internal_getTraceIndex(gTraceItem2);
            int n2 = this.predlist.getSelectedIndex();
            this.predlist.replaceItem(gTraceItem2.toString(), n);
            this.predlist.select(n2);
        }
        catch (InvalidTraceItemException invalidTraceItemException) {
            // empty catch block
        }
    }

    protected boolean internal_sortCompareGreaterThan(iNameArity iNameArity2, iNameArity iNameArity3) {
        String string;
        String string2 = iNameArity2.getName().toLowerCase();
        int n = string2.compareTo(string = iNameArity3.getName().toLowerCase());
        if (n == 0) {
            return iNameArity2.getArity() > iNameArity3.getArity();
        }
        return n > 0;
    }

    protected void internal_sortInsertNameArity(Vector vector, iNameArity iNameArity2) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (!this.internal_sortCompareGreaterThan((iNameArity)vector.elementAt(i), iNameArity2)) continue;
            vector.insertElementAt(iNameArity2, i);
            return;
        }
        vector.insertElementAt(iNameArity2, vector.size());
    }

    protected synchronized gTraceItem internal_getSelectedTraceItem() {
        return this.internal_getTraceItem(this.predlist.getSelectedIndex());
    }

    protected synchronized gTraceItem internal_getTraceItem(int n) {
        if (n < 0) {
            throw new InvalidTraceItemException();
        }
        if (n < this.user_predicates.size()) {
            return (gTraceItem)this.user_predicates.elementAt(n);
        }
        if ((n -= this.user_predicates.size()) < this.builtin_predicates.size()) {
            return (gTraceItem)this.builtin_predicates.elementAt(n);
        }
        throw new InvalidTraceItemException();
    }

    protected synchronized int internal_getTraceIndex(gTraceItem gTraceItem2) {
        int n = this.user_predicates.indexOf(gTraceItem2);
        if (n >= 0) {
            return n;
        }
        if (this.hideshow.getLabel() != HIDEBUTTON) {
            throw new InvalidTraceItemException();
        }
        n = this.builtin_predicates.indexOf(gTraceItem2);
        if (n >= 0) {
            return n + this.user_predicates.size();
        }
        throw new InvalidTraceItemException();
    }

    protected synchronized gTraceItem internal_getNameArityTraceItem(iNameArity iNameArity2) {
        gTraceItem gTraceItem2;
        Enumeration enumeration = this.user_predicates.elements();
        while (enumeration.hasMoreElements()) {
            gTraceItem2 = (gTraceItem)enumeration.nextElement();
            if (!iNameArity2.getName().equals(gTraceItem2.getName()) || iNameArity2.getArity() != gTraceItem2.getArity()) continue;
            return gTraceItem2;
        }
        enumeration = this.builtin_predicates.elements();
        while (enumeration.hasMoreElements()) {
            gTraceItem2 = (gTraceItem)enumeration.nextElement();
            if (!iNameArity2.getName().equals(gTraceItem2.getName()) || iNameArity2.getArity() != gTraceItem2.getArity()) continue;
            return gTraceItem2;
        }
        throw new InvalidTraceItemException();
    }

    protected synchronized int internal_getNameArityIndex(iNameArity iNameArity2) {
        gTraceItem gTraceItem2;
        int n;
        int n2 = this.user_predicates.size();
        for (n = 0; n < n2; ++n) {
            gTraceItem2 = (gTraceItem)this.user_predicates.elementAt(n);
            if (!iNameArity2.getName().equals(gTraceItem2.getName()) || iNameArity2.getArity() != gTraceItem2.getArity()) continue;
            return n;
        }
        if (this.hideshow.getLabel() != HIDEBUTTON) {
            throw new InvalidTraceItemException();
        }
        n2 = this.builtin_predicates.size();
        for (n = 0; n < n2; ++n) {
            gTraceItem2 = (gTraceItem)this.builtin_predicates.elementAt(n);
            if (!iNameArity2.getName().equals(gTraceItem2.getName()) || iNameArity2.getArity() != gTraceItem2.getArity()) continue;
            return n;
        }
        throw new InvalidTraceItemException();
    }

    protected String internal_getNameArityString(iNameArity iNameArity2) {
        return new String(iNameArity2.getName() + "/" + String.valueOf(iNameArity2.getArity()));
    }

    public class gTraceItem
    implements iNameArity {
        protected iNameArity item;
        protected boolean traceon;
        protected boolean breakon;

        public gTraceItem(iNameArity iNameArity2, boolean bl, boolean bl2) {
            this.item = iNameArity2;
            this.traceon = bl;
            this.breakon = bl2;
        }

        public void setTrace(boolean bl) {
            this.traceon = bl;
        }

        public void setBreak(boolean bl) {
            this.breakon = bl;
        }

        public boolean getTrace() {
            return this.traceon;
        }

        public boolean getBreak() {
            return this.breakon;
        }

        public String getName() {
            return this.item.getName();
        }

        public int getArity() {
            return this.item.getArity();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[" + (this.traceon ? "T" : " ") + (this.breakon ? "B" : " ") + "] ");
            stringBuffer.append(this.item.getName() + "/" + String.valueOf(this.item.getArity()));
            return stringBuffer.toString();
        }
    }
}

