package org.deft.extension.test;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.deft.extension.test.testutil.TestUtil;
import org.deft.extension.tools.astlayouter.ASTLayout;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.junit.Before;
import org.junit.Test;

public class ASTLayoutTest {

	private List<TokenNode> nodes;

	@Before
	public void init() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		nodes = ast.serialize();
	}

	@Test
	public void testmoveLinesAfterLineZero() {
		ASTLayout tl = new ASTLayout(nodes);
		String expected = TestUtil.tokenNodeListToString(nodes, "\n");
		int line = 1;
		int offset = 0;
		tl.moveLinesAfterLine(line, offset);
		String actual = TestUtil.tokenNodeListToString(nodes, "\n");
		assertEquals(expected, actual);

	}

	@Test
	public void testMoveColZero() {
		ASTLayout tl = new ASTLayout(nodes);
		String expected = TestUtil.tokenNodeListToString(nodes, "\n");
		int line = 1;
		int offset = 0;
		tl.moveCol(line, offset);
		String actual = TestUtil.tokenNodeListToString(nodes, "\n");
		assertEquals(expected, actual);
	}
}
