package org.deft.extension.test;

import static org.junit.Assert.assertEquals;

import java.util.LinkedList;
import java.util.List;

import org.deft.extension.XPath;
import org.deft.extension.test.testutil.TestLoader;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.extension.tools.astmodifier.ASTModifier;
import org.deft.extension.tools.astmodifier.comment.CommentTypeVisitor;
import org.deft.extension.tools.astmodifier.syntax.NoSyntaxCheckerVisitor;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.DecoratorSelection;
import org.junit.Test;

public class ASTModifierTest {
	private String lineBreak = "\n";
	private String testRoot = "resources/test/ASTModifierTest/";
	private String file;
	private String expectedList;
	private String expectedXML;
	private String pick;
	private String insert;
	private String commentType;
	private int width;
	private String expectedTree;
	private int spacesBefore;
	private int spacesAfter;
	private int linesBefore;
	private int linesAfter;

	@Test
	public void testAppendAfter() throws Exception {

		TestLoader tests = new TestLoader(testRoot + "after.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {

			initTestParams(test);

			TreeNode ast = TestUtil.readFileInAST(file);
			List<TreeNode> p = getInserts();

			ASTModifier app = new ASTModifier(new NoSyntaxCheckerVisitor());
			app.appendAfter(ast, p.get(0), new XPath(insert), linesBefore,
					linesAfter, spacesBefore, spacesAfter);

			assertTest(test, ast);
		}

	}

	private void assertTest(org.deft.extension.test.testutil.Test test,
			TreeNode ast) {
		String actualTree = TestUtil.astToTreeString(ast);

		String actualList = TestUtil.tokenNodeListToString(ast.serialize(),
				lineBreak);

		assertEquals(test.getName() + " failed", expectedTree, actualTree
				.trim());
		assertEquals(test.getName() + " failed", expectedList, actualList);

		DecoratorSelection decorators = new DecoratorSelection();
		// Test ohne Template!!!
		// appendFC.addTemplate(new AppendTemplate());
		String actualXML = TestUtil.astToXMLString(ast, decorators);
		assertEquals(test.getName() + " failed", expectedXML, actualXML);
	}

	private void initTestParams(org.deft.extension.test.testutil.Test test)
			throws Exception {
		file = test.getParamterAsString("input");
		expectedList = test.getParamterAsString("expectedList").trim();
		expectedTree = test.getParamterAsString("expectedTree").trim();
		expectedXML = test.getParamterAsString("expectedXML").trim().replace(
				"\n", "\r\n");
		pick = test.getParamterAsString("pick");
		insert = test.getParamterAsString("insert");
		spacesBefore = test.getParamterAsInteger("spacesBefore");
		spacesAfter = test.getParamterAsInteger("spacesAfter");
		linesBefore = test.getParamterAsInteger("linesBefore");
		linesAfter = test.getParamterAsInteger("linesAfter");
	}

	@Test
	public void testAppendBefore() throws Exception {

		TestLoader tests = new TestLoader(testRoot + "before.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {

			initTestParams(test);

			TreeNode ast = TestUtil.readFileInAST(file);
			List<TreeNode> p = getInserts();

			ASTModifier app = new ASTModifier(new NoSyntaxCheckerVisitor());
			app.appendBefore(ast, p.get(0), new XPath(insert), linesBefore,
					linesAfter, spacesBefore, spacesAfter);

			assertTest(test, ast);
		}

	}

	private List<TreeNode> getInserts() throws Exception {
		TreeNode ast2 = TestUtil.readFileInAST(file);

		List<TreeNode> p = new LinkedList<TreeNode>();
		p = ast2.executeXPathQuery(pick);
		return p;
	}

	@Test
	public void testReplace() throws Exception {

		TestLoader tests = new TestLoader(testRoot + "replace.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {

			initTestParams(test);

			TreeNode ast = TestUtil.readFileInAST(file);
			List<TreeNode> p = getInserts();
			ASTModifier app = new ASTModifier(new NoSyntaxCheckerVisitor());
			app.replace(ast, p.get(0), new XPath(insert), linesBefore,
					linesAfter, spacesBefore, spacesAfter);

			assertTest(test, ast);
		}

	}

	@Test
	public void testReplaceList() throws Exception {

		TestLoader tests = new TestLoader(testRoot + "replaceList.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {

			initTestParams(test);
			width = test.getParamterAsInteger("width");

			TreeNode ast = TestUtil.readFileInAST(file);
			List<TreeNode> p = getInserts();
			ASTModifier app = new ASTModifier(new NoSyntaxCheckerVisitor());
			app.replaceList(ast, p.get(0), new XPath(insert), width,
					linesBefore, linesAfter, spacesBefore, spacesAfter);

			assertTest(test, ast);
		}

	}

	@Test
	public void testChangeToComment() throws Exception {

		TestLoader tests = new TestLoader(testRoot + "changeToComment.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {

			file = test.getParamterAsString("input");
			expectedList = test.getParamterAsString("expectedList").trim();
			expectedTree = test.getParamterAsString("expectedTree").trim();
			expectedXML = test.getParamterAsString("expectedXML").trim()
					.replace("\n", "\r\n");
			insert = test.getParamterAsString("insert");
			width = test.getParamterAsInteger("width");
			commentType = test.getParamterAsString("commentType");

			TreeNode ast = TestUtil.readFileInAST(file);

			ASTModifier app = new ASTModifier(new NoSyntaxCheckerVisitor());
			app.changeToComment(ast, new XPath(insert), width,
					(CommentTypeVisitor) Class.forName(commentType)
							.newInstance());

			assertTest(test, ast);
		}

	}

}
