package org.deft.extension.test;

import static org.junit.Assert.assertEquals;

import org.deft.extension.decoration.style.StyleInformation;
import org.deft.extension.test.testutil.ExtensionRepository;
import org.deft.extension.test.testutil.StyleLoader;
import org.deft.extension.test.testutil.TestLoader;
import org.junit.Test;

public class ExtensionRepositoryTest {
	private String testRoot = "resources/test/";

	private String expected;
	private String style;
	private ExtensionRepository rep = ExtensionRepository.getInstance();

	@Test
	public void testClearRepository() {
		StyleLoader.loadStylesFromFile("resources/mix.style");
		rep.clearRepository();

		String expected = "{}";
		String actual = rep.getXPathsByIdent(StyleInformation.IDENT).toString();

		assertEquals(expected, actual);
	}

	@Test
	public void testRepository() throws Exception {
		rep.addLoader(new StyleLoader());
		TestLoader tests = new TestLoader(testRoot + "rep.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {

			initTest(test);

			String actual = rep.toString();

			assertEquals(test.getName() + " failed", expected, actual);

		}

	}

	private void initTest(org.deft.extension.test.testutil.Test test)
			throws Exception {
		expected = test.getParamterAsString("expected").trim().replace("\n",
				"\r\n");
		style = test.getParamterAsString("style");
		rep.clearRepository();

		StyleLoader.loadStylesFromString(style);
	}

	@Test
	public void testGetXPathByIdentFromExtensionRepository() {
		rep.clearRepository();

		StyleLoader.loadStylesFromFile("resources/mix.style");

		String expected = "{//MethodDeclaration/*=[(CSSDeclaration - font-weight:bold;), (CSSClass - method contrast)], //Identifier=[(CSSDeclaration - text-decoration:underline; color:red;)], //ClassDeclaration=[(CSSClass - class)]}";
		String actual = rep.getXPathsByIdent(StyleInformation.IDENT).toString();

		assertEquals(expected, actual);
	}
}
