package org.deft.extension.test;

import static org.junit.Assert.assertEquals;

import org.deft.extension.test.testutil.TestLoader;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.language.java.parser.JavaParser;
import org.deft.repository.ast.TreeNode;
import org.junit.Test;

public class JavaParserTest {
	private String testRoot = "resources/test/";

	@Test
	public void testParser() throws Exception {
		TestLoader tests = new TestLoader(testRoot
				+ "javaparser.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {

			String param = test.getParamterAsString("param");
			String expected = test.getParamterAsString("expected").trim();

			TreeNode tn = JavaParser.get(param);
			String actual;
			if (tn.getName().equals("Comment")) {
				actual = tn.getTextContent();
			} else {
				actual = TestUtil.astToTreeString(tn);
			}
			assertEquals("Error in " + test.getName(), expected, actual.trim());

		}
	}
}
