package org.deft.extension.test;

import static org.junit.Assert.assertEquals;

import org.deft.extension.decoration.style.container.StyleDecoratorException;
import org.deft.extension.test.testutil.ExtensionRepository;
import org.deft.extension.test.testutil.StyleLoader;
import org.junit.Test;

public class StyleLoaderTest {

	@Test
	public void testLoadFromFile() {
		ExtensionRepository rep = ExtensionRepository.getInstance();
		rep.clearRepository();
		StyleLoader.loadStylesFromFile("resources/sample.style");

		String actual = rep.toString();
		String expected = "{//MethodDeclaration/*=[(CSSDeclaration - font-weight:bold;)], //Identifier=[(CSSDeclaration - text-decoration:underline; color:red;)]}";

		assertEquals(expected, actual);
	}

	@Test
	public void testLoadFromString() {
		ExtensionRepository rep = ExtensionRepository.getInstance();
		rep.clearRepository();
		String styles = "Torg.deft.extension.decoration.style.container.CssDeclarationStyleContainer\n"
				+ "//MethodDeclaration/* -> font-weight:bold;\n"
				+ "//Identifier -> text-decoration:underline; color:red;";
		StyleLoader.loadStylesFromString(styles);

		String actual = rep.toString();
		String expected = "{//MethodDeclaration/*=[(CSSDeclaration - font-weight:bold;)], //Identifier=[(CSSDeclaration - text-decoration:underline; color:red;)]}";

		assertEquals(expected, actual);
	}

	@Test
	public void testDifferendStyleContainerFromFile() {
		ExtensionRepository rep = ExtensionRepository.getInstance();
		rep.clearRepository();
		StyleLoader.loadStylesFromFile("resources/mix.style");

		String actual = rep.toString();
		String expected = "{//MethodDeclaration/*=[(CSSDeclaration - font-weight:bold;), (CSSClass - method contrast)], //Identifier=[(CSSDeclaration - text-decoration:underline; color:red;)], //ClassDeclaration=[(CSSClass - class)]}";

		assertEquals(expected, actual);
	}

	@Test
	public void testDifferendStyleContainerFromString() {
		ExtensionRepository rep = ExtensionRepository.getInstance();
		rep.clearRepository();
		String styles = "Torg.deft.extension.decoration.style.container.CssDeclarationStyleContainer\n"
				+ "//MethodDeclaration/* -> font-weight:bold;\n"
				+ "//Identifier -> text-decoration:underline; color:red;\n"
				+ "Torg.deft.extension.decoration.style.container.CssClassStyleContainer\n"
				+ "//ClassDeclaration -> class\n"
				+ "//MethodDeclaration/* -> method contrast";
		StyleLoader.loadStylesFromString(styles);

		String actual = rep.toString();
		String expected = "{//MethodDeclaration/*=[(CSSDeclaration - font-weight:bold;), (CSSClass - method contrast)], //Identifier=[(CSSDeclaration - text-decoration:underline; color:red;)], //ClassDeclaration=[(CSSClass - class)]}";

		assertEquals(expected, actual);
	}

	@Test(expected = StyleDecoratorException.class)
	public void testMissingContainerType() {
		ExtensionRepository rep = ExtensionRepository.getInstance();
		rep.clearRepository();
		String styles = "//MethodDeclaration/* -> font-weight:bold;";
		StyleLoader.loadStylesFromString(styles);
	}

	@Test(expected = StyleDecoratorException.class)
	public void testInvalidContainerType() {
		ExtensionRepository rep = ExtensionRepository.getInstance();
		rep.clearRepository();
		String styles = "Torg.deft.extension.decoration.style.container.Container\n"
				+ "//MethodDeclaration/* -> font-weight:bold;";
		StyleLoader.loadStylesFromString(styles);
	}
}
