package org.deft.extension.test.decoration;

import static org.junit.Assert.assertEquals;

import org.deft.extension.decoration.style.container.CssClassStyleContainer;
import org.deft.extension.test.testutil.TestLoader;
import org.junit.Test;

public class CssClassStyleContainerTest {
	private String testRoot = "resources/test/";

	@Test
	public void testParse() throws Exception {
		TestLoader tests = new TestLoader(testRoot
				+ "CssClassStyleContainer.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {
			String input = test.getParamterAsString("input");
			String expected = test.getParamterAsString("expected");

			CssClassStyleContainer cssSC = new CssClassStyleContainer();
			cssSC.parse(input);
			String actual = cssSC.renderValueAttribute();

			assertEquals(test.getName() + " failed", expected, actual);
		}
	}

	@Test
	public void testContructor() throws Exception {
		TestLoader tests = new TestLoader(testRoot
				+ "CssClassStyleContainer.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {
			String input = test.getParamterAsString("input");
			String expected = test.getParamterAsString("expected");

			CssClassStyleContainer cssSC = new CssClassStyleContainer(input);
			String actual = cssSC.renderValueAttribute();

			assertEquals(test.getName() + " failed", expected, actual);
		}
	}

}
