package org.deft.extension.test.decoration;

import static org.junit.Assert.assertEquals;

import org.deft.extension.decoration.style.container.CssDeclarationStyleContainer;
import org.deft.extension.decoration.style.container.StyleDecoratorException;
import org.deft.extension.test.testutil.TestLoader;
import org.junit.Test;

public class CssDeclarationStyleContainerTest {

	private String testRoot = "resources/test/";

	@Test
	public void testParse() throws Exception {
		TestLoader tests = new TestLoader(testRoot
				+ "CssDeclarationStyleContainer.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {
			String input = test.getParamterAsString("input");
			String expected = test.getParamterAsString("expected");

			CssDeclarationStyleContainer cssSC = new CssDeclarationStyleContainer();
			cssSC.parse(input);
			String actual = cssSC.renderValueAttribute();

			assertEquals(test.getName() + " failed", expected, actual);
		}
	}

	@Test
	public void testContructor() throws Exception {
		TestLoader tests = new TestLoader(testRoot
				+ "CssDeclarationStyleContainer.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {
			String input = test.getParamterAsString("input");
			String expected = test.getParamterAsString("expected");

			CssDeclarationStyleContainer cssSC = new CssDeclarationStyleContainer(
					input);
			String actual = cssSC.renderValueAttribute();

			assertEquals(test.getName() + " failed", expected, actual);
		}
	}

	@Test(expected = StyleDecoratorException.class)
	public void testParserFailed() {
		String errorString = "noCSS";
		@SuppressWarnings("unused")
		CssDeclarationStyleContainer oldSC = new CssDeclarationStyleContainer(
				errorString);

	}

}
