package org.deft.extension.test.decoration;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.deft.extension.decoration.protect.ProtectedDecorator;
import org.deft.extension.decoration.protect.ProtectedInformation;
import org.deft.extension.test.testutil.ExtensionRepository;
import org.deft.extension.test.testutil.TestLoader;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.DecoratorSelection;
import org.junit.Test;

public class ProtectedDecorationManuelTest {
	private DecoratorSelection decorators;
	private String testRoot = "resources/test/decoration/";

	@Test
	public void testManual() throws Exception {

		TestLoader tests = new TestLoader(testRoot
				+ "protected_manual.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {
			String input = test.getParamterAsString("input");
			String expected = test.getParamterAsString("expected").trim()
					.replace("\n", "\r\n");
			String xpath = test.getParamterAsString("xpath");
			String xpath2 = test.getParamterAsString("xpath2");

			decorators = new DecoratorSelection();
			decorators.addDecorator(new ProtectedDecorator());

			TreeNode ast = org.deft.extension.test.testutil.TestUtil
					.readFileInAST(input);

			ExtensionRepository.getInstance().clearRepository();
			addInformations(ast, xpath);
			addInformations(ast, xpath2);

			String actual = TestUtil.astToXMLString(ast, decorators);

			assertEquals(test.getName() + " failed", expected, actual);
		}

	}

	private void addInformations(TreeNode ast, String xpath) {
		if (xpath == null) {
			return;
		}

		List<TreeNode> targets = ast.executeXPathQuery(xpath);

		for (TreeNode tn : targets) {
			ProtectedInformation pi = new ProtectedInformation();
			tn.addInformation(pi);
		}
	}
}
