package org.deft.extension.test.decoration;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.deft.extension.decoration.style.StyleDecorator;
import org.deft.extension.decoration.style.StyleInformation;
import org.deft.extension.decoration.style.container.CssDeclarationStyleContainer;
import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.extension.test.testutil.ExtensionRepository;
import org.deft.extension.test.testutil.TestLoader;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.DecoratorSelection;
import org.deft.repository.ast.decoration.NodeInformation;
import org.junit.Test;

public class StyleDecorationManuelTest {
	private DecoratorSelection styleCF;
	private String testRoot = "resources/test/decoration/";

	@Test
	public void testManual() throws Exception {

		TestLoader tests = new TestLoader(testRoot + "style_manual.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {
			String input = test.getParamterAsString("input");
			String expected = test.getParamterAsString("expected").trim()
					.replace("\n", "\r\n");
			String xpath = test.getParamterAsString("xpath");
			String style = test.getParamterAsString("style");
			String xpath2 = test.getParamterAsString("xpath2");
			String style2 = test.getParamterAsString("style2");
			styleCF = new DecoratorSelection();
			styleCF.addDecorator(new StyleDecorator());
			TreeNode ast = org.deft.extension.test.testutil.TestUtil
					.readFileInAST(input);

			ExtensionRepository.getInstance().clearRepository();
			addInformations(ast, xpath, style);
			addInformations(ast, xpath2, style2);

			String actual = TestUtil.astToXMLString(ast, styleCF);

			assertEquals(test.getName() + " failed", expected, actual);
		}

	}

	private void addInformations(TreeNode ast, String xpath, String style) {
		if (xpath == null) {
			return;
		}
		StyleContainer sc = new CssDeclarationStyleContainer(style);

		List<TreeNode> targets = ast.executeXPathQuery(xpath);

		for (TreeNode tn : targets) {
			NodeInformation ni = tn.getInformation(StyleInformation.IDENT);
			StyleInformation si;
			if (ni == null) {
				si = new StyleInformation();
			} else {
				si = (StyleInformation) ni;
			}

			si.addStyleContainer(sc.clone());
			tn.addInformation(si);
		}
	}

}
