package org.deft.extension.test.decoration;

import static org.junit.Assert.assertEquals;

import org.deft.extension.decoration.style.StyleInformation;
import org.deft.extension.decoration.style.container.CssClassStyleContainer;
import org.deft.extension.decoration.style.container.CssDeclarationStyleContainer;
import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.repository.ast.decoration.Ident;
import org.junit.Test;

public class StyleInformationTest {

	@Test
	public void testGetIdent() {

		Ident actual = new StyleInformation().getIdent();
		Ident expected = StyleInformation.IDENT;

		assertEquals(expected, actual);
	}

	@Test
	public void testOneContainer() {
		CssDeclarationStyleContainer expected = new CssDeclarationStyleContainer();

		StyleInformation si = new StyleInformation();
		si.addStyleContainer(expected);
		StyleContainer actual = si.getStyleContainer(0);

		assertEquals(expected, actual);

	}

	@Test
	public void testTwoContainer() {
		CssDeclarationStyleContainer expected1 = new CssDeclarationStyleContainer();
		CssClassStyleContainer expected2 = new CssClassStyleContainer();

		StyleInformation si = new StyleInformation();
		si.addStyleContainer(expected1);
		si.addStyleContainer(expected2);
		StyleContainer actual1 = si.getStyleContainer(0);
		StyleContainer actual2 = si.getStyleContainer(1);
		assertEquals(expected1, actual1);
		assertEquals(expected2, actual2);
	}

}
