package org.deft.extension.test.decoration;

import static org.junit.Assert.assertEquals;

import org.deft.extension.decoration.style.StyleDecorator;
import org.deft.extension.test.testutil.ExtensionRepository;
import org.deft.extension.test.testutil.StyleLoader;
import org.deft.extension.test.testutil.TestLoader;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.DecoratorSelection;
import org.junit.Test;

public class StyleTemplateAutomaticTest {
	private String testRoot = "resources/test/decoration/";

	// Needed for nicer test init
	private String input;
	private String expected;
	private String style;
	private DecoratorSelection styleCF;
	private ExtensionRepository rep = ExtensionRepository.getInstance();

	@Test
	public void testAutomatic() throws Exception {
		rep.addLoader(new StyleLoader());
		TestLoader tests = new TestLoader(testRoot + "style_automatic.testcase");
		for (org.deft.extension.test.testutil.Test test : tests) {
			initTest(test);

			TreeNode ast = org.deft.extension.test.testutil.TestUtil
					.readFileInAST(input);
			rep.process(ast);

			String actual = TestUtil.astToXMLString(ast, styleCF);

			assertEquals(test.getName() + " failed", expected, actual);

		}

	}

	private void initTest(org.deft.extension.test.testutil.Test test)
			throws Exception {

		input = test.getParamterAsString("input");
		expected = test.getParamterAsString("expected").trim().replace("\n",
				"\r\n");
		style = test.getParamterAsString("style");

		styleCF = new DecoratorSelection();
		styleCF.addDecorator(new StyleDecorator());

		rep.clearRepository();

		StyleLoader.loadStylesFromString(style);
	}
}
