package org.deft.extension.test.invoker;

import static org.junit.Assert.assertEquals;

import java.util.HashMap;
import java.util.Map;

import org.deft.extension.persistence.PersistenceException;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.extension.tools.astlayouter.ASTLayouterInvoker;
import org.deft.repository.ast.TreeNode;
import org.junit.Test;

public class ASTLayouterInvokerTest {
	@Test
	public void testInvokeSpaces() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTLayouterInvoker inv = new ASTLayouterInvoker();
		Map<String, String> params = new HashMap<String, String>();
		String location = "/CompilationUnit/PackageDeclaration/PACKAGE";
		params.put("method", "insertSpacesBefore");
		params.put("offset", "3");
		params.put("location", location);
		inv.invoke(ast, params);
		assertEquals(ast.executeXPathQuery(location).get(0).getFirstToken()
				.getCol(), 4);

	}

	@Test
	public void testInvokeTrim() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTLayouterInvoker inv = new ASTLayouterInvoker();
		Map<String, String> params = new HashMap<String, String>();
		String location = "/CompilationUnit/PackageDeclaration/QualifiedName";
		params.put("method", "trim");
		params.put("location", location);
		inv.invoke(ast, params);
		assertEquals(ast.executeXPathQuery(location).get(0).getFirstToken()
				.getCol(), 8);

	}

	@Test
	public void testInvokeIndent() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTLayouterInvoker inv = new ASTLayouterInvoker();
		Map<String, String> params = new HashMap<String, String>();
		String location = "/CompilationUnit/PackageDeclaration/PACKAGE";
		params.put("method", "indentRelative");
		params.put("offset", "3");
		params.put("startlocation", location);
		params.put("endlocation", location);
		inv.invoke(ast, params);
		assertEquals(ast.executeXPathQuery(location).get(0).getFirstToken()
				.getCol(), 4);

	}

	@Test(expected = PersistenceException.class)
	public void testInvokeMissingMethod() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTLayouterInvoker inv = new ASTLayouterInvoker();
		Map<String, String> params = new HashMap<String, String>();
		inv.invoke(ast, params);
	}

	@Test(expected = PersistenceException.class)
	public void testInvokeMissingOffset() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTLayouterInvoker inv = new ASTLayouterInvoker();
		Map<String, String> params = new HashMap<String, String>();
		params.put("method", "insertSpacesBefore");
		inv.invoke(ast, params);

	}

	@Test(expected = PersistenceException.class)
	public void testInvokeMissingLocation() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTLayouterInvoker inv = new ASTLayouterInvoker();
		Map<String, String> params = new HashMap<String, String>();
		params.put("method", "insertSpacesBefore");
		params.put("offset", "0");
		inv.invoke(ast, params);

	}

}
