package org.deft.extension.test.invoker;

import static org.junit.Assert.assertEquals;

import java.util.HashMap;
import java.util.Map;

import org.deft.extension.persistence.PersistenceException;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.extension.tools.astmodifier.ASTModifierInvoker;
import org.deft.repository.ast.TreeNode;
import org.junit.Test;

public class ASTModifierInvokerTest {
	// insert="..." raises an error and appends it as a comment

	@Test
	public void testInvokeAppend() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTModifierInvoker inv = new ASTModifierInvoker();
		Map<String, String> params = new HashMap<String, String>();
		params.put("method", "appendAfter");
		params.put("location", "/CompilationUnit/PackageDeclaration/PACKAGE");
		params.put("insert", "...");
		inv.invoke(ast, params);

		assertEquals(ast.executeXPathQuery(
				"/CompilationUnit/PackageDeclaration/Comment").size(), 1);
	}

	@Test
	public void testInvokeAppendNumber() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTModifierInvoker inv = new ASTModifierInvoker();
		Map<String, String> params = new HashMap<String, String>();
		params.put("method", "appendAfter");
		params.put("location", "/CompilationUnit/PackageDeclaration/PACKAGE");
		params.put("insert", "...");
		params.put("spacesBefore", "1");
		params.put("spacesAfter", "1");
		params.put("linesBefore", "1");
		params.put("linesAfter", "1");

		inv.invoke(ast, params);

		assertEquals(ast.executeXPathQuery(
				"/CompilationUnit/PackageDeclaration/Comment").size(), 1);
	}

	@Test
	public void testInvokeComment() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTModifierInvoker inv = new ASTModifierInvoker();
		Map<String, String> params = new HashMap<String, String>();
		params.put("method", "changeToComment");
		params.put("location", "/CompilationUnit/PackageDeclaration/PACKAGE");
		params
				.put("commentType",
						"org.deft.extension.tools.astmodifier.comment.JavaBlockCommentVisitor");
		inv.invoke(ast, params);

		assertEquals(ast.executeXPathQuery(
				"/CompilationUnit/PackageDeclaration/Comment").size(), 1);
	}

	@Test(expected = PersistenceException.class)
	public void testInvokeMissingMethod() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTModifierInvoker inv = new ASTModifierInvoker();
		Map<String, String> params = new HashMap<String, String>();
		inv.invoke(ast, params);
	}

	@Test(expected = PersistenceException.class)
	public void testInvokeMissingLocation() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTModifierInvoker inv = new ASTModifierInvoker();
		Map<String, String> params = new HashMap<String, String>();
		params.put("method", "appendAfter");
		inv.invoke(ast, params);
	}

	@Test(expected = PersistenceException.class)
	public void testInvokeMissingInsert() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ASTModifierInvoker inv = new ASTModifierInvoker();
		Map<String, String> params = new HashMap<String, String>();
		params.put("method", "appendAfter");
		params.put("location", "/CompilationUnit/PackageDeclaration/PACKAGE");
		inv.invoke(ast, params);
	}
}
